/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.domain.Profile;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ProfileHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Profile> {
    private String domain;
    private String name;
    private ProfileDefinition.Status status;
    private String version;
    private ImmutableMap.Builder<String, ProfileDefinition.Status> definitions = ImmutableMap.builder();
    private final StringBuilder currentText = new StringBuilder();
    private boolean inDefinition = false;
    private String definitionVersion = null;
    private ProfileDefinition.Status definitionStatus = null;

    public Profile getResult() {
        Profile result = Profile.create(this.domain, this.name, this.status, this.version, (Map<String, ProfileDefinition.Status>)this.definitions.build());
        this.resetState();
        return result;
    }

    private void resetState() {
        this.version = null;
        this.name = null;
        this.domain = null;
        this.status = null;
        this.definitions = ImmutableMap.builder();
        this.inDefinition = false;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Definition")) {
            this.inDefinition = true;
        }
    }

    public void endElement(String ignoredURI, String ignoredName, String qName) {
        if (qName.equals("Definition")) {
            this.inDefinition = false;
            this.definitions.put((Object)this.definitionVersion, (Object)this.definitionStatus);
        } else if (this.inDefinition) {
            if (qName.equals("Status")) {
                String value = this.currentText.toString().trim();
                this.definitionStatus = value.isEmpty() ? null : ProfileDefinition.Status.fromString(value);
            } else if (qName.equals("Version")) {
                this.definitionVersion = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            }
        } else if (qName.equals("DomainName")) {
            this.domain = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Status")) {
            String value = this.currentText.toString().trim();
            this.status = value.isEmpty() ? null : ProfileDefinition.Status.fromString(value);
        } else if (qName.equals("EnabledVersion")) {
            this.version = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

