/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpoint;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ProfileDefinitionEndpointHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ProfileDefinitionEndpoint> {
    private String domain;
    private ProfileDefinition.Status status;
    private ProfileDefinition.HealthStatus healthStatus;
    private ProfileDefinitionEndpoint.Type type;
    private String location;
    private Integer weight;
    private Integer min;
    private final StringBuilder currentText = new StringBuilder();

    public ProfileDefinitionEndpoint getResult() {
        ProfileDefinitionEndpoint result = ProfileDefinitionEndpoint.create(this.domain, this.status, this.healthStatus, this.type, this.location, this.weight, this.min);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.location = null;
        this.domain = null;
        this.min = null;
        this.status = null;
        this.type = null;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) {
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("DomainName")) {
            this.domain = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Status")) {
            String value = this.currentText.toString().trim();
            this.status = value.isEmpty() ? null : ProfileDefinition.Status.fromString(value);
        } else if (qName.equals("MonitorStatus")) {
            String value = this.currentText.toString().trim();
            this.healthStatus = value.isEmpty() ? null : ProfileDefinition.HealthStatus.fromString(value);
        } else if (qName.equals("Type")) {
            String value = this.currentText.toString().trim();
            this.type = value.isEmpty() ? ProfileDefinitionEndpoint.Type.CLOUDSERVICE : ProfileDefinitionEndpoint.Type.fromString(value);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Weight")) {
            String value = this.currentText.toString().trim();
            this.weight = value.isEmpty() ? 1 : Integer.parseInt(value);
        } else if (qName.equals("MinChildEndpoints")) {
            String value = this.currentText.toString().trim();
            this.min = value.isEmpty() ? 1 : Integer.parseInt(value);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

