/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

final class OSImageHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<OSImage> {
    private String name;
    private String location;
    private String affinityGroup;
    private String label;
    private String category;
    private String description;
    private String imageFamily;
    private OSImage.Type os;
    private URI mediaLink;
    private Integer logicalSizeInGB;
    private final List<String> eulas = Lists.newArrayList();
    private Date publishedDate;
    private String iconUri;
    private String smallIconUri;
    private URI privacyUri;
    private URI pricingDetailLink;
    private String recommendedVMSize;
    private Boolean isPremium;
    private Boolean showInGui;
    private String publisherName;
    private final StringBuilder currentText = new StringBuilder();

    OSImageHandler() {
    }

    public OSImage getResult() {
        OSImage result = OSImage.create(this.name, this.location, this.affinityGroup, this.label, this.description, this.imageFamily, this.category, this.os, this.publisherName, this.mediaLink, this.logicalSizeInGB, (List<String>)ImmutableList.copyOf(this.eulas));
        this.resetState();
        return result;
    }

    private void resetState() {
        this.publisherName = null;
        this.recommendedVMSize = null;
        this.smallIconUri = null;
        this.iconUri = null;
        this.imageFamily = null;
        this.category = null;
        this.description = null;
        this.label = null;
        this.affinityGroup = null;
        this.name = null;
        this.os = null;
        this.publisherName = null;
        this.mediaLink = null;
        this.logicalSizeInGB = null;
        this.publishedDate = null;
        this.pricingDetailLink = null;
        this.privacyUri = null;
        this.isPremium = null;
        this.showInGui = null;
        this.eulas.clear();
        this.location = null;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        String uri;
        if (qName.equals("OS")) {
            String osText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (osText != null) {
                this.os = OSImage.Type.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText).toUpperCase());
            }
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("LogicalSizeInGB")) {
            String gb = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (gb != null) {
                this.logicalSizeInGB = Integer.parseInt(gb);
            }
        } else if (qName.equals("Description")) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Category")) {
            this.category = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AffinityGroup")) {
            this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PublisherName")) {
            this.publisherName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("MediaLink")) {
            String link = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (link != null) {
                this.mediaLink = URI.create(link);
            }
        } else if (qName.equals("Eula")) {
            String eulaField = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (eulaField != null) {
                for (String eula : Splitter.on((char)';').split((CharSequence)eulaField)) {
                    if ((eula = Strings.emptyToNull((String)eula.trim())) == null) continue;
                    this.eulas.add(eula);
                }
            }
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("ImageFamily")) {
            this.imageFamily = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PublishedDate")) {
            String date = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (date != null) {
                this.publishedDate = new SimpleDateFormatDateService().iso8601DateOrSecondsDateParse(date);
            }
        } else if (qName.equals("IconUri")) {
            this.iconUri = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("SmallIconUri")) {
            this.smallIconUri = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PrivacyUri")) {
            String uri2 = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (uri2 != null) {
                this.privacyUri = URI.create(uri2);
            }
        } else if (qName.equals("RecommendedVMSize")) {
            this.recommendedVMSize = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("IsPremium")) {
            String premium = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (premium != null) {
                this.isPremium = Boolean.valueOf(premium);
            }
        } else if (qName.equals("ShowInGui")) {
            String show = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (show != null) {
                this.showInGui = Boolean.valueOf(show);
            }
        } else if (qName.equals("PublisherName")) {
            this.publisherName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PricingDetailLink") && (uri = SaxUtils.currentOrNull((StringBuilder)this.currentText)) != null) {
            this.pricingDetailLink = URI.create(uri);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

