/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import java.net.URI;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

final class OSConfigHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<VMImage.OSDiskConfiguration> {
    private VMImage.OSDiskConfiguration.Caching hostCaching;
    private String name;
    private VMImage.OSDiskConfiguration.OSState osState;
    private OSImage.Type os;
    private Integer logicalDiskSizeInGB;
    private URI mediaLink;
    private String ioType;
    private final StringBuilder currentText = new StringBuilder();

    OSConfigHandler() {
    }

    public VMImage.OSDiskConfiguration getResult() {
        return VMImage.OSDiskConfiguration.create(this.name, this.hostCaching, this.osState, this.os, this.mediaLink, this.logicalDiskSizeInGB, this.ioType);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("HostCaching")) {
            String hostCachingText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (hostCachingText != null) {
                this.hostCaching = OSConfigHandler.parseHostCache(hostCachingText);
            }
        } else if (qName.equals("OSState")) {
            String osStateText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (osStateText != null) {
                this.osState = VMImage.OSDiskConfiguration.OSState.valueOf(osStateText.toUpperCase());
            }
        } else if (qName.equals("OS")) {
            String osText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (osText != null) {
                this.os = OSImage.Type.valueOf(osText.toUpperCase());
            }
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("LogicalDiskSizeInGB")) {
            String gb = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (gb != null) {
                this.logicalDiskSizeInGB = Integer.parseInt(gb);
            }
        } else if (qName.equals("MediaLink")) {
            String link = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (link != null) {
                this.mediaLink = URI.create(link);
            }
        } else if (qName.equals("IOType")) {
            this.ioType = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    private static VMImage.OSDiskConfiguration.Caching parseHostCache(String hostCaching) {
        try {
            return VMImage.OSDiskConfiguration.Caching.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, hostCaching));
        }
        catch (IllegalArgumentException e) {
            return VMImage.OSDiskConfiguration.Caching.NONE;
        }
    }

    private static VMImage.OSDiskConfiguration.OSState parseOSState(String osState) {
        try {
            return VMImage.OSDiskConfiguration.OSState.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, osState));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

