/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azurecompute.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.domain.Rule;
import org.jclouds.azurecompute.xml.RuleHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkSecurityGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NetworkSecurityGroup> {
    private String name;
    private String label;
    private String location;
    private NetworkSecurityGroup.State state;
    private List<Rule> rules = Lists.newArrayList();
    private boolean inRule;
    private final RuleHandler ruleHandler = new RuleHandler();
    private final StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("Rule")) {
            this.inRule = true;
        }
    }

    public NetworkSecurityGroup getResult() {
        NetworkSecurityGroup result = NetworkSecurityGroup.create(this.name, this.label, this.location, this.state, this.rules);
        this.location = null;
        this.label = null;
        this.name = null;
        this.state = null;
        this.rules = Lists.newArrayList();
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Rule")) {
            this.inRule = false;
            this.rules.add(this.ruleHandler.getResult());
        } else if (this.inRule) {
            this.ruleHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("State")) {
            this.state = NetworkSecurityGroup.State.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inRule) {
            this.ruleHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

