/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.azurecompute.xml.StorageServiceHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public class ListStorageServicesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<StorageService>> {
    private boolean inStorageService;
    private final StorageServiceHandler storageServiceHandler;
    private final ImmutableList.Builder<StorageService> storageAccounts = ImmutableList.builder();

    @Inject
    ListStorageServicesHandler(StorageServiceHandler storageServiceHandler) {
        this.storageServiceHandler = storageServiceHandler;
    }

    public List<StorageService> getResult() {
        return this.storageAccounts.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if ("StorageService".equals(qName)) {
            this.inStorageService = true;
        }
        if (this.inStorageService) {
            this.storageServiceHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if ("StorageService".equals(qName)) {
            this.inStorageService = false;
            this.storageAccounts.add((Object)this.storageServiceHandler.getResult());
        } else if (this.inStorageService) {
            this.storageServiceHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inStorageService) {
            this.storageServiceHandler.characters(ch, start, length);
        }
    }
}

