/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.Profile;
import org.jclouds.azurecompute.xml.ProfileHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListProfilesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<Profile>> {
    private boolean inProfile;
    private final ProfileHandler profileHandler;
    private final ImmutableList.Builder<Profile> profiles = ImmutableList.builder();

    @Inject
    ListProfilesHandler(ProfileHandler profileHandler) {
        this.profileHandler = profileHandler;
    }

    public List<Profile> getResult() {
        return this.profiles.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Profile")) {
            this.inProfile = true;
        }
        if (this.inProfile) {
            this.profileHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Profile")) {
            this.inProfile = false;
            this.profiles.add((Object)this.profileHandler.getResult());
        } else if (this.inProfile) {
            this.profileHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inProfile) {
            this.profileHandler.characters(ch, start, length);
        }
    }
}

