/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.CloudService;
import org.jclouds.azurecompute.xml.CloudServiceHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListCloudServicesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<CloudService>> {
    private boolean inHostedService;
    private final CloudServiceHandler cloudServiceHandler;
    private final ImmutableList.Builder<CloudService> hostedServices = ImmutableList.builder();

    @Inject
    ListCloudServicesHandler(CloudServiceHandler cloudServiceHandler) {
        this.cloudServiceHandler = cloudServiceHandler;
    }

    public List<CloudService> getResult() {
        return this.hostedServices.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("HostedService")) {
            this.inHostedService = true;
        }
        if (this.inHostedService) {
            this.cloudServiceHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("HostedService")) {
            this.inHostedService = false;
            this.hostedServices.add((Object)this.cloudServiceHandler.getResult());
        } else if (this.inHostedService) {
            this.cloudServiceHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inHostedService) {
            this.cloudServiceHandler.characters(ch, start, length);
        }
    }
}

