/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.Role;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class InputEndpointHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Role.ConfigurationSet.InputEndpoint> {
    private Integer localPort;
    private String name;
    private Integer port;
    private String protocol;
    private Boolean enableDirectServerReturn;
    private String vip;
    private String loadBalancerName;
    private Role.ConfigurationSet.InputEndpoint.LoadBalancerProbe loadBalancerProbe;
    private Integer idleTimeoutInMinutes;
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
    }

    public Role.ConfigurationSet.InputEndpoint getResult() {
        Role.ConfigurationSet.InputEndpoint result = Role.ConfigurationSet.InputEndpoint.create(this.name, this.protocol, this.localPort, this.port, this.vip, this.enableDirectServerReturn, this.loadBalancerName, this.loadBalancerProbe, this.idleTimeoutInMinutes);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.protocol = null;
        this.vip = null;
        this.name = null;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        String enableDirectServerReturnText;
        if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Vip")) {
            this.vip = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("LocalPort")) {
            String localPortText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (localPortText != null) {
                this.localPort = Integer.parseInt(localPortText);
            }
        } else if (qName.equals("Port")) {
            String portText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (portText != null) {
                this.port = Integer.parseInt(portText);
            }
        } else if (qName.equals("Protocol")) {
            this.protocol = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("EnableDirectServerReturn") && (enableDirectServerReturnText = SaxUtils.currentOrNull((StringBuilder)this.currentText)) != null) {
            this.enableDirectServerReturn = Boolean.parseBoolean(enableDirectServerReturnText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

