/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.CloudServiceProperties;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.xml.DeploymentHandler;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class CloudServicePropertiesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<CloudServiceProperties> {
    private String name;
    private URI url;
    private String location;
    private String affinityGroup;
    private String label;
    private String description;
    private CloudServiceProperties.Status status;
    private Date created;
    private Date lastModified;
    private Map<String, String> extendedProperties = Maps.newLinkedHashMap();
    private List<Deployment> deploymentList = Lists.newArrayList();
    private boolean inHostedServiceProperties;
    private boolean inDeployment;
    private String propertyName;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateService;
    private final DeploymentHandler deploymentHandler;

    @Inject
    CloudServicePropertiesHandler(DateService dateService, DeploymentHandler deploymentHandler) {
        this.dateService = dateService;
        this.deploymentHandler = deploymentHandler;
    }

    public CloudServiceProperties getResult() {
        CloudServiceProperties result = CloudServiceProperties.create(this.name, this.url, this.location, this.affinityGroup, this.label, this.description, this.status, this.created, this.lastModified, (Map<String, String>)ImmutableMap.copyOf(this.extendedProperties), (List<Deployment>)ImmutableList.copyOf(this.deploymentList));
        this.resetState();
        return result;
    }

    private void resetState() {
        this.label = null;
        this.affinityGroup = null;
        this.location = null;
        this.description = null;
        this.name = null;
        this.status = null;
        this.lastModified = null;
        this.created = null;
        this.extendedProperties.clear();
        this.inHostedServiceProperties = false;
        this.propertyName = null;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) {
        if (qName.equals("HostedServiceProperties")) {
            this.inHostedServiceProperties = true;
        } else if (qName.equals("Deployment")) {
            this.inDeployment = true;
        }
        if (this.inDeployment) {
            this.deploymentHandler.startElement(ignoredUri, ignoredLocalName, qName, ignoredAttributes);
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        String link;
        if (qName.equals("HostedServiceProperties")) {
            this.inHostedServiceProperties = false;
        } else if (this.inHostedServiceProperties) {
            if (qName.equals("DateCreated")) {
                this.created = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("DateLastModified")) {
                this.lastModified = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("Status")) {
                String statusText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
                if (statusText != null) {
                    this.status = CloudServicePropertiesHandler.status(statusText);
                }
            } else if (qName.equals("Name")) {
                this.propertyName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Value")) {
                this.extendedProperties.put(this.propertyName, SaxUtils.currentOrNull((StringBuilder)this.currentText));
                this.propertyName = null;
            } else if (qName.equals("Description")) {
                this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Location")) {
                this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("AffinityGroup")) {
                this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Label")) {
                this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            }
        } else if (qName.equals("ServiceName")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Deployment")) {
            this.deploymentList.add(this.deploymentHandler.getResult());
            this.inDeployment = false;
        } else if (this.inDeployment) {
            this.deploymentHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("Url") && (link = SaxUtils.currentOrNull((StringBuilder)this.currentText)) != null) {
            this.url = URI.create(link);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDeployment) {
            this.deploymentHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    private static CloudServiceProperties.Status status(String status) {
        try {
            return CloudServiceProperties.Status.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, status));
        }
        catch (IllegalArgumentException e) {
            return CloudServiceProperties.Status.UNRECOGNIZED;
        }
    }
}

