/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jclouds.azurecompute.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.domain.Rule;

public class NetworkSecurityGroups {
    public static List<Rule> getCustomRules(NetworkSecurityGroup networkSecurityGroup) {
        List<Rule> rules = networkSecurityGroup.rules();
        return FluentIterable.from(rules).filter(Predicates.notNull()).filter((Predicate)new Predicate<Rule>(){

            public boolean apply(Rule rule) {
                return rule.isDefault() == null || rule.isDefault() == false;
            }
        }).toSortedList((Comparator)new Comparator<Rule>(){

            @Override
            public int compare(Rule r1, Rule r2) {
                int p2;
                int p1 = Integer.parseInt(r1.priority());
                return p1 < (p2 = Integer.parseInt(r2.priority())) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
    }

    public static int getFirstAvailablePriority(List<Rule> rules) {
        int priority = rules.isEmpty() ? 100 : Integer.parseInt(Collections.max(rules, new Comparator<Rule>(){

            @Override
            public int compare(Rule rule1, Rule rule2) {
                return Integer.valueOf(rule1.priority()).compareTo(Integer.valueOf(rule2.priority()));
            }
        }).priority()) + 1;
        return priority;
    }

    public static String createRuleName(String format, int fromPort, int toPort) {
        return String.format(format, fromPort, toPort);
    }
}

