/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.domain.Operation;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class ConflictManagementPredicate
implements Predicate<String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private AzureComputeApi api;
    private Predicate<String> operationSucceeded;
    private final long timeout = 600000L;
    private final long interval = 15000L;

    public ConflictManagementPredicate() {
        this(null);
    }

    public ConflictManagementPredicate(AzureComputeApi api) {
        this(api, (Predicate<String>)Predicates2.retry((Predicate)new OperationSucceededPredicate(api), (long)600L, (long)5L, (long)5L, (TimeUnit)TimeUnit.SECONDS));
    }

    public ConflictManagementPredicate(AzureComputeApi api, long timeout, long period, long maxPeriod, TimeUnit unit) {
        this(api, (Predicate<String>)Predicates2.retry((Predicate)new OperationSucceededPredicate(api), (long)timeout, (long)period, (long)maxPeriod, (TimeUnit)unit));
    }

    public ConflictManagementPredicate(AzureComputeApi api, Predicate<String> operationSucceeded) {
        this.api = api;
        this.operationSucceeded = operationSucceeded;
    }

    protected String operation() {
        throw new UnsupportedOperationException();
    }

    public final boolean apply(String input) {
        Operation operation = null;
        String requestId = null;
        boolean retry = true;
        long now = System.currentTimeMillis();
        long end = now + 600000L;
        while (retry && now < end) {
            try {
                requestId = this.operation();
                this.logger.debug("Executed operation on %s", new Object[]{input});
                if (requestId == null) {
                    this.logger.debug("No request id available. Assume operation succeeded.", new Object[0]);
                    return true;
                }
                operation = this.api.getOperationApi().get(requestId);
                this.logger.debug("Operation %s status: %s", new Object[]{operation.id(), operation.status().name()});
                if (operation.status() == Operation.Status.FAILED) {
                    if (operation.httpStatusCode() == 409 || operation.httpStatusCode() == 500) {
                        this.logger.info("Retry operation %s with (code %d)", new Object[]{operation.id(), operation.httpStatusCode()});
                    } else {
                        this.logger.info("Not retriable operation %s (code %d)", new Object[]{operation.id(), operation.httpStatusCode()});
                        retry = false;
                    }
                } else {
                    this.logger.debug("Tracking for operation %s ...", new Object[]{operation.id()});
                    retry = false;
                }
            }
            catch (UnsupportedOperationException e) {
                requestId = input;
                retry = false;
                this.logger.debug("Tracking for operation %s ...", new Object[]{input});
            }
            catch (RuntimeException e) {
                HttpResponseException re;
                Object object = e instanceof HttpResponseException ? (HttpResponseException)HttpResponseException.class.cast(e) : (re = e.getCause() instanceof HttpResponseException ? (HttpResponseException)HttpResponseException.class.cast(e.getCause()) : null);
                if (re == null) {
                    throw e;
                }
                HttpResponse res = re.getResponse();
                this.logger.info("[%s (%d)] Performing operation on %s", new Object[]{res.getStatusLine(), res.getStatusCode(), input});
                if (res.getStatusCode() == 409 || res.getStatusCode() == 500) {
                    this.logger.info("Retry operation %s", new Object[]{operation == null ? "" : operation.id(), res.getStatusCode()});
                }
                throw re;
            }
            if (!retry) continue;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        if (now >= end) {
            throw new RuntimeException(new TimeoutException(requestId));
        }
        return this.operationSucceeded.apply((Object)requestId);
    }

    private static class OperationSucceededPredicate
    implements Predicate<String> {
        private final AzureComputeApi api;

        public OperationSucceededPredicate(AzureComputeApi api) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(String input) {
            Operation operation = this.api.getOperationApi().get(input);
            switch (operation.status()) {
                case SUCCEEDED: {
                    return true;
                }
                case IN_PROGRESS: 
                case UNRECOGNIZED: {
                    return false;
                }
                case FAILED: {
                    throw new RuntimeException(new CancellationException(input));
                }
            }
            throw new IllegalStateException("Operation is in invalid status: " + operation.status().name());
        }
    }
}

