/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.File;
import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jclouds.azurecompute.suppliers.FileBasedKeyManagersSupplier;
import org.jclouds.azurecompute.suppliers.InMemoryKeyManagersSupplier;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.config.SSLModule;
import org.jclouds.location.Provider;
import org.jclouds.rest.AuthorizationException;

@Singleton
public class DelegatingSSLContextSupplier
implements Supplier<SSLContext> {
    private final Crypto crypto;
    private final TrustManager[] trustManager;
    private final Supplier<Credentials> creds;

    @Inject
    DelegatingSSLContextSupplier(Crypto crypto, @Provider Supplier<Credentials> creds, HttpUtils utils, SSLModule.TrustAllCerts trustAllCerts) {
        TrustManager[] trustManagerArray;
        this.crypto = crypto;
        if (utils.trustAllCerts()) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustAllCerts;
        } else {
            trustManagerArray = null;
        }
        this.trustManager = trustManagerArray;
        this.creds = creds;
    }

    public SSLContext get() {
        KeyManager[] keyManagers;
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null");
        String identity = (String)Preconditions.checkNotNull((Object)currentCreds.identity, (Object)"credential supplier returned null identity");
        String credential = (String)Preconditions.checkNotNull((Object)currentCreds.credential, (Object)"credential supplier returned null credential");
        File pkcs12File = new File(identity);
        KeyManager[] keyManagerArray = keyManagers = pkcs12File.isFile() ? new FileBasedKeyManagersSupplier(pkcs12File, credential.toCharArray()).get() : new InMemoryKeyManagersSupplier(this.crypto, identity).get();
        if (keyManagers == null) {
            throw new AuthorizationException("Could not setup any viable authentication method");
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, this.trustManager, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

