/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class ParseRequestIdHeader
implements Function<HttpResponse, String> {
    public String apply(HttpResponse from) {
        HttpUtils.releasePayload((HttpMessage)from);
        String requestId = from.getFirstHeaderOrNull("x-ms-request-id");
        if (requestId != null) {
            return requestId;
        }
        throw new IllegalStateException("did not receive RequestId in: " + from);
    }
}

