/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.CaptureVMImageParamsToXML;
import org.jclouds.azurecompute.binders.RoleToXML;
import org.jclouds.azurecompute.domain.CaptureVMImageParams;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.RoleHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/hostedservices/{serviceName}/deployments/{deploymentName}")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
public interface VirtualMachineApi {
    @Named(value="RestartRole")
    @POST
    @Path(value="/roleinstances/{name}/Operations")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<RestartRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>RestartRoleOperation</OperationType></RestartRoleOperation>")
    public String restart(@PathParam(value="name") String var1);

    @Named(value="CaptureRole")
    @POST
    @Path(value="/roleinstances/{name}/Operations")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<CaptureRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>CaptureRoleOperation</OperationType><PostCaptureAction>Delete</PostCaptureAction><TargetImageLabel>{imageLabel}</TargetImageLabel><TargetImageName>{imageName}</TargetImageName></CaptureRoleOperation>")
    public String capture(@PathParam(value="name") String var1, @PayloadParam(value="imageName") String var2, @PayloadParam(value="imageLabel") String var3);

    @Named(value="ShutdownRole")
    @POST
    @Path(value="/roleinstances/{name}/Operations")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<ShutdownRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>ShutdownRoleOperation</OperationType><PostShutdownAction>{postShutdownAction}</PostShutdownAction></ShutdownRoleOperation>")
    public String shutdown(@PathParam(value="name") String var1, @PayloadParam(value="postShutdownAction") String var2);

    @Named(value="ShutdownRole")
    @POST
    @Path(value="/roleinstances/{name}/Operations")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<ShutdownRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>ShutdownRoleOperation</OperationType></ShutdownRoleOperation>")
    public String shutdown(@PathParam(value="name") String var1);

    @Named(value="StartRole")
    @POST
    @Path(value="/roleinstances/{name}/Operations")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<StartRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>StartRoleOperation</OperationType></StartRoleOperation>")
    public String start(@PathParam(value="name") String var1);

    @Named(value="GetRole")
    @GET
    @Path(value="/roles/{roleName}")
    @Produces(value={"application/xml"})
    @XMLResponseParser(value=RoleHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Role getRole(@PathParam(value="roleName") String var1);

    @Named(value="UpdateRole")
    @PUT
    @Path(value="/roles/{roleName}")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String updateRole(@PathParam(value="roleName") String var1, @BinderParam(value=RoleToXML.class) Role var2);

    @Named(value="CaptureVMImage")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/roleinstances/{name}/Operations")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String capture(@PathParam(value="name") String var1, @BinderParam(value=CaptureVMImageParamsToXML.class) CaptureVMImageParams var2);
}

