/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.ProfileDefinitionParamsToXML;
import org.jclouds.azurecompute.binders.ProfileParamsToXML;
import org.jclouds.azurecompute.domain.CreateProfileParams;
import org.jclouds.azurecompute.domain.Profile;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionParams;
import org.jclouds.azurecompute.domain.UpdateProfileParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListProfileDefinitionsHandler;
import org.jclouds.azurecompute.xml.ListProfilesHandler;
import org.jclouds.azurecompute.xml.ProfileDefinitionHandler;
import org.jclouds.azurecompute.xml.ProfileHandler;
import org.jclouds.azurecompute.xml.ResultHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/WATM")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public interface TrafficManagerApi {
    @Named(value="ListProfileDefinitions")
    @GET
    @Path(value="/profiles/{profile}/definitions")
    @XMLResponseParser(value=ListProfileDefinitionsHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ProfileDefinition> listDefinitions(@PathParam(value="profile") String var1);

    @Named(value="GetProfileDefinition")
    @GET
    @Path(value="/profiles/{profile}/definitions/1")
    @XMLResponseParser(value=ProfileDefinitionHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ProfileDefinition getDefinition(@PathParam(value="profile") String var1);

    @Named(value="ListProfiles")
    @GET
    @Path(value="/profiles")
    @XMLResponseParser(value=ListProfilesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Profile> listProfiles();

    @Named(value="GetProfile")
    @GET
    @Path(value="/profiles/{profile}")
    @XMLResponseParser(value=ProfileHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Profile getProfile(@PathParam(value="profile") String var1);

    @Named(value="CheckDNSPrefixAvailability")
    @GET
    @Path(value="/operations/isavailable/{name}")
    @XMLResponseParser(value=ResultHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public boolean checkDNSPrefixAvailability(@PathParam(value="name") String var1);

    @Named(value="CreateProfileDefinition")
    @POST
    @Path(value="/profiles/{name}/definitions")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String createDefinition(@PathParam(value="name") String var1, @BinderParam(value=ProfileDefinitionParamsToXML.class) ProfileDefinitionParams var2);

    @Named(value="DeleteProfile")
    @DELETE
    @Path(value="/profiles/{profile}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="profile") String var1);

    @Named(value="CreateProfile")
    @POST
    @Path(value="/profiles")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String createProfile(@BinderParam(value=ProfileParamsToXML.class) CreateProfileParams var1);

    @Named(value="UpdateProfile")
    @PUT
    @Path(value="/profiles/{profile}")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String updateProfile(@PathParam(value="profile") String var1, @BinderParam(value=ProfileParamsToXML.class) UpdateProfileParams var2);
}

