/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.CreateStorageServiceParamsToXML;
import org.jclouds.azurecompute.binders.StorageServiceKeyTypeToXML;
import org.jclouds.azurecompute.binders.UpdateStorageServiceParamsToXML;
import org.jclouds.azurecompute.domain.Availability;
import org.jclouds.azurecompute.domain.CreateStorageServiceParams;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.azurecompute.domain.StorageServiceKeys;
import org.jclouds.azurecompute.domain.UpdateStorageServiceParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.AvailabilityHandler;
import org.jclouds.azurecompute.xml.ListStorageServicesHandler;
import org.jclouds.azurecompute.xml.StorageServiceHandler;
import org.jclouds.azurecompute.xml.StorageServiceKeysHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/storageservices")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
public interface StorageAccountApi {
    @Named(value="ListStorageAccounts")
    @GET
    @XMLResponseParser(value=ListStorageServicesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<StorageService> list();

    @Named(value="CreateStorageAccount")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String create(@BinderParam(value=CreateStorageServiceParamsToXML.class) CreateStorageServiceParams var1);

    @Named(value="CheckStorageAccountNameAvailability")
    @GET
    @Path(value="/operations/isavailable/{storageAccountName}")
    @XMLResponseParser(value=AvailabilityHandler.class)
    public Availability isAvailable(@PathParam(value="storageAccountName") String var1);

    @Named(value="GetStorageAccountProperties")
    @GET
    @Path(value="/{storageAccountName}")
    @XMLResponseParser(value=StorageServiceHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public StorageService get(@PathParam(value="storageAccountName") String var1);

    @Named(value="GetStorageAccountKeys")
    @GET
    @Path(value="/{storageAccountName}/keys")
    @XMLResponseParser(value=StorageServiceKeysHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public StorageServiceKeys getKeys(@PathParam(value="storageAccountName") String var1);

    @Named(value="RegenerateStorageAccountKeys")
    @POST
    @Path(value="/{storageAccountName}/keys")
    @QueryParams(keys={"action"}, values={"regenerate"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String regenerateKeys(@PathParam(value="storageAccountName") String var1, @BinderParam(value=StorageServiceKeyTypeToXML.class) StorageServiceKeys.KeyType var2);

    @Named(value="UpdateStorageAccount")
    @PUT
    @Path(value="/{storageAccountName}")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String update(@PathParam(value="storageAccountName") String var1, @BinderParam(value=UpdateStorageServiceParamsToXML.class) UpdateStorageServiceParams var2);

    @Named(value="DeleteStorageAccount")
    @DELETE
    @Path(value="/{serviceName}")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="serviceName") String var1);
}

