/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.NetworkSecurityGroupToXML;
import org.jclouds.azurecompute.binders.RuleToXML;
import org.jclouds.azurecompute.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.domain.Rule;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListNetworkSecurityGroupsHandler;
import org.jclouds.azurecompute.xml.NetworkSecurityGroupHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/networking")
@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
public interface NetworkSecurityGroupApi {
    @Named(value="ListNetworkSecurityGroups")
    @Path(value="/networksecuritygroups")
    @GET
    @XMLResponseParser(value=ListNetworkSecurityGroupsHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkSecurityGroup> list();

    @Named(value="CreateNetworkSecurityGroup")
    @Path(value="/networksecuritygroups")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String create(@BinderParam(value=NetworkSecurityGroupToXML.class) NetworkSecurityGroup var1);

    @Named(value="CreateNetworkSecurityGroup")
    @Path(value="/networksecuritygroups/{networkSecurityGroupName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @DELETE
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="networkSecurityGroupName") String var1);

    @Named(value="GetsNetworkSecurityGroupAppliedToSubnet")
    @Path(value="/virtualnetwork/{virtualNetworkName}/subnets/{subnetName}/networksecuritygroups")
    @GET
    @XMLResponseParser(value=NetworkSecurityGroupHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityGroup getNetworkSecurityGroupAppliedToSubnet(@PathParam(value="virtualNetworkName") String var1, @PathParam(value="subnetName") String var2);

    @Named(value="GetDetailsNetworkSecurityGroup")
    @Path(value="/networksecuritygroups/{networkSecurityGroupName}")
    @GET
    @QueryParams(keys={"detaillevel"}, values={"Full"})
    @XMLResponseParser(value=NetworkSecurityGroupHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityGroup getFullDetails(@PathParam(value="networkSecurityGroupName") String var1);

    @Named(value="GetDetailsNetworkSecurityGroup")
    @Path(value="/networksecuritygroups/{networkSecurityGroupName}")
    @GET
    @XMLResponseParser(value=NetworkSecurityGroupHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityGroup get(@PathParam(value="networkSecurityGroupName") String var1);

    @Named(value="AddNetworkSecurityGroupToSubnet")
    @Path(value="/virtualnetwork/{virtualNetworkName}/subnets/{subnetName}/networksecuritygroups")
    @Payload(value="<NetworkSecurityGroup xmlns=\"http://schemas.microsoft.com/windowsazure\"><Name>{networkSecurityGroupName}</Name></NetworkSecurityGroup>")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String addToSubnet(@PathParam(value="virtualNetworkName") String var1, @PathParam(value="subnetName") String var2, @PayloadParam(value="networkSecurityGroupName") String var3);

    @Named(value="RemoveNetworkSecurityGroupToSubnet")
    @Path(value="/virtualnetwork/{virtualNetworkName}/subnets/{subnetName}/networksecuritygroups/{networkSecurityGroupName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @DELETE
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String removeFromSubnet(@PathParam(value="virtualNetworkName") String var1, @PathParam(value="subnetName") String var2, @PathParam(value="networkSecurityGroupName") String var3);

    @Named(value="SetNetworkSecurityRuleToNetworkSecurityGroup")
    @Path(value="/networksecuritygroups/{networkSecurityGroupName}/rules/{ruleName}")
    @PUT
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String setRule(@PathParam(value="networkSecurityGroupName") String var1, @PathParam(value="ruleName") String var2, @BinderParam(value=RuleToXML.class) Rule var3);

    @Named(value="SetNetworkSecurityRuleToNetworkSecurityGroup")
    @Path(value="/networksecuritygroups/{networkSecurityGroupName}/rules/{ruleName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @DELETE
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String deleteRule(@PathParam(value="networkSecurityGroupName") String var1, @PathParam(value="ruleName") String var2);
}

