/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.domain.CloudService;
import org.jclouds.azurecompute.domain.CloudServiceProperties;
import org.jclouds.azurecompute.functions.Base64EncodeLabel;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.CloudServiceHandler;
import org.jclouds.azurecompute.xml.CloudServicePropertiesHandler;
import org.jclouds.azurecompute.xml.ListCloudServicesHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/hostedservices")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
public interface CloudServiceApi {
    @Named(value="ListCloudServices")
    @GET
    @QueryParams(keys={"embed-detail"}, values={"true"})
    @XMLResponseParser(value=ListCloudServicesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<CloudService> list();

    @Named(value="CreateCloudService")
    @POST
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    @Payload(value="<CreateHostedService xmlns=\"http://schemas.microsoft.com/windowsazure\"><ServiceName>{name}</ServiceName><Label>{label}</Label><Location>{location}</Location></CreateHostedService>")
    public String createWithLabelInLocation(@PayloadParam(value="name") String var1, @PayloadParam(value="label") @ParamParser(value=Base64EncodeLabel.class) String var2, @PayloadParam(value="location") String var3);

    @Named(value="GetCloudServiceProperties")
    @GET
    @Path(value="/{name}")
    @QueryParams(keys={"embed-detail"}, values={"true"})
    @XMLResponseParser(value=CloudServiceHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public CloudService get(@PathParam(value="name") String var1);

    @Named(value="DeleteCloudService")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="name") String var1);

    @Named(value="CloudServiceProperties")
    @GET
    @Path(value="/{name}")
    @QueryParams(keys={"embed-detail"}, values={"true"})
    @XMLResponseParser(value=CloudServicePropertiesHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public CloudServiceProperties getProperties(@PathParam(value="name") String var1);
}

