/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_VMImage;
import org.jclouds.azurecompute.domain.AutoValue_VMImage_OSDiskConfiguration;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;

public abstract class VMImage {
    public abstract String name();

    public abstract String label();

    @Nullable
    public abstract String category();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract OSDiskConfiguration osDiskConfiguration();

    public abstract List<DataVirtualHardDisk> dataDiskConfiguration();

    @Nullable
    public abstract String serviceName();

    @Nullable
    public abstract String deploymentName();

    @Nullable
    public abstract String roleName();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract String affinityGroup();

    @Nullable
    public abstract Date createdTime();

    @Nullable
    public abstract Date modifiedTime();

    @Nullable
    public abstract String language();

    @Nullable
    public abstract String imageFamily();

    @Nullable
    public abstract RoleSize.Type recommendedVMSize();

    @Nullable
    public abstract Boolean isPremium();

    @Nullable
    public abstract String eula();

    @Nullable
    public abstract URI iconUri();

    @Nullable
    public abstract URI smallIconUri();

    @Nullable
    public abstract URI privacyUri();

    @Nullable
    public abstract Date publishedDate();

    public static VMImage create(String name, String label, String category, String description, OSDiskConfiguration osDiskConfiguration, List<DataVirtualHardDisk> dataDiskConfiguration, String serviceName, String deploymentName, String roleName, String location, String affinityGroup, Date createdTime, Date modifiedTime, String language, String imageFamily, RoleSize.Type recommendedVMSize, Boolean isPremium, String eula, URI iconUri, URI smallIconUri, URI privacyUri, Date publishedDate) {
        return new AutoValue_VMImage(name, label, category, description, osDiskConfiguration, (List<DataVirtualHardDisk>)ImmutableList.copyOf(dataDiskConfiguration), serviceName, deploymentName, roleName, location, affinityGroup, createdTime, modifiedTime, language, imageFamily, recommendedVMSize, isPremium, eula, iconUri, smallIconUri, privacyUri, publishedDate);
    }

    public static abstract class OSDiskConfiguration {
        public abstract String name();

        @Nullable
        public abstract Caching hostCaching();

        @Nullable
        public abstract OSState osState();

        public abstract OSImage.Type os();

        @Nullable
        public abstract URI mediaLink();

        @Nullable
        public abstract Integer logicalSizeInGB();

        @Nullable
        public abstract String ioType();

        public static OSDiskConfiguration create(String name, Caching hostCaching, OSState osState, OSImage.Type os, URI mediaLink, Integer logicalDiskSizeInGB, String ioType) {
            return new AutoValue_VMImage_OSDiskConfiguration(name, hostCaching, osState, os, mediaLink, logicalDiskSizeInGB, ioType);
        }

        public static enum OSState {
            GENERALIZED,
            SPECIALIZED;

        }

        public static enum Caching {
            READ_ONLY,
            READ_WRITE,
            NONE;

        }
    }
}

