/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import org.jclouds.azurecompute.domain.AutoValue_Rule;
import org.jclouds.javax.annotation.Nullable;

public abstract class Rule {
    public abstract String name();

    public abstract Type type();

    public abstract String priority();

    public abstract Action action();

    public abstract String sourceAddressPrefix();

    public abstract String sourcePortRange();

    public abstract String destinationAddressPrefix();

    public abstract String destinationPortRange();

    public abstract Protocol protocol();

    public abstract String state();

    @Nullable
    public abstract Boolean isDefault();

    Rule() {
    }

    public static Rule create(String name, Type type, String priority, Action action, String sourceAddressPrefix, String sourcePortRange, String destinationAddressPrefix, String destinationPortRange, Protocol protocol) {
        return new AutoValue_Rule(name, type, priority, action, sourceAddressPrefix, sourcePortRange, destinationAddressPrefix, destinationPortRange, protocol, "Active", null);
    }

    public static Rule create(String name, Type type, String priority, Action action, String sourceAddressPrefix, String sourcePortRange, String destinationAddressPrefix, String destinationPortRange, Protocol protocol, String state, Boolean isDefault) {
        return new AutoValue_Rule(name, type, priority, action, sourceAddressPrefix, sourcePortRange, destinationAddressPrefix, destinationPortRange, protocol, state, isDefault);
    }

    public static enum Protocol {
        TCP("TCP"),
        UDP("UDP"),
        ALL("*"),
        UNRECOGNIZED("");

        private final String value;

        private Protocol(String value) {
            this.value = value;
        }

        public static Protocol fromString(String text) {
            if (text != null) {
                for (Protocol protocol : Protocol.values()) {
                    if (!text.equalsIgnoreCase(protocol.value)) continue;
                    return protocol;
                }
            }
            return UNRECOGNIZED;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Type {
        Inbound,
        Outbound,
        UNRECOGNIZED;


        public static Type fromString(String text) {
            if (text != null) {
                for (Type type : Type.values()) {
                    if (!text.equalsIgnoreCase(type.name())) continue;
                    return type;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum Action {
        Allow,
        Deny,
        UNRECOGNIZED;


        public static Action fromString(String text) {
            if (text != null) {
                for (Action action : Action.values()) {
                    if (!text.equalsIgnoreCase(action.name())) continue;
                    return action;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

