/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import java.net.URI;
import org.jclouds.azurecompute.domain.AutoValue_OSImageParams;
import org.jclouds.azurecompute.domain.OSImage;

public abstract class OSImageParams {
    OSImageParams() {
    }

    public abstract String name();

    public abstract String label();

    public abstract URI mediaLink();

    public abstract OSImage.Type os();

    public Builder toBuilder() {
        return OSImageParams.builder().fromImageParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static OSImageParams create(String name, String label, URI mediaLink, OSImage.Type os) {
        return new AutoValue_OSImageParams(name, label, mediaLink, os);
    }

    public static final class Builder {
        private String name;
        private String label;
        private URI mediaLink;
        private OSImage.Type os;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder mediaLink(URI mediaLink) {
            this.mediaLink = mediaLink;
            return this;
        }

        public Builder os(OSImage.Type os) {
            this.os = os;
            return this;
        }

        public OSImageParams build() {
            return OSImageParams.create(this.name, this.label, this.mediaLink, this.os);
        }

        public Builder fromImageParams(OSImageParams in) {
            return this.name(in.name()).label(in.label()).mediaLink(in.mediaLink()).os(in.os());
        }
    }
}

