/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import org.jclouds.azurecompute.domain.AutoValue_Error;

public abstract class Error {
    Error() {
    }

    public abstract Code code();

    public abstract String message();

    public static Error create(Code code, String message) {
        return new AutoValue_Error(code, message);
    }

    public static enum Code {
        MISSING_OR_INCORRECT_VERSION_HEADER,
        INVALID_XML_REQUEST,
        MISSING_OR_INVALID_REQUIRED_QUERY_PARAMETER,
        INVALID_HTTP_VERB,
        AUTHENTICATION_FAILED,
        RESOURCE_NOT_FOUND,
        INTERNAL_ERROR,
        OPERATION_TIMED_OUT,
        SERVER_BUSY,
        SUBSCRIPTION_DISABLED,
        BAD_REQUEST,
        CONFLICT_ERROR,
        UNRECOGNIZED;


        public static Code fromString(String text) {
            if (text != null) {
                for (Code code : Code.values()) {
                    if (!text.equalsIgnoreCase(code.name())) continue;
                    return code;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

