/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.domain.AutoValue_CloudServiceProperties;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.javax.annotation.Nullable;

public abstract class CloudServiceProperties {
    CloudServiceProperties() {
    }

    public abstract String serviceName();

    public abstract URI url();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract String affinityGroup();

    public abstract String label();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract Status status();

    @Nullable
    public abstract Date created();

    @Nullable
    public abstract Date lastModified();

    public abstract Map<String, String> extendedProperties();

    public abstract List<Deployment> deployments();

    public static CloudServiceProperties create(String name, URI url, String location, String affinityGroup, String label, String description, Status status, Date created, Date lastModified, Map<String, String> extendedProperties, List<Deployment> deployments) {
        return new AutoValue_CloudServiceProperties(name, url, location, affinityGroup, label, description, status, created, lastModified, (Map<String, String>)ImmutableMap.copyOf(extendedProperties), (List<Deployment>)ImmutableList.copyOf(deployments));
    }

    public static enum Status {
        CREATING,
        CREATED,
        DELETING,
        DELETED,
        CHANGING,
        RESOLVING_DNS,
        UNRECOGNIZED;

    }
}

