/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import org.jclouds.azurecompute.domain.AutoValue_CaptureVMImageParams;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.javax.annotation.Nullable;

public abstract class CaptureVMImageParams {
    public abstract VMImage.OSDiskConfiguration.OSState osState();

    public abstract String name();

    public abstract String label();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String language();

    @Nullable
    public abstract String imageFamily();

    @Nullable
    public abstract RoleSize.Type recommendedVMSize();

    public Builder toBuilder() {
        return CaptureVMImageParams.builder().fromVMImageParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CaptureVMImageParams create(VMImage.OSDiskConfiguration.OSState osState, String name, String label, String description, String language, String imageFamily, RoleSize.Type recommendedVMSize) {
        return new AutoValue_CaptureVMImageParams(osState, name, label, description, language, imageFamily, recommendedVMSize);
    }

    public static final class Builder {
        private VMImage.OSDiskConfiguration.OSState osState;
        private String name;
        private String label;
        private String description;
        private String language;
        private String imageFamily;
        private RoleSize.Type recommendedVMSize;

        public Builder osState(VMImage.OSDiskConfiguration.OSState osState) {
            this.osState = osState;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder imageFamily(String imageFamily) {
            this.imageFamily = imageFamily;
            return this;
        }

        public Builder recommendedVMSize(RoleSize.Type recommendedRoleSize) {
            this.recommendedVMSize = recommendedRoleSize;
            return this;
        }

        public Builder fromVMImageParams(CaptureVMImageParams in) {
            return this.name(in.name()).label(in.label()).osState(in.osState()).description(in.description()).language(in.language()).imageFamily(in.imageFamily()).recommendedVMSize(in.recommendedVMSize());
        }

        public CaptureVMImageParams build() {
            return CaptureVMImageParams.create(this.osState, this.name, this.label, this.description, this.language, this.imageFamily, this.recommendedVMSize);
        }
    }
}

