/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.config;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import javax.net.ssl.SSLContext;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.config.AzureComputeParserModule;
import org.jclouds.azurecompute.handlers.AzureComputeErrorHandler;
import org.jclouds.azurecompute.suppliers.DelegatingSSLContextSupplier;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstRegionOptionallyMatchingRegionId;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class AzureComputeHttpApiModule
extends HttpApiModule<AzureComputeApi> {
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(AzureComputeErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(AzureComputeErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(AzureComputeErrorHandler.class);
    }

    protected void installLocations() {
        this.install((Module)new LocationModule());
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstRegionOptionallyMatchingRegionId.class).in(Scopes.SINGLETON);
    }

    protected void configure() {
        this.install((Module)new AzureComputeParserModule());
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Supplier<SSLContext>>(){}).to((TypeLiteral)new TypeLiteral<DelegatingSSLContextSupplier>(){});
    }
}

