/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;

@Singleton
public class UseNodeCredentialsButOverrideFromTemplate
extends PrioritizeCredentialsFromTemplate {
    @Inject
    public UseNodeCredentialsButOverrideFromTemplate(Function<Template, LoginCredentials> credentialsFromImageOrTemplateOptions) {
        super(credentialsFromImageOrTemplateOptions);
    }

    public LoginCredentials apply(Template template, LoginCredentials fromNode) {
        RunScriptOptions options = (RunScriptOptions)Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options are required");
        LoginCredentials.Builder builder = LoginCredentials.builder((Credentials)fromNode);
        if (options.getLoginUser() != null) {
            builder.user(template.getOptions().getLoginUser());
        }
        if (options.getLoginPassword() != null) {
            builder.password(options.getLoginPassword());
        }
        if (options.getLoginPrivateKey() != null) {
            builder.privateKey(options.getLoginPrivateKey());
        }
        if (options.shouldAuthenticateSudo() != null && options.shouldAuthenticateSudo().booleanValue()) {
            builder.authenticateSudo(true);
        }
        return builder.build();
    }
}

