/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public class AzureComputeTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String virtualNetworkName;
    protected List<String> subnetNames = ImmutableList.of();
    protected String storageAccountName;
    protected String storageAccountType;
    protected String networkSecurityGroupName;
    protected String reservedIPName;
    protected Boolean provisionGuestAgent;
    protected Boolean winrmUseHttps;

    public AzureComputeTemplateOptions clone() {
        AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof AzureComputeTemplateOptions) {
            AzureComputeTemplateOptions eTo = (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(to);
            eTo.virtualNetworkName(this.virtualNetworkName);
            if (!this.subnetNames.isEmpty()) {
                eTo.subnetNames(this.subnetNames);
            }
            eTo.storageAccountName(this.storageAccountName);
            eTo.storageAccountType(this.storageAccountType);
            eTo.reservedIPName(this.reservedIPName);
            eTo.provisionGuestAgent(this.provisionGuestAgent);
            eTo.winrmUseHttps(this.winrmUseHttps);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AzureComputeTemplateOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureComputeTemplateOptions that = (AzureComputeTemplateOptions)o;
        if (this.networkSecurityGroupName != null ? !this.networkSecurityGroupName.equals(that.networkSecurityGroupName) : that.networkSecurityGroupName != null) {
            return false;
        }
        if (this.reservedIPName != null ? !this.reservedIPName.equals(that.reservedIPName) : that.reservedIPName != null) {
            return false;
        }
        if (this.storageAccountName != null ? !this.storageAccountName.equals(that.storageAccountName) : that.storageAccountName != null) {
            return false;
        }
        if (this.storageAccountType != null ? !this.storageAccountType.equals(that.storageAccountType) : that.storageAccountType != null) {
            return false;
        }
        if (this.subnetNames != null ? !this.subnetNames.equals(that.subnetNames) : that.subnetNames != null) {
            return false;
        }
        if (this.virtualNetworkName != null ? !this.virtualNetworkName.equals(that.virtualNetworkName) : that.virtualNetworkName != null) {
            return false;
        }
        if (this.provisionGuestAgent != null ? !this.provisionGuestAgent.equals(that.provisionGuestAgent) : that.provisionGuestAgent != null) {
            return false;
        }
        return !(this.winrmUseHttps != null ? !this.winrmUseHttps.equals(that.winrmUseHttps) : that.winrmUseHttps != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.virtualNetworkName != null ? this.virtualNetworkName.hashCode() : 0);
        result = 31 * result + (this.subnetNames != null ? this.subnetNames.hashCode() : 0);
        result = 31 * result + (this.storageAccountName != null ? this.storageAccountName.hashCode() : 0);
        result = 31 * result + (this.storageAccountType != null ? this.storageAccountType.hashCode() : 0);
        result = 31 * result + (this.networkSecurityGroupName != null ? this.networkSecurityGroupName.hashCode() : 0);
        result = 31 * result + (this.reservedIPName != null ? this.reservedIPName.hashCode() : 0);
        result = 31 * result + (this.provisionGuestAgent != null ? this.provisionGuestAgent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("virtualNetworkName", (Object)this.virtualNetworkName).add("subnetNames", this.subnetNames).add("storageAccountName", (Object)this.storageAccountName).add("storageAccountType", (Object)this.storageAccountType).add("networkSecurityGroupName", (Object)this.networkSecurityGroupName).add("reservedIPName", (Object)this.reservedIPName).add("provisionGuestAgent", (Object)this.provisionGuestAgent).toString();
    }

    public AzureComputeTemplateOptions virtualNetworkName(@Nullable String virtualNetworkName) {
        this.virtualNetworkName = virtualNetworkName;
        return this;
    }

    public AzureComputeTemplateOptions subnetNames(Iterable<String> subnetNames) {
        this.subnetNames = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(subnetNames, (Object)"subnetNames")));
        return this;
    }

    public AzureComputeTemplateOptions subnetNames(String ... subnetNames) {
        return this.subnetNames((Iterable<String>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)subnetNames, (Object)"subnetNames"))));
    }

    public AzureComputeTemplateOptions networkSecurityGroupName(@Nullable String networkSecurityGroupName) {
        this.networkSecurityGroupName = networkSecurityGroupName;
        return this;
    }

    public AzureComputeTemplateOptions storageAccountName(@Nullable String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public AzureComputeTemplateOptions storageAccountType(@Nullable String storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public AzureComputeTemplateOptions reservedIPName(@Nullable String reservedIPName) {
        this.reservedIPName = reservedIPName;
        return this;
    }

    public AzureComputeTemplateOptions provisionGuestAgent(@Nullable Boolean provisionGuestAgent) {
        this.provisionGuestAgent = provisionGuestAgent;
        return this;
    }

    public AzureComputeTemplateOptions winrmUseHttps(@Nullable Boolean winrmUseHttps) {
        this.winrmUseHttps = winrmUseHttps;
        return this;
    }

    public String getVirtualNetworkName() {
        return this.virtualNetworkName;
    }

    public List<String> getSubnetNames() {
        return this.subnetNames;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getStorageAccountType() {
        return this.storageAccountType;
    }

    public String getNetworkSecurityGroupName() {
        return this.networkSecurityGroupName;
    }

    public String getReservedIPName() {
        return this.reservedIPName;
    }

    public Boolean getProvisionGuestAgent() {
        return this.provisionGuestAgent;
    }

    public Boolean getWinrmUseHttps() {
        return this.winrmUseHttps;
    }

    public AzureComputeTemplateOptions blockOnPort(int port, int seconds) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public AzureComputeTemplateOptions inboundPorts(int ... ports) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public AzureComputeTemplateOptions authorizePublicKey(String publicKey) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public AzureComputeTemplateOptions installPrivateKey(String privateKey) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public AzureComputeTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public AzureComputeTemplateOptions dontAuthorizePublicKey() {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public AzureComputeTemplateOptions nameTask(String name) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.nameTask(name));
    }

    public AzureComputeTemplateOptions runAsRoot(boolean runAsRoot) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public AzureComputeTemplateOptions runScript(Statement script) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.runScript(script));
    }

    public AzureComputeTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public AzureComputeTemplateOptions overrideLoginPassword(String password) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public AzureComputeTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public AzureComputeTemplateOptions overrideLoginUser(String loginUser) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public AzureComputeTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public AzureComputeTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public AzureComputeTemplateOptions userMetadata(String key, String value) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public AzureComputeTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public AzureComputeTemplateOptions networks(Iterable<String> networks) {
        return (AzureComputeTemplateOptions)AzureComputeTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static AzureComputeTemplateOptions virtualNetworkName(String virtualNetworkName) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.virtualNetworkName(virtualNetworkName);
        }

        public static AzureComputeTemplateOptions subnetNames(String ... subnetNames) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.subnetNames(subnetNames);
        }

        public static AzureComputeTemplateOptions subnetNames(Iterable<String> subnetNames) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.subnetNames(subnetNames);
        }

        public static AzureComputeTemplateOptions storageAccountName(String storageAccountName) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.storageAccountName(storageAccountName);
        }

        public static AzureComputeTemplateOptions storageAccountType(String storageAccountType) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.storageAccountType(storageAccountType);
        }

        public static AzureComputeTemplateOptions inboundPorts(int ... ports) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.inboundPorts(ports);
        }

        public static AzureComputeTemplateOptions blockOnPort(int port, int seconds) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static AzureComputeTemplateOptions userMetadata(Map<String, String> userMetadata) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.userMetadata((Map)userMetadata);
        }

        public static AzureComputeTemplateOptions userMetadata(String key, String value) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.userMetadata(key, value);
        }

        public static AzureComputeTemplateOptions nodeNames(Iterable<String> nodeNames) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.nodeNames((Iterable)nodeNames);
        }

        public static AzureComputeTemplateOptions networks(Iterable<String> networks) {
            AzureComputeTemplateOptions options = new AzureComputeTemplateOptions();
            return options.networks((Iterable)networks);
        }
    }
}

