/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.compute.domain.OsFamily;

public class OperatingSystems {
    protected static final String CENTOS = "CentOS";
    protected static final String SUSE = "SUSE";
    protected static final String OPENSUSE = "openSUSE";
    protected static final String UBUNTU = "Ubuntu";
    protected static final String WINDOWS = "Windows";
    private static final String MICROSOFT = "Microsoft";
    public static final String WINDOWS_SERVER = "Windows Server";
    public static final String MICROSOFT_SQL_SERVER = "Microsoft SQL Server";

    public static Function<String, OsFamily> osFamily() {
        return new Function<String, OsFamily>(){

            public OsFamily apply(String label) {
                if (label != null) {
                    if (label.contains(OperatingSystems.CENTOS)) {
                        return OsFamily.CENTOS;
                    }
                    if (label.contains(OperatingSystems.SUSE)) {
                        return OsFamily.SUSE;
                    }
                    if (label.contains(OperatingSystems.UBUNTU)) {
                        return OsFamily.UBUNTU;
                    }
                    if (label.contains(OperatingSystems.WINDOWS)) {
                        return OsFamily.WINDOWS;
                    }
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }

    public static Function<OSImage, String> version() {
        return new Function<OSImage, String>(){

            public String apply(OSImage osImage) {
                Iterable splittedLabel;
                if (osImage.category().matches("Canonical|OpenLogic")) {
                    return (String)Iterables.get((Iterable)Splitter.on((String)" ").split((CharSequence)osImage.label()), (int)2);
                }
                if (osImage.category().matches(OperatingSystems.SUSE)) {
                    if (osImage.label().startsWith(OperatingSystems.OPENSUSE)) {
                        return osImage.label().substring(OperatingSystems.OPENSUSE.length() + 1);
                    }
                    if (osImage.label().startsWith(OperatingSystems.SUSE)) {
                        return (String)Iterables.get((Iterable)Splitter.on((String)"-").split((CharSequence)osImage.name()), (int)4);
                    }
                } else if (osImage.category().matches(OperatingSystems.MICROSOFT)) {
                    if (osImage.label().startsWith(OperatingSystems.WINDOWS_SERVER)) {
                        return osImage.label().substring(OperatingSystems.WINDOWS_SERVER.length() + 1);
                    }
                    if (osImage.label().startsWith(OperatingSystems.MICROSOFT_SQL_SERVER)) {
                        return osImage.label().substring(OperatingSystems.MICROSOFT_SQL_SERVER.length() + 1);
                    }
                } else if (osImage.category().matches("RightScale with Linux|Public ") && Iterables.size((Iterable)(splittedLabel = Splitter.on((String)"-").split((CharSequence)osImage.label()))) > 2) {
                    return (String)Iterables.get((Iterable)splittedLabel, (int)2);
                }
                return null;
            }
        };
    }
}

