/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;

public class OSImageToImage
implements Function<OSImage, Image> {
    private static final String UNRECOGNIZED = "UNRECOGNIZED";
    private static final String UBUNTU = "Ubuntu";
    private static final String WINDOWS = "Windows";
    private static final String OPENLOGIC = "openLogic";
    private static final String CENTOS = "CentOS";
    private static final String COREOS = "CoreOS";
    private static final String OPENSUSE = "openSUSE";
    private static final String SUSE = "SUSE";
    private static final String SQL_SERVER = "SQL Server";
    private static final String ORACLE_lINUX = "Oracle Linux";
    private final Supplier<Set<? extends Location>> locations;

    public static String toGeoName(String name, String location) {
        return name + "/" + location;
    }

    public static String[] fromGeoName(String geoName) {
        String[] stringArray;
        String[] parts = ((String)Preconditions.checkNotNull((Object)geoName, (Object)"geoName")).split("/");
        if (parts.length == 1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = geoName;
            stringArray = stringArray2;
            stringArray2[1] = null;
        } else {
            stringArray = parts;
        }
        return stringArray;
    }

    @Inject
    OSImageToImage(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    public Image apply(OSImage image) {
        ImageBuilder builder = new ImageBuilder().id(image.name()).name(image.label()).description(image.description()).status(Image.Status.AVAILABLE).uri(image.mediaLink()).providerId(image.name()).location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)image.location())).orNull());
        OperatingSystem.Builder osBuilder = (OperatingSystem.Builder)OSImageToImage.osFamily().apply((Object)image);
        return builder.operatingSystem(osBuilder.build()).build();
    }

    public static Function<OSImage, OperatingSystem.Builder> osFamily() {
        return new Function<OSImage, OperatingSystem.Builder>(){

            public OperatingSystem.Builder apply(OSImage image) {
                Preconditions.checkNotNull((Object)image.label(), (Object)"label");
                String label = (String)Splitter.on((char)'/').split((CharSequence)image.label()).iterator().next();
                boolean is64Bit = false;
                OsFamily family = OsFamily.UNRECOGNIZED;
                if (label.contains(OSImageToImage.CENTOS)) {
                    family = OsFamily.CENTOS;
                    is64Bit = image.name().contains("x64");
                } else if (label.contains(OSImageToImage.OPENLOGIC)) {
                    family = OsFamily.CENTOS;
                } else if (label.contains(OSImageToImage.SUSE)) {
                    family = OsFamily.SUSE;
                } else if (label.contains(OSImageToImage.UBUNTU)) {
                    family = OsFamily.UBUNTU;
                    is64Bit = image.name().contains("amd64");
                } else if (label.contains(OSImageToImage.WINDOWS)) {
                    family = OsFamily.WINDOWS;
                    is64Bit = true;
                } else if (label.contains(OSImageToImage.ORACLE_lINUX)) {
                    family = OsFamily.OEL;
                }
                String version = OSImageToImage.UNRECOGNIZED;
                if (label.contains(OSImageToImage.COREOS)) {
                    version = label.replace("CoreOS ", "");
                } else if (label.contains(OSImageToImage.OPENSUSE)) {
                    version = label.replace("openSUSE ", "");
                } else if (label.contains(OSImageToImage.SUSE)) {
                    version = label.replace("SUSE ", "");
                } else if (label.contains(OSImageToImage.UBUNTU)) {
                    version = label.replace("Ubuntu Server ", "");
                } else if (label.contains(OSImageToImage.SQL_SERVER)) {
                    version = label;
                } else if (label.contains(OSImageToImage.CENTOS)) {
                    version = label;
                } else if (label.contains(OSImageToImage.WINDOWS)) {
                    version = label;
                } else if (label.equals(OSImageToImage.ORACLE_lINUX)) {
                    version = label;
                }
                return OperatingSystem.builder().family(family != OsFamily.UNRECOGNIZED ? family : (image.os() == OSImage.Type.WINDOWS ? OsFamily.WINDOWS : OsFamily.LINUX)).version(version).is64Bit(is64Bit).description(image.description() + "");
            }
        };
    }
}

