/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.compute.config.AzureComputeServiceContextModule;
import org.jclouds.azurecompute.compute.functions.OSImageToImage;
import org.jclouds.azurecompute.compute.options.AzureComputeTemplateOptions;
import org.jclouds.azurecompute.domain.CloudService;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.DeploymentParams;
import org.jclouds.azurecompute.domain.Location;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.util.ConflictManagementPredicate;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

@Singleton
public class AzureComputeServiceAdapter
implements ComputeServiceAdapter<Deployment, RoleSize, OSImage, Location> {
    private static final String DEFAULT_LOGIN_USER = "jclouds";
    private static final String DEFAULT_LOGIN_PASSWORD = "Azur3Compute!";
    public static final String POST_SHUTDOWN_ACTION = "StoppedDeallocated";
    private static final String POST_SHUTDOWN_ACTION_NO_DEALLOCATE = "Stopped";
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final Predicate<String> operationSucceededPredicate;
    private final AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants;

    @Inject
    AzureComputeServiceAdapter(AzureComputeApi api, Predicate<String> operationSucceededPredicate, AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants) {
        this.api = api;
        this.operationSucceededPredicate = operationSucceededPredicate;
        this.azureComputeConstants = azureComputeConstants;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Deployment> createNodeWithGroupEncodedIntoName(String group, final String name, Template template) {
        AzureComputeTemplateOptions templateOptions = (AzureComputeTemplateOptions)template.getOptions().as(AzureComputeTemplateOptions.class);
        String loginUser = (String)Objects.firstNonNull((Object)templateOptions.getLoginUser(), (Object)DEFAULT_LOGIN_USER);
        String loginPassword = (String)Objects.firstNonNull((Object)templateOptions.getLoginPassword(), (Object)DEFAULT_LOGIN_PASSWORD);
        String location = template.getLocation().getId();
        int[] inboundPorts = template.getOptions().getInboundPorts();
        String storageAccountName = templateOptions.getStorageAccountName();
        String message = String.format("Creating a cloud service with name '%s', label '%s' in location '%s'", name, name, location);
        this.logger.debug(message, new Object[0]);
        String createCloudServiceRequestId = this.api.getCloudServiceApi().createWithLabelInLocation(name, name, location);
        if (!this.operationSucceededPredicate.apply((Object)createCloudServiceRequestId)) {
            String exceptionMessage = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage(message, createCloudServiceRequestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(exceptionMessage, new Object[0]);
            throw new IllegalStateException(exceptionMessage);
        }
        this.logger.info("Cloud Service (%s) created with operation id: %s", new Object[]{name, createCloudServiceRequestId});
        OSImage.Type os = template.getImage().getOperatingSystem().getFamily() == OsFamily.WINDOWS ? OSImage.Type.WINDOWS : OSImage.Type.LINUX;
        HashSet externalEndpoints = Sets.newHashSet();
        for (int inboundPort : inboundPorts) {
            externalEndpoints.add(DeploymentParams.ExternalEndpoint.inboundTcpToLocalPort(inboundPort, inboundPort));
        }
        DeploymentParams.Builder paramsBuilder = DeploymentParams.builder().name(name).os(os).username(loginUser).password(loginPassword).sourceImageName(OSImageToImage.fromGeoName(template.getImage().getId())[0]).mediaLink(AzureComputeServiceAdapter.createMediaLink(storageAccountName, name)).size(RoleSize.Type.fromString(template.getHardware().getName())).externalEndpoints(externalEndpoints).virtualNetworkName(templateOptions.getVirtualNetworkName()).subnetNames(templateOptions.getSubnetNames()).provisionGuestAgent(templateOptions.getProvisionGuestAgent());
        if (os.equals((Object)OSImage.Type.WINDOWS)) {
            paramsBuilder.winrmUseHttps(templateOptions.getWinrmUseHttps());
        }
        final DeploymentParams params = paramsBuilder.build();
        message = String.format("Creating a deployment with params '%s' ...", params);
        this.logger.debug(message, new Object[0]);
        if (!new ConflictManagementPredicate(this.api){

            @Override
            protected String operation() {
                return AzureComputeServiceAdapter.this.api.getDeploymentApiForService(name).create(params);
            }
        }.apply(name)) {
            String illegalStateExceptionMessage = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage(message, createCloudServiceRequestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(illegalStateExceptionMessage, new Object[0]);
            this.logger.debug("Deleting cloud service (%s) ...", new Object[]{name});
            this.deleteCloudService(name);
            this.logger.debug("Cloud service (%s) deleted.", new Object[]{name});
            throw new IllegalStateException(illegalStateExceptionMessage);
        }
        this.logger.info("Deployment created with name: %s", new Object[]{name});
        final HashSet deployments = Sets.newHashSet();
        if (!Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String name) {
                Deployment deployment = AzureComputeServiceAdapter.this.api.getDeploymentApiForService(name).get(name);
                if (deployment != null) {
                    deployments.add(deployment);
                }
                return !deployments.isEmpty();
            }
        }, (long)this.azureComputeConstants.operationTimeout(), (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)name)) {
            String illegalStateExceptionMessage = String.format("Deployment %s was not created within %sms so it will be destroyed.", name, this.azureComputeConstants.operationTimeout());
            this.logger.warn(illegalStateExceptionMessage, new Object[0]);
            this.api.getDeploymentApiForService(name).delete(name);
            this.api.getCloudServiceApi().delete(name);
            throw new IllegalStateException(illegalStateExceptionMessage);
        }
        Deployment deployment = (Deployment)deployments.iterator().next();
        this.checkRoleStatusInDeployment(name, deployment);
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)deployment, name, LoginCredentials.builder().user(loginUser).password(loginPassword).authenticateSudo(true).build());
    }

    public Iterable<RoleSize> listHardwareProfiles() {
        return this.api.getSubscriptionApi().listRoleSizes();
    }

    public Iterable<OSImage> listImages() {
        ArrayList osImages = Lists.newArrayList();
        for (OSImage osImage : this.api.getOSImageApi().list()) {
            if (osImage.location() == null) {
                osImages.add(OSImage.create(osImage.name(), null, osImage.affinityGroup(), osImage.label(), osImage.description(), osImage.imageFamily(), osImage.category(), osImage.os(), osImage.publisherName(), osImage.mediaLink(), osImage.logicalSizeInGB(), osImage.eula()));
                continue;
            }
            for (String actualLocation : Splitter.on((char)';').split((CharSequence)osImage.location())) {
                osImages.add(OSImage.create(OSImageToImage.toGeoName(osImage.name(), actualLocation), actualLocation, osImage.affinityGroup(), osImage.label(), osImage.description(), osImage.imageFamily(), osImage.category(), osImage.os(), osImage.publisherName(), osImage.mediaLink(), osImage.logicalSizeInGB(), osImage.eula()));
            }
        }
        return osImages;
    }

    public OSImage getImage(String id) {
        final String[] idParts = OSImageToImage.fromGeoName(id);
        OSImage image = (OSImage)Iterables.find(this.api.getOSImageApi().list(), (Predicate)new Predicate<OSImage>(){

            public boolean apply(OSImage input) {
                return idParts[0].equals(input.name());
            }
        });
        return image == null ? null : (idParts[1] == null ? image : OSImage.create(id, idParts[1], image.affinityGroup(), image.label(), image.description(), image.imageFamily(), image.category(), image.os(), image.publisherName(), image.mediaLink(), image.logicalSizeInGB(), image.eula()));
    }

    public Iterable<Location> listLocations() {
        return this.api.getLocationApi().list();
    }

    private Deployment isSettled(Deployment deployment) {
        return deployment == null || deployment.roleInstanceList().isEmpty() ? null : (FluentIterable.from(deployment.roleInstanceList()).allMatch((Predicate)new Predicate<Deployment.RoleInstance>(){

            public boolean apply(Deployment.RoleInstance input) {
                return input != null && !input.instanceStatus().isTransient();
            }
        }) ? deployment : null);
    }

    public Deployment getNode(final String id) {
        Deployment deployment = this.api.getDeploymentApiForService(id).get(id);
        if (deployment != null) {
            return this.isSettled(deployment);
        }
        return (Deployment)FluentIterable.from(this.api.getCloudServiceApi().list()).transform((Function)new Function<CloudService, Deployment>(){

            public Deployment apply(CloudService input) {
                Deployment deployment = AzureComputeServiceAdapter.this.api.getDeploymentApiForService(input.name()).get(id);
                return AzureComputeServiceAdapter.this.isSettled(deployment);
            }
        }).firstMatch(Predicates.notNull()).orNull();
    }

    private void trackRequest(String requestId) {
        if (!this.operationSucceededPredicate.apply((Object)requestId)) {
            String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("tracking request", requestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(message, new Object[0]);
            throw new IllegalStateException(message);
        }
    }

    public Deployment internalDestroyNode(String nodeId) {
        Deployment deployment = this.getDeploymentFromNodeId(nodeId);
        if (deployment == null) {
            return null;
        }
        String deploymentName = deployment.name();
        String message = String.format("Deleting deployment(%s) of cloud service (%s)", nodeId, deploymentName);
        this.logger.debug(message, new Object[0]);
        if (deployment != null) {
            for (Role role : deployment.roleList()) {
                this.trackRequest(this.api.getVirtualMachineApiForDeploymentInService(deploymentName, role.roleName()).shutdown(nodeId, POST_SHUTDOWN_ACTION));
            }
            this.deleteDeployment(deploymentName, nodeId);
            this.logger.debug("Deleting cloud service (%s) ...", new Object[]{deploymentName});
            this.trackRequest(this.api.getCloudServiceApi().delete(deploymentName));
            this.logger.debug("Cloud service (%s) deleted.", new Object[]{deploymentName});
            for (Role role : deployment.roleList()) {
                final Role.OSVirtualHardDisk disk = role.osVirtualHardDisk();
                if (disk == null || new ConflictManagementPredicate(this.api, this.operationSucceededPredicate){

                    @Override
                    protected String operation() {
                        return AzureComputeServiceAdapter.this.api.getDiskApi().delete(disk.diskName());
                    }
                }.apply(nodeId)) continue;
                String illegalStateExceptionMessage = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Delete disk " + disk.diskName(), "Delete disk", this.azureComputeConstants.operationTimeout());
                this.logger.warn(illegalStateExceptionMessage, new Object[0]);
            }
        }
        return deployment;
    }

    public Deployment getDeploymentFromNodeId(final String nodeId) {
        final ArrayList nodes = Lists.newArrayList();
        Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                Deployment deployment = AzureComputeServiceAdapter.this.getNode(nodeId);
                if (deployment != null) {
                    nodes.add(deployment);
                }
                return !nodes.isEmpty();
            }
        }, (long)1800L, (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)nodeId);
        return (Deployment)Iterables.getFirst((Iterable)nodes, null);
    }

    public void destroyNode(String id) {
        this.logger.debug("Destroying %s ...", new Object[]{id});
        if (this.internalDestroyNode(id) != null) {
            this.logger.debug("Destroyed %s!", new Object[]{id});
        } else {
            this.logger.warn("Can't destroy %s!", new Object[]{id});
        }
    }

    public void rebootNode(String id) {
        CloudService cloudService = this.api.getCloudServiceApi().get(id);
        if (cloudService != null) {
            this.logger.debug("Restarting %s ...", new Object[]{id});
            this.trackRequest(this.api.getVirtualMachineApiForDeploymentInService(id, cloudService.name()).restart(id));
            this.logger.debug("Restarted %s", new Object[]{id});
        }
    }

    public void resumeNode(String id) {
        CloudService cloudService = this.api.getCloudServiceApi().get(id);
        if (cloudService != null) {
            this.logger.debug("Resuming %s ...", new Object[]{id});
            this.trackRequest(this.api.getVirtualMachineApiForDeploymentInService(id, cloudService.name()).start(id));
            if (!Predicates2.retry((Predicate)new Predicate<String>(){

                public boolean apply(String id) {
                    return AzureComputeServiceAdapter.this.getNode(id) != null;
                }
            }, (long)this.azureComputeConstants.operationTimeout(), (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)id)) {
                String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("waiting for node to resume", "", this.azureComputeConstants.operationTimeout());
                this.logger.warn(message, new Object[0]);
                throw new IllegalStateException(message);
            }
            this.logger.debug("Resumed %s", new Object[]{id});
        }
    }

    public void suspendNode(String id) {
        CloudService cloudService = this.api.getCloudServiceApi().get(id);
        if (cloudService != null) {
            this.logger.debug("Suspending %s ...", new Object[]{id});
            String postShutdownAction = this.azureComputeConstants.deallocateWhenSuspending() ? POST_SHUTDOWN_ACTION : POST_SHUTDOWN_ACTION_NO_DEALLOCATE;
            this.trackRequest(this.api.getVirtualMachineApiForDeploymentInService(id, cloudService.name()).shutdown(id, postShutdownAction));
            this.logger.debug("Suspended %s", new Object[]{id});
        }
    }

    public Iterable<Deployment> listNodes() {
        return FluentIterable.from(this.api.getCloudServiceApi().list()).transform((Function)new Function<CloudService, Deployment>(){

            public Deployment apply(CloudService cloudService) {
                return AzureComputeServiceAdapter.this.api.getDeploymentApiForService(cloudService.name()).get(cloudService.name());
            }
        }).filter(Predicates.notNull()).toSet();
    }

    public Iterable<Deployment> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Deployment>(){

            public boolean apply(Deployment input) {
                return Iterables.contains((Iterable)ids, (Object)input.name());
            }
        });
    }

    @VisibleForTesting
    public static URI createMediaLink(String storageServiceName, String diskName) {
        return URI.create(String.format("https://%s.blob.core.windows.net/vhds/disk-%s.vhd", storageServiceName, diskName));
    }

    private void deleteCloudService(final String name) {
        if (!new ConflictManagementPredicate(this.api){

            @Override
            protected String operation() {
                return AzureComputeServiceAdapter.this.api.getCloudServiceApi().delete(name);
            }
        }.apply(name)) {
            String deleteMessage = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Delete cloud service " + name, "CloudService delete", this.azureComputeConstants.operationTimeout());
            this.logger.warn(deleteMessage, new Object[0]);
            throw new IllegalStateException(deleteMessage);
        }
    }

    private void deleteDeployment(final String id, final String cloudServiceName) {
        if (!new ConflictManagementPredicate(this.api){

            @Override
            protected String operation() {
                return AzureComputeServiceAdapter.this.api.getDeploymentApiForService(cloudServiceName).delete(id);
            }
        }.apply(id)) {
            String deleteMessage = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Delete deployment " + cloudServiceName, "Deployment delete", this.azureComputeConstants.operationTimeout());
            this.logger.warn(deleteMessage, new Object[0]);
            throw new IllegalStateException(deleteMessage);
        }
    }

    private void checkRoleStatusInDeployment(final String name, Deployment deployment) {
        if (!Predicates2.retry((Predicate)new Predicate<Deployment>(){

            public boolean apply(Deployment deployment) {
                deployment = AzureComputeServiceAdapter.this.api.getDeploymentApiForService(deployment.name()).get(name);
                if (deployment.roleInstanceList() == null || deployment.roleInstanceList().isEmpty()) {
                    return false;
                }
                return Iterables.all(deployment.roleInstanceList(), (Predicate)new Predicate<Deployment.RoleInstance>(){

                    public boolean apply(Deployment.RoleInstance input) {
                        if (input.instanceStatus() == Deployment.InstanceStatus.PROVISIONING_FAILED) {
                            String message = String.format("Deployment %s is in provisioning failed status, so it will be destroyed.", name);
                            AzureComputeServiceAdapter.this.logger.warn(message, new Object[0]);
                            AzureComputeServiceAdapter.this.api.getDeploymentApiForService(name).delete(name);
                            AzureComputeServiceAdapter.this.api.getCloudServiceApi().delete(name);
                            throw new IllegalStateException(message);
                        }
                        return input.instanceStatus() == Deployment.InstanceStatus.READY_ROLE;
                    }
                });
            }
        }, (long)this.azureComputeConstants.operationTimeout(), (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)deployment)) {
            String message = String.format("Role %s has not reached the READY_ROLE within %sms so it will be destroyed.", deployment.name(), this.azureComputeConstants.operationTimeout());
            this.logger.warn(message, new Object[0]);
            this.api.getDeploymentApiForService(name).delete(name);
            this.api.getCloudServiceApi().delete(name);
            throw new IllegalStateException(message);
        }
    }

    public static String generateIllegalStateExceptionMessage(String prefix, String operationId, long timeout) {
        String warnMessage = String.format("%s - %s has not been completed within %sms.", prefix, operationId, timeout);
        return String.format("%s. Please, try by increasing `%s` and try again", warnMessage, "jclouds.azurecompute.operation.timeout");
    }
}

