/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import org.jclouds.azurecompute.domain.UpdateStorageServiceParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class UpdateStorageServiceParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        UpdateStorageServiceParams params = (UpdateStorageServiceParams)UpdateStorageServiceParams.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"UpdateStorageServiceInput", (String)"http://schemas.microsoft.com/windowsazure");
            if (params.description() != null) {
                builder.e("Description").t(params.description()).up();
            }
            if (params.label() != null) {
                builder.e("Label").t(BaseEncoding.base64().encode(params.label().getBytes(Charsets.UTF_8))).up();
            }
            if (params.geoReplicationEnabled() != null) {
                builder.e("geoReplicationEnabled").t(params.geoReplicationEnabled().toString()).up();
            }
            if (params.extendedProperties() != null) {
                XMLBuilder extProps = builder.e("ExtendedProperties");
                for (Map.Entry entry : params.extendedProperties().entrySet()) {
                    XMLBuilder extProp = extProps.e("ExtendedProperty");
                    extProp.e("Name").t((String)entry.getKey()).up();
                    extProp.e("Value").t((String)entry.getValue()).up();
                    extProp.up();
                }
                extProps.up();
            }
            if (params.customDomains() != null) {
                XMLBuilder custDomains = builder.e("CustomDomains");
                for (UpdateStorageServiceParams.CustomDomain customDomain : params.customDomains()) {
                    XMLBuilder custDomain = custDomains.e("CustomDomain");
                    custDomain.e("Name").t(customDomain.name()).up();
                    custDomain.e("UseSubDomainName").t(customDomain.useSubDomainName().toString()).up();
                    custDomain.up();
                }
                custDomains.up();
            }
            if (params.accountType() != null) {
                builder.e("AccountType").t(params.accountType().name()).up();
            }
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

