/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.DeploymentParams;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class DeploymentParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        DeploymentParams params = (DeploymentParams)DeploymentParams.class.cast(input);
        try {
            XMLBuilder configBuilder;
            XMLBuilder deploymentBuilder = XMLBuilder.create((String)"Deployment", (String)"http://schemas.microsoft.com/windowsazure").e("Name").t(params.name()).up().e("DeploymentSlot").t("Production").up().e("Label").t(params.name()).up();
            XMLBuilder roleBuilder = deploymentBuilder.e("RoleList").e("Role").e("RoleName").t(params.name()).up().e("RoleType").t("PersistentVMRole").up();
            XMLBuilder configSetsBuilder = roleBuilder.e("ConfigurationSets");
            if (params.os() == OSImage.Type.WINDOWS) {
                configBuilder = configSetsBuilder.e("ConfigurationSet");
                String listenerProtocol = params.winrmUseHttps() != null && params.winrmUseHttps() != false ? "Https" : "Http";
                configBuilder.e("ConfigurationSetType").t("WindowsProvisioningConfiguration").up().e("ComputerName").t(params.name()).up().e("AdminPassword").t(params.password()).up().e("ResetPasswordOnFirstLogon").t("false").up().e("EnableAutomaticUpdate").t("false").up().e("DomainJoin").e("Credentials").e("Domain").t(params.name()).up().e("Username").t(params.username()).up().e("Password").t(params.password()).up().up().e("JoinDomain").t(params.name()).up().up().e("StoredCertificateSettings").up().e("WinRM").e("Listeners").e("Listener").e("Protocol").t(listenerProtocol).up().up().up().up().e("AdminUsername").t(params.username()).up().e("AdminPassword").t(params.username()).up().up();
            } else if (params.os() == OSImage.Type.LINUX) {
                configBuilder = configSetsBuilder.e("ConfigurationSet");
                configBuilder.e("ConfigurationSetType").t("LinuxProvisioningConfiguration").up().e("HostName").t(params.name()).up().e("UserName").t(params.username()).up().e("UserPassword").t(params.password()).up().e("DisableSshPasswordAuthentication").t("false").up().e("SSH").e("PublicKeys").up().e("KeyPairs").up().up();
            } else {
                throw new IllegalArgumentException("Unrecognized os type " + params);
            }
            configBuilder = configSetsBuilder.e("ConfigurationSet");
            configBuilder.e("ConfigurationSetType").t("NetworkConfiguration").up();
            XMLBuilder inputEndpoints = configBuilder.e("InputEndpoints");
            for (DeploymentParams.ExternalEndpoint endpoint : params.externalEndpoints()) {
                XMLBuilder inputBuilder = inputEndpoints.e("InputEndpoint");
                inputBuilder.e("LocalPort").t(Integer.toString(endpoint.localPort())).up().e("Name").t(endpoint.name()).up().e("Port").t(Integer.toString(endpoint.port())).up().e("Protocol").t(endpoint.protocol().toLowerCase()).up().up();
            }
            inputEndpoints.up();
            XMLBuilder subnetNames = configBuilder.e("SubnetNames");
            if (!params.subnetNames().isEmpty()) {
                for (String subnetName : params.subnetNames()) {
                    subnetNames.e("SubnetName").t(subnetName).up().up();
                }
            }
            roleBuilder.e("DataVirtualHardDisks").up().e("OSVirtualHardDisk").e("HostCaching").t("ReadWrite").up().e("MediaLink").t(params.mediaLink().toASCIIString()).up().e("SourceImageName").t(params.sourceImageName()).up().e("OS").t(params.os() == OSImage.Type.LINUX ? "Linux" : "Windows").up().up().e("RoleSize").t(params.size().getText()).up();
            if (params.provisionGuestAgent() != null) {
                roleBuilder.e("ProvisionGuestAgent").t(params.provisionGuestAgent().toString()).up();
            }
            if (params.virtualNetworkName() != null) {
                configSetsBuilder.up().up().up().e("VirtualNetworkName").t(params.virtualNetworkName()).up();
            }
            if (params.reservedIPName() != null) {
                configSetsBuilder.up().up().up().e("ReservedIPName").t(params.reservedIPName()).up();
            }
            return (R)((HttpRequest.Builder)request.toBuilder().payload(configSetsBuilder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

