/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Pipe {
    final long maxBufferSize;
    final Buffer buffer = new Buffer();
    boolean sinkClosed;
    boolean sourceClosed;
    private final Sink sink = new PipeSink();
    private final Source source = new PipeSource();

    public Pipe(long maxBufferSize) {
        if (maxBufferSize < 1L) {
            throw new IllegalArgumentException("maxBufferSize < 1: " + maxBufferSize);
        }
        this.maxBufferSize = maxBufferSize;
    }

    public Source source() {
        return this.source;
    }

    public Sink sink() {
        return this.sink;
    }

    final class PipeSource
    implements Source {
        final Timeout timeout = new Timeout();

        PipeSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sourceClosed) {
                    throw new IllegalStateException("closed");
                }
                while (Pipe.this.buffer.size() == 0L) {
                    if (Pipe.this.sinkClosed) {
                        return -1L;
                    }
                    this.timeout.waitUntilNotified(Pipe.this.buffer);
                }
                long result = Pipe.this.buffer.read(sink, byteCount);
                Pipe.this.buffer.notifyAll();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                Pipe.this.sourceClosed = true;
                Pipe.this.buffer.notifyAll();
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }

    final class PipeSink
    implements Sink {
        final Timeout timeout = new Timeout();

        PipeSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    throw new IllegalStateException("closed");
                }
                while (byteCount > 0L) {
                    if (Pipe.this.sourceClosed) {
                        throw new IOException("source is closed");
                    }
                    long bufferSpaceAvailable = Pipe.this.maxBufferSize - Pipe.this.buffer.size();
                    if (bufferSpaceAvailable == 0L) {
                        this.timeout.waitUntilNotified(Pipe.this.buffer);
                        continue;
                    }
                    long bytesToWrite = Math.min(bufferSpaceAvailable, byteCount);
                    Pipe.this.buffer.write(source, bytesToWrite);
                    byteCount -= bytesToWrite;
                    Pipe.this.buffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    throw new IllegalStateException("closed");
                }
                while (Pipe.this.buffer.size() > 0L) {
                    if (Pipe.this.sourceClosed) {
                        throw new IOException("source is closed");
                    }
                    this.timeout.waitUntilNotified(Pipe.this.buffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    return;
                }
                try {
                    this.flush();
                }
                finally {
                    Pipe.this.sinkClosed = true;
                    Pipe.this.buffer.notifyAll();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }
}

