/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.base.Optional;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindMetadataToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.functions.internal.OnlyMetadataValueOrNull;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseDiagnostics;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseServerDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseServers;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.options.RebuildServerOptions;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/servers")
public interface ServerApi {
    @Named(value="server:list")
    @GET
    @ResponseParser(value=ParseServers.class)
    @Transform(value=ParseServers.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Resource> list();

    @Named(value="server:list")
    @GET
    @ResponseParser(value=ParseServers.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Resource> list(PaginationOptions var1);

    @Named(value="server:list")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseServerDetails.class)
    @Transform(value=ParseServerDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Server> listInDetail();

    @Named(value="server:list")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseServerDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Server> listInDetail(PaginationOptions var1);

    @Named(value="server:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"server"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Server get(@PathParam(value="id") String var1);

    @Named(value="server:create")
    @POST
    @Unwrap
    @MapBinder(value=CreateServerOptions.class)
    public ServerCreated create(@PayloadParam(value="name") String var1, @PayloadParam(value="imageRef") String var2, @PayloadParam(value="flavorRef") String var3, CreateServerOptions ... var4);

    @Named(value="server:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="server:start")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="{\"os-start\":null}")
    public void start(@PathParam(value="id") String var1);

    @Named(value="server:stop")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="{\"os-stop\":null}")
    public void stop(@PathParam(value="id") String var1);

    @Named(value="server:reboot")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"reboot\":%7B\"type\":\"{type}\"%7D%7D")
    public void reboot(@PathParam(value="id") String var1, @PayloadParam(value="type") RebootType var2);

    @Named(value="server:resize")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"resize\":%7B\"flavorRef\":{flavorId}%7D%7D")
    public void resize(@PathParam(value="id") String var1, @PayloadParam(value="flavorId") String var2);

    @Named(value="server:confirmResize")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="{\"confirmResize\":null}")
    public void confirmResize(@PathParam(value="id") String var1);

    @Named(value="server:revertResize")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="{\"revertResize\":null}")
    public void revertResize(@PathParam(value="id") String var1);

    @Named(value="server:rebuild")
    @POST
    @Path(value="/{id}/action")
    @MapBinder(value=RebuildServerOptions.class)
    public void rebuild(@PathParam(value="id") String var1, RebuildServerOptions ... var2);

    @Named(value="server:changeAdminPass")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"changePassword\":%7B\"adminPass\":\"{adminPass}\"%7D%7D")
    public void changeAdminPass(@PathParam(value="id") String var1, @PayloadParam(value="adminPass") String var2);

    @Named(value="server:rename")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"server\":%7B\"name\":\"{name}\"%7D%7D")
    public void rename(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @Named(value="server:createImageFromServer")
    @POST
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"createImage\":%7B\"name\":\"{name}\", \"metadata\": %7B%7D%7D%7D")
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    @Fallback(value=MapHttp4xxCodesToExceptions.class)
    public String createImageFromServer(@PayloadParam(value="name") String var1, @PathParam(value="id") String var2);

    @Named(value="server:getMetadata")
    @GET
    @Path(value="/{id}/metadata")
    @SelectJson(value={"metadata"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public Map<String, String> getMetadata(@PathParam(value="id") String var1);

    @Named(value="server:setMetadata")
    @PUT
    @Path(value="/{id}/metadata")
    @SelectJson(value={"metadata"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Map<String, String> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="server:updateMetadata")
    @POST
    @Path(value="/{id}/metadata")
    @Produces(value={"application/json"})
    @SelectJson(value={"metadata"})
    @MapBinder(value=BindToJsonPayload.class)
    public Map<String, String> updateMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="server:getMetadata")
    @GET
    @Path(value="/{id}/metadata/{key}")
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public String getMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="server:updateMetadata")
    @PUT
    @Path(value="/{id}/metadata/{key}")
    @Produces(value={"application/json"})
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @MapBinder(value=BindMetadataToJsonPayload.class)
    public String updateMetadata(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PathParam(value="value") @PayloadParam(value="value") String var3);

    @Named(value="server:deleteMetadata")
    @DELETE
    @Path(value="/{id}/metadata/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="server:getDiagnostics")
    @GET
    @Path(value="/{id}/diagnostics")
    @ResponseParser(value=ParseDiagnostics.class)
    @Fallback(value=Fallbacks.AbsentOn403Or404Or500.class)
    public Optional<Map<String, String>> getDiagnostics(@PathParam(value="id") String var1);
}

