/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;

    @Inject
    public CreateSecurityGroupIfNeeded(NovaApi novaApi) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
    }

    public SecurityGroupInRegion apply(RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts) {
        Preconditions.checkNotNull((Object)regionSecurityGroupNameAndPorts, (Object)"regionSecurityGroupNameAndPorts");
        String regionId = regionSecurityGroupNameAndPorts.getRegion();
        Optional<SecurityGroupApi> api = this.novaApi.getSecurityGroupApi(regionId);
        Preconditions.checkArgument((boolean)api.isPresent(), (String)"Security groups are required, but the extension is not available in region %s!", (Object[])new Object[]{regionId});
        FluentIterable<SecurityGroup> allGroups = ((SecurityGroupApi)api.get()).list();
        this.logger.debug(">> creating securityGroup %s", new Object[]{regionSecurityGroupNameAndPorts});
        try {
            SecurityGroup securityGroup = ((SecurityGroupApi)api.get()).createWithDescription(regionSecurityGroupNameAndPorts.getName(), regionSecurityGroupNameAndPorts.getName());
            this.logger.debug("<< created securityGroup(%s)", new Object[]{securityGroup});
            for (int port : regionSecurityGroupNameAndPorts.getPorts()) {
                this.authorizeGroupToItselfAndAllIPsToTCPPort((SecurityGroupApi)api.get(), securityGroup, port);
            }
            return new SecurityGroupInRegion(((SecurityGroupApi)api.get()).get(securityGroup.getId()), regionId, (Iterable<SecurityGroup>)allGroups);
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{regionSecurityGroupNameAndPorts, e.getMessage()});
            SecurityGroup group = (SecurityGroup)Iterables.find(allGroups, SecurityGroupPredicates.nameEquals(regionSecurityGroupNameAndPorts.getName()));
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{group.getId()});
            return new SecurityGroupInRegion(group, regionId, (Iterable<SecurityGroup>)allGroups);
        }
    }

    private void authorizeGroupToItselfAndAllIPsToTCPPort(SecurityGroupApi securityGroupApi, SecurityGroup securityGroup, int port) {
        this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
        securityGroupApi.createRuleAllowingCidrBlock(securityGroup.getId(), ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(IpProtocol.TCP)).fromPort(port)).toPort(port)).build(), "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
    }
}

