/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.CleanupServer;
import org.jclouds.openstack.nova.v2_0.compute.options.NodeAndNovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

public class AllocateAndAddFloatingIpToNode
implements Function<AtomicReference<NodeAndNovaTemplateOptions>, AtomicReference<NodeMetadata>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final NovaApi novaApi;
    private final LoadingCache<RegionAndId, Iterable<? extends FloatingIP>> floatingIpCache;
    private final CleanupServer cleanupServer;

    @Inject
    public AllocateAndAddFloatingIpToNode(@Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<RegionAndId, Iterable<? extends FloatingIP>> floatingIpCache, CleanupServer cleanupServer) {
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.floatingIpCache = (LoadingCache)Preconditions.checkNotNull(floatingIpCache, (Object)"floatingIpCache");
        this.cleanupServer = (CleanupServer)Preconditions.checkNotNull((Object)cleanupServer, (Object)"cleanupServer");
    }

    public AtomicReference<NodeMetadata> apply(AtomicReference<NodeAndNovaTemplateOptions> input) {
        Preconditions.checkState((boolean)this.nodeRunning.apply(input.get().getNodeMetadata()), (String)"node never achieved state running %s", (Object[])new Object[]{input.get().getNodeMetadata()});
        NodeMetadata node = input.get().getNodeMetadata().get();
        String regionId = node.getLocation().getParent().getId();
        FloatingIPApi floatingIpApi = (FloatingIPApi)this.novaApi.getFloatingIPApi(regionId).get();
        Optional<Set<String>> poolNames = input.get().getNovaTemplateOptions().get().getFloatingIpPoolNames();
        Optional<FloatingIP> ip = this.allocateFloatingIPForNode(floatingIpApi, poolNames, node.getId());
        if (!ip.isPresent()) {
            this.cleanupServer.apply(node.getId());
            throw new InsufficientResourcesException("Failed to allocate a FloatingIP for node(" + node.getId() + ")");
        }
        this.logger.debug(">> adding floatingIp(%s) to node(%s)", new Object[]{((FloatingIP)ip.get()).getIp(), node.getId()});
        floatingIpApi.addToServer(((FloatingIP)ip.get()).getIp(), node.getProviderId());
        input.get().getNodeMetadata().set(NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).publicAddresses((Iterable)ImmutableSet.of((Object)((FloatingIP)ip.get()).getIp())).build());
        this.floatingIpCache.asMap().putIfAbsent(RegionAndId.fromSlashEncoded(node.getId()), ImmutableList.of((Object)ip.get()));
        return input.get().getNodeMetadata();
    }

    private synchronized Optional<FloatingIP> allocateFloatingIPForNode(FloatingIPApi floatingIpApi, Optional<Set<String>> poolNames, String nodeID) {
        FloatingIP ip = null;
        if (poolNames.isPresent()) {
            for (String poolName : (Set)poolNames.get()) {
                try {
                    this.logger.debug(">> allocating floating IP from pool %s for node(%s)", new Object[]{poolName, nodeID});
                    ip = floatingIpApi.allocateFromPool(poolName);
                    return Optional.of((Object)ip);
                }
                catch (ResourceNotFoundException ex) {
                    this.logger.trace("<< [%s] failed to allocate floating IP from pool %s for node(%s)", new Object[]{ex.getMessage(), poolName, nodeID});
                }
                catch (InsufficientResourcesException ire) {
                    this.logger.trace("<< [%s] failed to allocate floating IP from pool %s for node(%s)", new Object[]{ire.getMessage(), poolName, nodeID});
                }
            }
        }
        try {
            this.logger.debug(">> creating floating IP for node(%s)", new Object[]{nodeID});
            ip = floatingIpApi.create();
            return Optional.of((Object)ip);
        }
        catch (ResourceNotFoundException ex) {
            this.logger.trace("<< [%s] failed to create floating IP for node(%s)", new Object[]{ex.getMessage(), nodeID});
        }
        catch (InsufficientResourcesException ire) {
            this.logger.trace("<< [%s] failed to create floating IP for node(%s)", new Object[]{ire.getMessage(), nodeID});
        }
        this.logger.trace(">> searching for existing, unassigned floating IP for node(%s)", new Object[]{nodeID});
        ArrayList unassignedIps = Lists.newArrayList((Iterable)Iterables.filter(floatingIpApi.list(), (Predicate)new Predicate<FloatingIP>(){

            public boolean apply(FloatingIP arg0) {
                return arg0.getFixedIp() == null;
            }
        }));
        if (unassignedIps.isEmpty()) {
            return Optional.absent();
        }
        Collections.shuffle(unassignedIps);
        ip = (FloatingIP)Iterables.getLast((Iterable)unassignedIps);
        return Optional.fromNullable((Object)ip);
    }

    public String toString() {
        return Objects.toStringHelper((String)"AllocateAndAddFloatingIpToNode").toString();
    }
}

