/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking.creator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.location.jclouds.api.JcloudsLocationConfigPublic;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.azurecompute.arm.domain.VirtualNetwork;
import org.jclouds.azurecompute.arm.features.SubnetApi;
import org.jclouds.azurecompute.arm.features.VirtualNetworkApi;
import org.jclouds.compute.ComputeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAzureArmNetworkCreator {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultAzureArmNetworkCreator.class);
    private static final String DEFAULT_RESOURCE_GROUP_PREFIX = "brooklyn-default-resource-group";
    private static final String DEFAULT_NETWORK_NAME_PREFIX = "brooklyn-default-network";
    private static final String DEFAULT_SUBNET_NAME_PREFIX = "brooklyn-default-subnet";
    private static final String PROVISIONING_STATE_UPDATING = "Updating";
    private static final String PROVISIONING_STATE_SUCCEEDED = "Succeeded";
    private static final String DEFAULT_VNET_ADDRESS_PREFIX = "10.1.0.0/16";
    private static final String DEFAULT_SUBNET_ADDRESS_PREFIX = "10.1.0.0/24";
    public static ConfigKey<Boolean> AZURE_ARM_DEFAULT_NETWORK_ENABLED = ConfigKeys.newBooleanConfigKey((String)"azure.arm.default.network.enabled", (String)"When set to true, AMP will create a default network and subnet per Azure region and deploy applications there (if no network configuration has been set for the application).", (Boolean)true);

    public static void createDefaultNetworkAndAddToTemplateOptionsIfRequired(ComputeService computeService, ConfigBag config) {
        if (!((Boolean)config.get(AZURE_ARM_DEFAULT_NETWORK_ENABLED)).booleanValue()) {
            LOG.debug("azure.arm.default.network.enabled is disabled, not creating default network");
            return;
        }
        String location = (String)config.get(CloudLocationConfig.CLOUD_REGION_ID);
        if (StringUtils.isEmpty((CharSequence)location)) {
            LOG.debug("No region information, so cannot create a default network");
            return;
        }
        Map templateOptions = (Map)config.get(JcloudsLocationConfigPublic.TEMPLATE_OPTIONS);
        if (config.containsKey(JcloudsLocationConfigPublic.NETWORK_NAME)) {
            LOG.debug("Network config [{}] specified when provisioning Azure machine. Not creating default network", (Object)JcloudsLocationConfigPublic.NETWORK_NAME.getName());
            return;
        }
        if (templateOptions != null && (templateOptions.containsKey("networks") || templateOptions.containsKey("ipOptions"))) {
            LOG.debug("Network config specified when provisioning Azure machine. Not creating default network");
            return;
        }
        AzureComputeApi api = (AzureComputeApi)computeService.getContext().unwrapApi(AzureComputeApi.class);
        String resourceGroupName = "brooklyn-default-resource-group-" + location;
        String vnetName = "brooklyn-default-network-" + location;
        String subnetName = "brooklyn-default-subnet-" + location;
        SubnetApi subnetApi = api.getSubnetApi(resourceGroupName, vnetName);
        VirtualNetworkApi virtualNetworkApi = api.getVirtualNetworkApi(resourceGroupName);
        Subnet preexistingSubnet = subnetApi.get(subnetName);
        if (preexistingSubnet != null) {
            LOG.info("Using pre-existing default Azure network [{}] and subnet [{}] when provisioning machine", (Object)vnetName, (Object)subnetName);
            DefaultAzureArmNetworkCreator.updateTemplateOptions(config, preexistingSubnet);
            return;
        }
        DefaultAzureArmNetworkCreator.createResourceGroupIfNeeded(api, resourceGroupName, location);
        Subnet.SubnetProperties subnetProperties = Subnet.SubnetProperties.builder().addressPrefix(DEFAULT_SUBNET_ADDRESS_PREFIX).build();
        if (virtualNetworkApi.get(vnetName) == null) {
            LOG.info("Network config not specified when provisioning Azure machine, and default network/subnet does not exists. Creating network [{}] and subnet [{}], and updating template options", (Object)vnetName, (Object)subnetName);
            Subnet subnet = Subnet.create((String)subnetName, null, null, (Subnet.SubnetProperties)subnetProperties);
            VirtualNetwork.VirtualNetworkProperties virtualNetworkProperties = VirtualNetwork.VirtualNetworkProperties.builder().addressSpace(VirtualNetwork.AddressSpace.create(Arrays.asList(DEFAULT_VNET_ADDRESS_PREFIX))).subnets(Arrays.asList(subnet)).build();
            virtualNetworkApi.createOrUpdate(vnetName, location, virtualNetworkProperties);
        } else {
            LOG.info("Network config not specified when provisioning Azure machine, and default subnet does not exists. Creating subnet [{}] on network [{}], and updating template options", (Object)subnetName, (Object)vnetName);
            subnetApi.createOrUpdate(subnetName, subnetProperties);
        }
        Subnet createdSubnet = api.getSubnetApi(resourceGroupName, vnetName).get(subnetName);
        CountdownTimer timeout = CountdownTimer.newInstanceStarted((Duration)Duration.minutes((Number)new Integer(20)));
        while (createdSubnet == null || createdSubnet.properties() == null || PROVISIONING_STATE_UPDATING.equals(createdSubnet.properties().provisioningState())) {
            if (timeout.isExpired()) {
                throw new IllegalStateException("Creating subnet " + subnetName + " stuck in the updating state, aborting.");
            }
            LOG.debug("Created subnet {} is still in updating state, waiting for it to complete", (Object)createdSubnet);
            Duration.sleep((Duration)Duration.ONE_SECOND);
            createdSubnet = api.getSubnetApi(resourceGroupName, vnetName).get(subnetName);
        }
        String lastProvisioningState = createdSubnet.properties().provisioningState();
        if (!lastProvisioningState.equals(PROVISIONING_STATE_SUCCEEDED)) {
            LOG.debug("Created subnet {} in wrong state, expected state {} but found {}", new Object[]{subnetName, PROVISIONING_STATE_SUCCEEDED, lastProvisioningState});
            throw new IllegalStateException("Created subnet " + subnetName + " in wrong state, expected state " + PROVISIONING_STATE_SUCCEEDED + " but found " + lastProvisioningState);
        }
        DefaultAzureArmNetworkCreator.updateTemplateOptions(config, createdSubnet);
    }

    private static void updateTemplateOptions(ConfigBag config, Subnet createdSubnet) {
        MutableMap templateOptions = config.containsKey(JcloudsLocationConfigPublic.TEMPLATE_OPTIONS) ? MutableMap.copyOf((Map)((Map)config.get(JcloudsLocationConfigPublic.TEMPLATE_OPTIONS))) : new HashMap();
        templateOptions.put("ipOptions", ImmutableList.of((Object)ImmutableMap.of((Object)"allocateNewPublicIp", (Object)true, (Object)"subnet", (Object)createdSubnet.id())));
        config.put(JcloudsLocationConfigPublic.TEMPLATE_OPTIONS, (Object)templateOptions);
    }

    private static void createResourceGroupIfNeeded(AzureComputeApi api, String resourceGroup, String location) {
        ResourceGroup rg = api.getResourceGroupApi().get(resourceGroup);
        if (rg == null) {
            LOG.info("Default Azure resource group [{}] does not exist in {}. Creating!", (Object)resourceGroup, (Object)location);
            api.getResourceGroupApi().create(resourceGroup, location, (Map)ImmutableMap.of((Object)"description", (Object)"brooklyn default resource group"));
        } else {
            LOG.debug("Using existing default Azure resource group [{}] in {}", (Object)resourceGroup, (Object)location);
        }
    }
}

