/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.xml.ws.WebServiceException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineLocationCustomizer;
import org.apache.brooklyn.api.location.MachineManagementMixins;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.BasicMachineMetadata;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.access.PortMapping;
import org.apache.brooklyn.core.location.cloud.AbstractCloudMachineProvisioningLocation;
import org.apache.brooklyn.core.location.cloud.AvailabilityZoneExtension;
import org.apache.brooklyn.core.location.cloud.names.AbstractCloudMachineNamer;
import org.apache.brooklyn.core.location.cloud.names.CloudMachineNamer;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.jclouds.JcloudsBlobStoreBasedObjectStore;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.location.jclouds.BrooklynImageChooser;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistry;
import org.apache.brooklyn.location.jclouds.ConnectivityResolver;
import org.apache.brooklyn.location.jclouds.ConnectivityResolverOptions;
import org.apache.brooklyn.location.jclouds.CreateUserStatements;
import org.apache.brooklyn.location.jclouds.DefaultConnectivityResolver;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineNamer;
import org.apache.brooklyn.location.jclouds.JcloudsPredicates;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.location.jclouds.JcloudsWinRmMachineLocation;
import org.apache.brooklyn.location.jclouds.LocationCustomizerDelegate;
import org.apache.brooklyn.location.jclouds.ManagementAddressResolveResult;
import org.apache.brooklyn.location.jclouds.RebindToMachinePredicate;
import org.apache.brooklyn.location.jclouds.api.JcloudsLocationPublic;
import org.apache.brooklyn.location.jclouds.networking.JcloudsPortForwarderExtension;
import org.apache.brooklyn.location.jclouds.networking.creator.DefaultAzureArmNetworkCreator;
import org.apache.brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateBuilderCustomizer;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateBuilderCustomizers;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizers;
import org.apache.brooklyn.location.jclouds.zone.AwsAvailabilityZoneExtension;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.config.ResolvingConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.Protocol;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.ssh.IptablesCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.config.AdminAccessConfiguration;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.util.Predicates2;
import org.jclouds.util.Throwables2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsLocation
extends AbstractCloudMachineProvisioningLocation
implements JcloudsLocationPublic {
    public static final Logger LOG = LoggerFactory.getLogger(JcloudsLocation.class);
    private static final int NOTES_MAX_LENGTH = 1000;
    @VisibleForTesting
    static final String AWS_VPC_HELP_URL = "http://brooklyn.apache.org/v/latest/locations/#ec2-classic-problems-with-vpc-only-hardware-instance-types";
    private final AtomicBoolean listedAvailableTemplatesOnNoSuchTemplate = new AtomicBoolean(false);
    private final Map<String, Map<String, ? extends Object>> tagMapping = Maps.newLinkedHashMap();
    @SetFromFlag
    private final Map<MachineLocation, String> vmInstanceIds = Maps.newLinkedHashMap();
    public static final Map<ConfigKey<?>, ? extends TemplateBuilderCustomizer> SUPPORTED_TEMPLATE_BUILDER_PROPERTIES;
    public static final Map<ConfigKey<?>, ? extends TemplateOptionCustomizer> SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES;

    public JcloudsLocation() {
    }

    public JcloudsLocation(Map<?, ?> conf) {
        super(conf);
    }

    @Deprecated
    public JcloudsLocation configure(Map<?, ?> properties) {
        super.configure(properties);
        if (this.config().getLocalBag().containsKey("providerLocationId")) {
            LOG.warn("Using deprecated 'providerLocationId' key in " + this);
            if (!this.config().getLocalBag().containsKey(CLOUD_REGION_ID)) {
                this.config().putAll((Map)MutableMap.of((Object)CLOUD_REGION_ID.getName(), (Object)((String)this.config().getLocalBag().getStringKey("providerLocationId"))));
            }
        }
        if (this.isDisplayNameAutoGenerated() || !JavaGroovyEquivalents.groovyTruth((String)this.getDisplayName())) {
            this.setDisplayName(JavaGroovyEquivalents.elvis((String)this.getProvider(), (String)"unknown") + (JavaGroovyEquivalents.groovyTruth((String)this.getRegion()) ? ":" + this.getRegion() : "") + (JavaGroovyEquivalents.groovyTruth((String)this.getEndpoint()) ? ":" + this.getEndpoint() : ""));
        }
        if (this.getConfig(MACHINE_CREATION_SEMAPHORE) == null) {
            Integer maxConcurrent = (Integer)this.getConfig(MAX_CONCURRENT_MACHINE_CREATIONS);
            if (maxConcurrent == null || maxConcurrent < 1) {
                throw new IllegalStateException(MAX_CONCURRENT_MACHINE_CREATIONS.getName() + " must be >= 1, but was " + maxConcurrent);
            }
            this.config().set(MACHINE_CREATION_SEMAPHORE, (Object)new Semaphore(maxConcurrent, true));
        }
        return this;
    }

    public void init() {
        super.init();
        if ("aws-ec2".equals(this.getProvider())) {
            this.addExtension(AvailabilityZoneExtension.class, (Object)new AwsAvailabilityZoneExtension(this.getManagementContext(), this));
        }
    }

    public JcloudsLocation newSubLocation(Map<?, ?> newFlags) {
        return this.newSubLocation(this.getClass(), (Map)newFlags);
    }

    public JcloudsLocation newSubLocation(Class<? extends AbstractCloudMachineProvisioningLocation> type, Map<?, ?> newFlags) {
        return (JcloudsLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(type).parent((org.apache.brooklyn.api.location.Location)this).configure(this.config().getLocalBag().getAllConfig())).configure(MACHINE_CREATION_SEMAPHORE, (Object)this.getMachineCreationSemaphore())).configure(newFlags));
    }

    public String toString() {
        String identity = this.getIdentity();
        String configDescription = this.config().getLocalBag().getDescription();
        if (configDescription != null && configDescription.startsWith(this.getClass().getSimpleName())) {
            return configDescription;
        }
        return this.getClass().getSimpleName() + "[" + this.getDisplayName() + ":" + (identity != null ? identity : null) + (configDescription != null ? "/" + configDescription : "") + "@" + this.getId() + "]";
    }

    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("identity", (Object)this.getIdentity()).add("description", (Object)this.config().getLocalBag().getDescription()).add("provider", (Object)this.getProvider()).add("region", (Object)this.getRegion()).add("endpoint", (Object)this.getEndpoint()).toString();
    }

    @Override
    public String getProvider() {
        return (String)this.getConfig(CLOUD_PROVIDER);
    }

    @Override
    public String getIdentity() {
        return (String)this.getConfig(ACCESS_IDENTITY);
    }

    @Override
    public String getCredential() {
        return (String)this.getConfig(ACCESS_CREDENTIAL);
    }

    @Override
    public String getRegion() {
        return (String)this.getConfig(CLOUD_REGION_ID);
    }

    @Override
    public String getEndpoint() {
        return (String)this.config().getBag().getWithDeprecation(CLOUD_ENDPOINT, new ConfigKey[]{JCLOUDS_KEY_ENDPOINT});
    }

    public String getUser(ConfigBag config) {
        return (String)config.getWithDeprecation(USER, new ConfigKey[]{JCLOUDS_KEY_USERNAME});
    }

    public boolean isWindows(Template template, ConfigBag config) {
        return this.isWindows(template.getImage(), config);
    }

    public boolean isWindows(Image image, ConfigBag config) {
        OperatingSystem os;
        org.jclouds.compute.domain.OsFamily override = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY_OVERRIDE);
        if (override != null) {
            return override == org.jclouds.compute.domain.OsFamily.WINDOWS;
        }
        org.jclouds.compute.domain.OsFamily confFamily = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY);
        OperatingSystem operatingSystem = os = image != null ? image.getOperatingSystem() : null;
        return os != null && os.getFamily() != org.jclouds.compute.domain.OsFamily.UNRECOGNIZED ? org.jclouds.compute.domain.OsFamily.WINDOWS == os.getFamily() : org.jclouds.compute.domain.OsFamily.WINDOWS == confFamily;
    }

    public boolean isWindows(NodeMetadata node, ConfigBag config) {
        OperatingSystem os;
        org.jclouds.compute.domain.OsFamily override = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY_OVERRIDE);
        if (override != null) {
            return override == org.jclouds.compute.domain.OsFamily.WINDOWS;
        }
        org.jclouds.compute.domain.OsFamily confFamily = (org.jclouds.compute.domain.OsFamily)config.get(OS_FAMILY);
        OperatingSystem operatingSystem = os = node != null ? node.getOperatingSystem() : null;
        return os != null && os.getFamily() != org.jclouds.compute.domain.OsFamily.UNRECOGNIZED ? org.jclouds.compute.domain.OsFamily.WINDOWS == os.getFamily() : org.jclouds.compute.domain.OsFamily.WINDOWS == confFamily;
    }

    public boolean isLocationFirewalldEnabled(SshMachineLocation location) {
        int result = location.execCommands("checking if firewalld is active", (List)ImmutableList.of((Object)IptablesCommands.firewalldServiceIsActive()));
        return result == 0;
    }

    protected Semaphore getMachineCreationSemaphore() {
        return (Semaphore)Preconditions.checkNotNull((Object)this.getConfig(MACHINE_CREATION_SEMAPHORE), (Object)MACHINE_CREATION_SEMAPHORE.getName());
    }

    protected CloudMachineNamer getCloudMachineNamer(ConfigBag config) {
        String namerClass = (String)config.get(LocationConfigKeys.CLOUD_MACHINE_NAMER_CLASS);
        if (Strings.isNonBlank((CharSequence)namerClass)) {
            Maybe cloudNamer = Reflections.invokeConstructorFromArgs((ClassLoader)this.getManagementContext().getCatalogClassLoader(), CloudMachineNamer.class, (String)namerClass, (Object[])new Object[0]);
            if (cloudNamer.isPresent()) {
                return (CloudMachineNamer)cloudNamer.get();
            }
            throw new IllegalStateException("Failed to create CloudMachineNamer " + namerClass + " for location " + this);
        }
        return new JcloudsMachineNamer();
    }

    public Collection<JcloudsLocationCustomizer> getCustomizers(ConfigBag setup) {
        try {
            return LocationCustomizerDelegate.getCustomizers(this.getManagementContext(), setup);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create initialize customizers for location " + this);
        }
    }

    public ConnectivityResolver getLocationNetworkInfoCustomizer(ConfigBag setup) {
        ConnectivityResolver configured = (ConnectivityResolver)setup.get(CONNECTIVITY_RESOLVER);
        return configured != null ? configured : new DefaultConnectivityResolver();
    }

    protected Collection<MachineLocationCustomizer> getMachineCustomizers(ConfigBag setup) {
        try {
            return LocationCustomizerDelegate.getMachineCustomizers(this.getManagementContext(), setup);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create initialize customizers for location " + this);
        }
    }

    public void setDefaultImageId(String val) {
        this.config().set(DEFAULT_IMAGE_ID, (Object)val);
    }

    public void setTagMapping(Map<String, Map<String, ? extends Object>> val) {
        this.tagMapping.clear();
        this.tagMapping.putAll(val);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ArrayList unmatchedTags = Lists.newArrayList();
        for (String it : tags) {
            if (JavaGroovyEquivalents.groovyTruth(this.tagMapping.get(it)) && !JavaGroovyEquivalents.groovyTruth((Object)result)) {
                result.putAll(this.tagMapping.get(it));
                continue;
            }
            unmatchedTags.add(it);
        }
        if (unmatchedTags.size() > 0) {
            LOG.debug("Location {}, failed to match provisioning tags {}", (Object)this, (Object)unmatchedTags);
        }
        return result;
    }

    public static final Set<ConfigKey<?>> getAllSupportedProperties() {
        LinkedHashSet configsOnClass = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)ConfigUtils.getStaticKeysOnClass(JcloudsLocation.class), (Function)new Function<ConfigKey.HasConfigKey<?>, String>(){

            @Nullable
            public String apply(@Nullable ConfigKey.HasConfigKey<?> input) {
                return input.getConfigKey().getName();
            }
        }));
        ImmutableSet configKeysInList = ImmutableSet.builder().addAll(SUPPORTED_TEMPLATE_BUILDER_PROPERTIES.keySet()).addAll(SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.keySet()).build();
        LinkedHashSet configsInList = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)configKeysInList, (Function)new Function<ConfigKey<?>, String>(){

            @Nullable
            public String apply(@Nullable ConfigKey<?> input) {
                return input.getName();
            }
        }));
        Sets.SetView extrasInList = Sets.difference((Set)configsInList, (Set)configsOnClass);
        if (!extrasInList.isEmpty()) {
            LOG.warn("JcloudsLocation supported properties differs from config defined on class: " + extrasInList);
        }
        return Collections.unmodifiableSet(configKeysInList);
    }

    public ComputeService getComputeService() {
        return this.getComputeService((Map<?, ?>)MutableMap.of());
    }

    public ComputeService getComputeService(Map<?, ?> flags) {
        ConfigBag conf = flags == null || flags.isEmpty() ? this.config().getBag() : ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        return this.getComputeService(conf);
    }

    public ComputeService getComputeService(ConfigBag config) {
        ComputeServiceRegistry registry = (ComputeServiceRegistry)this.getConfig(COMPUTE_SERVICE_REGISTRY);
        return registry.findComputeService(ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)config), true);
    }

    public Map<String, MachineManagementMixins.MachineMetadata> listMachines() {
        Set nodes = this.getRegion() != null ? this.getComputeService().listNodesDetailsMatching(JcloudsPredicates.nodeInLocation(this.getRegion(), true)) : this.getComputeService().listNodes();
        LinkedHashMap<String, MachineManagementMixins.MachineMetadata> result = new LinkedHashMap<String, MachineManagementMixins.MachineMetadata>();
        for (ComputeMetadata node : nodes) {
            result.put(node.getId(), this.getMachineMetadata(node));
        }
        return result;
    }

    protected MachineManagementMixins.MachineMetadata getMachineMetadata(ComputeMetadata node) {
        if (node == null) {
            return null;
        }
        return new BasicMachineMetadata(node.getId(), node.getName(), node instanceof NodeMetadata ? (String)Iterators.tryFind(((NodeMetadata)node).getPublicAddresses().iterator(), (Predicate)Predicates.alwaysTrue()).orNull() : null, node instanceof NodeMetadata ? Boolean.valueOf(((NodeMetadata)node).getStatus() == NodeMetadata.Status.RUNNING) : null, (Object)node);
    }

    public MachineManagementMixins.MachineMetadata getMachineMetadata(MachineLocation l) {
        if (l instanceof JcloudsSshMachineLocation) {
            return this.getMachineMetadata((ComputeMetadata)this.getComputeService().getNodeMetadata(((JcloudsSshMachineLocation)l).getJcloudsId()));
        }
        return null;
    }

    public void killMachine(String cloudServiceId) {
        Set destroyed = this.getComputeService().destroyNodesMatching(NodePredicates.withIds((String[])new String[]{cloudServiceId}));
        LOG.debug("Destroyed nodes %s%n", (Object)destroyed);
    }

    public void killMachine(MachineLocation l) {
        MachineManagementMixins.MachineMetadata m = this.getMachineMetadata(l);
        if (m == null) {
            throw new NoSuchElementException("Machine " + l + " is not known at " + this);
        }
        this.killMachine(m.getId());
    }

    protected String getCreationString(ConfigBag config) {
        return JavaGroovyEquivalents.elvis((String)((String)config.get(CLOUD_PROVIDER)), (String)"unknown") + (config.containsKey(CLOUD_REGION_ID) ? ":" + (String)config.get(CLOUD_REGION_ID) : "") + (config.containsKey(CLOUD_ENDPOINT) ? ":" + (String)config.get(CLOUD_ENDPOINT) : "") + (config.containsKey(CALLER_CONTEXT) ? "@" + config.get(CALLER_CONTEXT) : "");
    }

    public MachineLocation obtain() throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of());
    }

    public MachineLocation obtain(TemplateBuilder tb) throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of(), tb);
    }

    public MachineLocation obtain(Map<?, ?> flags, TemplateBuilder tb) throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.builder().putAll(flags).put((Object)TEMPLATE_BUILDER, (Object)tb).build());
    }

    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        Object cause;
        ConfigBag setupRaw = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        ConfigBag setup = ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)setupRaw);
        Map flagTemplateOptions = (Map)ConfigBag.newInstance(flags).get(TEMPLATE_OPTIONS);
        Map baseTemplateOptions = (Map)this.config().get(TEMPLATE_OPTIONS);
        Map templateOptions = (Map)this.shallowMerge(Maybe.fromNullable((Object)flagTemplateOptions), Maybe.fromNullable((Object)baseTemplateOptions), TEMPLATE_OPTIONS).orNull();
        setup.put(TEMPLATE_OPTIONS, (Object)templateOptions);
        Integer attempts = (Integer)setup.get(MACHINE_CREATE_ATTEMPTS);
        ArrayList exceptions = Lists.newArrayList();
        if (attempts == null || attempts < 1) {
            attempts = 1;
        }
        for (int i = 1; i <= attempts; ++i) {
            try {
                return this.obtainOnce(setup);
            }
            catch (RuntimeException e) {
                LOG.warn("Attempt #{}/{} to obtain machine threw error: {}", new Object[]{i, attempts, e});
                exceptions.add(e);
                continue;
            }
        }
        String msg = String.format("Failed to get VM after %d attempt%s.", attempts, attempts == 1 ? "" : "s");
        Object object = cause = exceptions.size() == 1 ? (Exception)exceptions.get(0) : new CompoundRuntimeException(msg + " - First cause is " + exceptions.get(0) + " (listed in primary trace); plus " + (exceptions.size() - 1) + " more (e.g. the last is " + exceptions.get(exceptions.size() - 1) + ")", (Throwable)exceptions.get(0), (Iterable)exceptions);
        if (exceptions.get(exceptions.size() - 1) instanceof NoMachinesAvailableException) {
            throw new NoMachinesAvailableException(msg, (Throwable)cause);
        }
        throw Exceptions.propagate((Throwable)cause);
    }

    protected ConnectivityResolverOptions.Builder getConnectivityOptionsBuilder(ConfigBag setup, boolean isWindows) {
        boolean pollEnabled;
        boolean waitForSshable = !"false".equalsIgnoreCase((String)setup.get(JcloudsLocationConfig.WAIT_FOR_SSHABLE));
        boolean waitForWinRmable = !"false".equalsIgnoreCase((String)setup.get(JcloudsLocationConfig.WAIT_FOR_WINRM_AVAILABLE));
        boolean waitForConnectable = isWindows ? waitForWinRmable : waitForSshable;
        boolean usePortForwarding = (Boolean)setup.get(JcloudsLocationConfig.USE_PORT_FORWARDING);
        boolean skipJcloudsSshing = usePortForwarding || Boolean.FALSE.equals(setup.get(JcloudsLocationConfig.USE_JCLOUDS_SSH_INIT));
        ConnectivityResolverOptions.Builder builder = ConnectivityResolverOptions.builder().waitForConnectable(waitForConnectable).usePortForwarding(usePortForwarding).skipJcloudsSshing(skipJcloudsSshing);
        String pollForFirstReachable = (String)setup.get(JcloudsLocationConfig.POLL_FOR_FIRST_REACHABLE_ADDRESS);
        boolean bl = pollEnabled = !"false".equalsIgnoreCase(pollForFirstReachable);
        if (pollEnabled) {
            Predicate<? super HostAndPort> reachableAddressesPredicate = this.getReachableAddressesPredicate(setup);
            Duration pollTimeout = "true".equals(pollForFirstReachable) ? Duration.FIVE_MINUTES : Duration.of((Object)pollForFirstReachable);
            builder.pollForReachableAddresses(reachableAddressesPredicate, pollTimeout, true);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MachineLocation obtainOnce(ConfigBag setup) throws NoMachinesAvailableException {
        AccessController.Response access = this.getManagementContext().getAccessController().canProvisionLocation((org.apache.brooklyn.api.location.Location)this);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids provisioning in " + this + ": " + access.getMsg());
        }
        Predicate<? super HostAndPort> reachablePredicate = this.getReachableAddressesPredicate(setup);
        ConnectivityResolverOptions options = this.getConnectivityOptionsBuilder(setup, false).build();
        JcloudsPortForwarderExtension portForwarder = (JcloudsPortForwarderExtension)setup.get(PORT_FORWARDER);
        if (options.usePortForwarding()) {
            Preconditions.checkNotNull((Object)portForwarder, (Object)"portForwarder, when use-port-forwarding enabled");
        }
        ComputeService computeService = this.getComputeService(setup);
        CloudMachineNamer cloudMachineNamer = this.getCloudMachineNamer(setup);
        String groupId = JavaGroovyEquivalents.elvis((String)((String)setup.get(GROUP_ID)), (String)cloudMachineNamer.generateNewGroupId(setup));
        NodeMetadata node = null;
        JcloudsMachineLocation machineLocation = null;
        Duration semaphoreTimestamp = null;
        Duration templateTimestamp = null;
        Duration provisionTimestamp = null;
        Duration usableTimestamp = null;
        Duration customizedTimestamp = null;
        Stopwatch provisioningStopwatch = Stopwatch.createStarted();
        JcloudsLocationCustomizer customizersDelegate = LocationCustomizerDelegate.newInstance(this.getManagementContext(), setup);
        try {
            LoginCredentials createdCredentials;
            Set nodes;
            Template template;
            LOG.info("Creating VM " + this.getCreationString(setup) + " in " + this);
            Semaphore machineCreationSemaphore = this.getMachineCreationSemaphore();
            boolean acquired = machineCreationSemaphore.tryAcquire(0L, TimeUnit.SECONDS);
            if (!acquired) {
                LOG.info("Waiting in {} for machine-creation permit ({} other queuing requests already)", new Object[]{this, machineCreationSemaphore.getQueueLength()});
                Stopwatch blockStopwatch = Stopwatch.createStarted();
                machineCreationSemaphore.acquire();
                LOG.info("Acquired in {} machine-creation permit, after waiting {}", (Object)this, (Object)Time.makeTimeStringRounded((Stopwatch)blockStopwatch));
            } else {
                LOG.debug("Acquired in {} machine-creation permit immediately", (Object)this);
            }
            semaphoreTimestamp = Duration.of((Object)provisioningStopwatch);
            LoginCredentials userCredentials = null;
            try {
                if ("azurecompute-arm".equals(this.getProvider())) {
                    DefaultAzureArmNetworkCreator.createDefaultNetworkAndAddToTemplateOptionsIfRequired(computeService, setup);
                }
                template = this.buildTemplate(computeService, setup, (Collection<JcloudsLocationCustomizer>)ImmutableList.of((Object)customizersDelegate));
                boolean expectWindows = this.isWindows(template, setup);
                if (!options.skipJcloudsSshing()) {
                    if (expectWindows) {
                        LOG.warn("Ignoring invalid configuration for Windows provisioning of " + template.getImage() + ": " + USE_JCLOUDS_SSH_INIT.getName() + " should be false");
                        options = options.toBuilder().skipJcloudsSshing(true).build();
                    } else if (options.waitForConnectable()) {
                        userCredentials = this.initTemplateForCreateUser(template, setup);
                    }
                }
                templateTimestamp = Duration.of((Object)provisioningStopwatch);
                template.getOptions().getUserMetadata().put("Name", cloudMachineNamer.generateNewMachineUniqueNameFromGroupId(setup, groupId));
                if (((Boolean)setup.get(JcloudsLocationConfig.INCLUDE_BROOKLYN_USER_METADATA)).booleanValue()) {
                    template.getOptions().getUserMetadata().put("brooklyn-user", System.getProperty("user.name"));
                    Object context = setup.get(CALLER_CONTEXT);
                    if (context instanceof Entity) {
                        Entity entity = (Entity)context;
                        template.getOptions().getUserMetadata().put("brooklyn-app-id", entity.getApplicationId());
                        template.getOptions().getUserMetadata().put("brooklyn-app-name", entity.getApplication().getDisplayName());
                        template.getOptions().getUserMetadata().put("brooklyn-entity-id", entity.getId());
                        template.getOptions().getUserMetadata().put("brooklyn-entity-name", entity.getDisplayName());
                        template.getOptions().getUserMetadata().put("brooklyn-server-creation-date", Time.makeDateSimpleStampString());
                    }
                }
                this.customizeTemplate(computeService, template, customizersDelegate);
                LOG.debug("jclouds using template {} / options {} to provision machine in {}", new Object[]{template, template.getOptions(), this.getCreationString(setup)});
                nodes = computeService.createNodesInGroup(groupId, 1, template);
                provisionTimestamp = Duration.of((Object)provisioningStopwatch);
            }
            finally {
                machineCreationSemaphore.release();
            }
            node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes, null);
            LOG.debug("jclouds created {} for {}", (Object)node, (Object)this.getCreationString(setup));
            if (node == null) {
                throw new IllegalStateException("No nodes returned by jclouds create-nodes in " + this.getCreationString(setup));
            }
            customizersDelegate.customize(this, node, setup);
            boolean windows = this.isWindows(node, setup);
            if (windows) {
                int newLoginPort = node.getLoginPort() == 22 ? (((Boolean)setup.get(WinRmMachineLocation.USE_HTTPS_WINRM)).booleanValue() ? 5986 : 5985) : node.getLoginPort();
                String newLoginUser = "root".equals(node.getCredentials().getUser()) ? "Administrator" : node.getCredentials().getUser();
                LOG.debug("jclouds created Windows VM {}; transforming connection details: loginPort from {} to {}; loginUser from {} to {}", new Object[]{node, node.getLoginPort(), newLoginPort, node.getCredentials().getUser(), newLoginUser});
                node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).loginPort(newLoginPort).credentials(LoginCredentials.builder((Credentials)node.getCredentials()).user(newLoginUser).build()).build();
            }
            Optional portForwardSshOverride = options.usePortForwarding() ? Optional.of((Object)portForwarder.openPortForwarding(node, node.getLoginPort(), (Optional<Integer>)Optional.absent(), Protocol.TCP, Cidr.UNIVERSAL)) : Optional.absent();
            options = options.toBuilder().isWindows(windows).defaultLoginPort(node.getLoginPort()).portForwardSshOverride((HostAndPort)portForwardSshOverride.orNull()).initialCredentials(node.getCredentials()).userCredentials(userCredentials).build();
            ConnectivityResolver networkInfoCustomizer = this.getLocationNetworkInfoCustomizer(setup);
            ManagementAddressResolveResult hostPortCred = networkInfoCustomizer.resolve(this, node, setup, options);
            HostAndPort managementHostAndPort = hostPortCred.hostAndPort();
            LoginCredentials creds = hostPortCred.credentials();
            LOG.info("Using host-and-port={} and user={} when connecting to {}", new Object[]{managementHostAndPort, creds.getUser(), node});
            if (options.skipJcloudsSshing() && options.waitForConnectable() && (createdCredentials = this.createUser(computeService, node, managementHostAndPort, creds, setup)) != null) {
                userCredentials = createdCredentials;
            }
            if (userCredentials == null) {
                userCredentials = creds;
            }
            this.putIfPresentButDifferent(setup, (ConfigKey<String>)JcloudsLocationConfig.PASSWORD, (String)userCredentials.getOptionalPassword().orNull());
            this.putIfPresentButDifferent(setup, (ConfigKey<String>)JcloudsLocationConfig.PRIVATE_KEY_DATA, (String)userCredentials.getOptionalPrivateKey().orNull());
            if (options.waitForConnectable() && !options.isWindows()) {
                this.waitForSshable(computeService, node, managementHostAndPort, (Iterable<LoginCredentials>)ImmutableList.of((Object)userCredentials), setup);
            } else {
                LOG.debug("Skipping ssh check for {} ({}) due to config waitForConnectable={}, windows={}", new Object[]{node, this.getCreationString(setup), options.waitForConnectable(), windows});
            }
            node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).credentials(null).build();
            usableTimestamp = Duration.of((Object)provisioningStopwatch);
            machineLocation = windows ? this.registerWinRmMachineLocation(computeService, node, (Optional<Template>)Optional.fromNullable((Object)template), userCredentials, managementHostAndPort, setup) : this.registerJcloudsSshMachineLocation(computeService, node, (Optional<Template>)Optional.fromNullable((Object)template), userCredentials, managementHostAndPort, setup);
            PortForwardManager portForwardManager = (PortForwardManager)setup.get(PORT_FORWARDING_MANAGER);
            if (portForwardManager == null) {
                LOG.debug("No PortForwardManager, using default");
                portForwardManager = (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
            }
            if (options.usePortForwarding() && portForwardSshOverride.isPresent()) {
                portForwardManager.associate(node.getId(), (HostAndPort)portForwardSshOverride.get(), (org.apache.brooklyn.api.location.Location)machineLocation, node.getLoginPort());
            }
            if ("docker".equals(this.getProvider())) {
                if (windows) {
                    throw new UnsupportedOperationException("Docker not supported on Windows");
                }
                Map<Integer, Integer> portMappings = JcloudsUtil.dockerPortMappingsFor(this, node.getId());
                for (Integer containerPort : portMappings.keySet()) {
                    Integer hostPort = portMappings.get(containerPort);
                    String dockerHost = ((JcloudsSshMachineLocation)machineLocation).getSshHostAndPort().getHostText();
                    portForwardManager.associate(node.getId(), HostAndPort.fromParts((String)dockerHost, (int)hostPort), (org.apache.brooklyn.api.location.Location)machineLocation, containerPort.intValue());
                }
            }
            ArrayList<String> customisationForLogging = new ArrayList<String>();
            if (options.waitForConnectable()) {
                String extraKeyDataToAuth;
                List extraKeyUrlsToAuth;
                String setupScript = (String)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_URL);
                List setupScripts = (List)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_URL_LIST);
                MutableList allScripts = new MutableList().appendIfNotNull((Object)setupScript).appendAll((Iterable)setupScripts);
                for (String setupScriptItem : allScripts) {
                    if (!Strings.isNonBlank((CharSequence)setupScriptItem)) continue;
                    customisationForLogging.add("custom setup script " + setupScriptItem);
                    String setupVarsString = (String)setup.get(JcloudsLocationConfig.CUSTOM_MACHINE_SETUP_SCRIPT_VARS);
                    Map substitutions = setupVarsString != null ? Splitter.on((String)",").withKeyValueSeparator(":").split((CharSequence)setupVarsString) : ImmutableMap.of();
                    String scriptContent = ResourceUtils.create((Object)this).getResourceAsString(setupScriptItem);
                    String script = TemplateProcessor.processTemplateContents((String)scriptContent, (ManagementContext)this.getManagementContext(), (Map)substitutions);
                    if (windows) {
                        WinRmToolResponse resp = ((WinRmMachineLocation)machineLocation).executeCommand((List)ImmutableList.copyOf((Object[])script.replace("\r", "").split("\n")));
                        if (resp.getStatusCode() == 0) continue;
                        throw new IllegalStateException("Command 'Customizing node " + this + "' failed with exit code " + resp.getStatusCode() + " for location " + machineLocation);
                    }
                    this.executeCommandThrowingOnError((SshMachineLocation)machineLocation, "Customizing node " + this, (List<String>)ImmutableList.of((Object)script));
                }
                Boolean dontRequireTtyForSudo = (Boolean)setup.get(JcloudsLocationConfig.DONT_REQUIRE_TTY_FOR_SUDO);
                if (Boolean.TRUE.equals(dontRequireTtyForSudo) || dontRequireTtyForSudo == null && ((Boolean)setup.get(DONT_CREATE_USER)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag DONT_REQUIRE_TTY_FOR_SUDO on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("patch /etc/sudoers to disable requiretty");
                        this.queueLocationTask("patch /etc/sudoers to disable requiretty", ((ProcessTaskWrapper)SshTasks.dontRequireTtyForSudo((SshMachineLocation)((SshMachineLocation)machineLocation), (boolean)true).newTask()).asTask());
                    }
                }
                if (((Boolean)setup.get(JcloudsLocationConfig.MAP_DEV_RANDOM_TO_DEV_URANDOM)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag MAP_DEV_RANDOM_TO_DEV_URANDOM on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("point /dev/random to urandom");
                        this.executeCommandThrowingOnError((SshMachineLocation)machineLocation, "using urandom instead of random", Arrays.asList(BashCommands.sudo((String)"mv /dev/random /dev/random-real"), BashCommands.sudo((String)"ln -s /dev/urandom /dev/random")));
                    }
                }
                if (((Boolean)setup.get(GENERATE_HOSTNAME)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring flag GENERATE_HOSTNAME on Windows location {}", (Object)machineLocation);
                    } else {
                        customisationForLogging.add("configure hostname");
                        this.executeCommandThrowingOnError((SshMachineLocation)machineLocation, "Generate hostname " + node.getName(), (List<String>)ImmutableList.of((Object)BashCommands.chainGroup((String[])new String[]{String.format("echo '127.0.0.1 %s' | ( %s )", node.getName(), BashCommands.sudo((String)"tee -a /etc/hosts")), "{ " + BashCommands.sudo((String)("sed -i \"s/HOSTNAME=.*/HOSTNAME=" + node.getName() + "/g\" /etc/sysconfig/network")) + " || true ; }", BashCommands.sudo((String)("hostname " + node.getName()))})));
                    }
                }
                if (((Boolean)setup.get(OPEN_IPTABLES)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring DEPRECATED flag OPEN_IPTABLES on Windows location {}", (Object)machineLocation);
                    } else {
                        LOG.warn("Using DEPRECATED flag OPEN_IPTABLES (will not be supported in future versions) for {} at {}", (Object)machineLocation, (Object)this);
                        List inboundPorts = Ints.asList((int[])template.getOptions().getInboundPorts());
                        if (inboundPorts == null || Iterables.isEmpty((Iterable)inboundPorts)) {
                            LOG.info("No ports to open in iptables (no inbound ports) for {} at {}", (Object)machineLocation, (Object)this);
                        } else {
                            customisationForLogging.add("open iptables");
                            ArrayList iptablesRules = Lists.newArrayList();
                            if (this.isLocationFirewalldEnabled((SshMachineLocation)machineLocation)) {
                                for (Object port : inboundPorts) {
                                    iptablesRules.add(IptablesCommands.addFirewalldRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)((Integer)port), (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT));
                                }
                            } else {
                                iptablesRules = Lists.newArrayList();
                                for (Object port : inboundPorts) {
                                    iptablesRules.add(IptablesCommands.insertIptablesRule((IptablesCommands.Chain)IptablesCommands.Chain.INPUT, (Protocol)Protocol.TCP, (int)((Integer)port), (IptablesCommands.Policy)IptablesCommands.Policy.ACCEPT));
                                }
                                iptablesRules.add(IptablesCommands.saveIptablesRules());
                            }
                            ArrayList batch = Lists.newArrayList();
                            for (String rule : iptablesRules) {
                                batch.add(rule);
                                if (batch.size() != 50) continue;
                                this.executeCommandWarningOnError((SshMachineLocation)machineLocation, "Inserting iptables rules, 50 command batch", batch);
                                batch.clear();
                            }
                            if (batch.size() > 0) {
                                this.executeCommandWarningOnError((SshMachineLocation)machineLocation, "Inserting iptables rules", batch);
                            }
                            this.executeCommandWarningOnError((SshMachineLocation)machineLocation, "List iptables rules", (List<String>)ImmutableList.of((Object)IptablesCommands.listIptablesRule()));
                        }
                    }
                }
                if (((Boolean)setup.get(STOP_IPTABLES)).booleanValue()) {
                    if (windows) {
                        LOG.warn("Ignoring DEPRECATED flag OPEN_IPTABLES on Windows location {}", (Object)machineLocation);
                    } else {
                        LOG.warn("Using DEPRECATED flag STOP_IPTABLES (will not be supported in future versions) for {} at {}", (Object)machineLocation, (Object)this);
                        customisationForLogging.add("stop iptables");
                        ImmutableList cmds = ImmutableList.of();
                        cmds = this.isLocationFirewalldEnabled((SshMachineLocation)machineLocation) ? ImmutableList.of((Object)IptablesCommands.firewalldServiceStop(), (Object)IptablesCommands.firewalldServiceStatus()) : ImmutableList.of((Object)IptablesCommands.iptablesServiceStop(), (Object)IptablesCommands.iptablesServiceStatus());
                        this.executeCommandWarningOnError((SshMachineLocation)machineLocation, "Stopping iptables", (List<String>)cmds);
                    }
                }
                if ((extraKeyUrlsToAuth = (List)setup.get(EXTRA_PUBLIC_KEY_URLS_TO_AUTH)) != null && !extraKeyUrlsToAuth.isEmpty()) {
                    if (windows) {
                        LOG.warn("Ignoring flag EXTRA_PUBLIC_KEY_URLS_TO_AUTH on Windows location", (Object)machineLocation);
                    } else {
                        extraKeyDataToAuth = MutableList.of();
                        for (String keyUrl : extraKeyUrlsToAuth) {
                            extraKeyDataToAuth.add(ResourceUtils.create().getResourceAsString(keyUrl));
                        }
                        this.executeCommandThrowingOnError((SshMachineLocation)machineLocation, "Authorizing ssh keys from URLs", (List<String>)ImmutableList.of((Object)new AuthorizeRSAPublicKeys((Iterable)((Object)extraKeyDataToAuth)).render(OsFamily.UNIX)));
                    }
                }
                if ((extraKeyDataToAuth = (String)setup.get(EXTRA_PUBLIC_KEY_DATA_TO_AUTH)) != null && !extraKeyDataToAuth.isEmpty()) {
                    if (windows) {
                        LOG.warn("Ignoring flag EXTRA_PUBLIC_KEY_DATA_TO_AUTH on Windows location", (Object)machineLocation);
                    } else {
                        this.executeCommandThrowingOnError((SshMachineLocation)machineLocation, "Authorizing ssh keys from data", (List<String>)ImmutableList.of((Object)new AuthorizeRSAPublicKeys(Collections.singletonList(extraKeyDataToAuth)).render(OsFamily.UNIX)));
                    }
                }
            }
            customizersDelegate.customize(this, computeService, machineLocation);
            customizedTimestamp = Duration.of((Object)provisioningStopwatch);
            String logMessage = "Finished VM " + this.getCreationString(setup) + " creation: " + machineLocation.getUser() + "@" + machineLocation.getAddress() + ":" + machineLocation.getPort() + (Boolean.TRUE.equals(setup.get(LOG_CREDENTIALS)) ? "password=" + (String)userCredentials.getOptionalPassword().or((Object)"<absent>") + " && key=" + (String)userCredentials.getOptionalPrivateKey().or((Object)"<absent>") : "") + " ready after " + Duration.of((Object)provisioningStopwatch).toStringRounded() + " (semaphore obtained in " + Duration.of((Object)semaphoreTimestamp).toStringRounded() + ";" + template + " template built in " + Duration.of((Object)templateTimestamp).subtract(semaphoreTimestamp).toStringRounded() + "; " + node + " provisioned in " + Duration.of((Object)provisionTimestamp).subtract(templateTimestamp).toStringRounded() + "; " + machineLocation + " connection usable in " + Duration.of((Object)usableTimestamp).subtract(provisionTimestamp).toStringRounded() + "; and os customized in " + Duration.of((Object)customizedTimestamp).subtract(usableTimestamp).toStringRounded() + " - " + Joiner.on((String)", ").join(customisationForLogging) + ")";
            LOG.info(logMessage);
            return machineLocation;
        }
        catch (Exception e2) {
            UserFacingException e2;
            boolean destroyNode;
            if (e2 instanceof RunNodesException && ((RunNodesException)e2).getNodeErrors().size() > 0) {
                node = (NodeMetadata)Iterables.get(((RunNodesException)e2).getNodeErrors().keySet(), (int)0);
            }
            boolean bl = destroyNode = node != null && Boolean.TRUE.equals(setup.get(DESTROY_ON_FAILURE));
            if (e2.toString().contains("VPCResourceNotSpecified")) {
                String message = "Detected that your EC2 account is a legacy 'EC2 Classic' account, but the most appropriate hardware instance type requires 'VPC'. One quick fix is to use the 'eu-central-1' region. Other remedies are described at http://brooklyn.apache.org/v/latest/locations/#ec2-classic-problems-with-vpc-only-hardware-instance-types";
                LOG.error(message);
                e2 = new UserFacingException(message, (Throwable)e2);
            }
            LOG.error("Failed to start VM for " + this.getCreationString(setup) + (destroyNode ? " (destroying)" : "") + (node != null ? "; node " + node : "") + " after " + Duration.of((Object)provisioningStopwatch).toStringRounded() + (semaphoreTimestamp != null ? " (semaphore obtained in " + Duration.of((Object)semaphoreTimestamp).toStringRounded() + ";" + (templateTimestamp != null && semaphoreTimestamp != null ? " template built in " + Duration.of((Object)templateTimestamp).subtract(semaphoreTimestamp).toStringRounded() + ";" : "") + (provisionTimestamp != null && templateTimestamp != null ? " node provisioned in " + Duration.of(provisionTimestamp).subtract(templateTimestamp).toStringRounded() + ";" : "") + (usableTimestamp != null && provisioningStopwatch != null ? " connection usable in " + Duration.of(usableTimestamp).subtract(provisionTimestamp).toStringRounded() + ";" : "") + (customizedTimestamp != null && usableTimestamp != null ? " and OS customized in " + Duration.of(customizedTimestamp).subtract(usableTimestamp).toStringRounded() : "") + ")" : "") + ": " + e2.getMessage());
            LOG.debug(Throwables.getStackTraceAsString((Throwable)e2));
            try {
                customizersDelegate.preReleaseOnObtainError(this, machineLocation, (Exception)e2);
            }
            catch (Exception customizerException) {
                LOG.info("Got exception on calling customizer preReleaseOnObtainError, ignoring. Location is {}, machine location is {}, node is {}", new Object[]{this, machineLocation, node, customizerException});
            }
            if (destroyNode) {
                Stopwatch destroyingStopwatch = Stopwatch.createStarted();
                if (machineLocation != null) {
                    this.releaseSafely(machineLocation);
                } else {
                    this.releaseNodeSafely(node);
                }
                LOG.info("Destroyed " + (machineLocation != null ? "machine " + machineLocation : "node " + node) + " in " + Duration.of((Object)destroyingStopwatch).toStringRounded());
                try {
                    customizersDelegate.postReleaseOnObtainError(this, machineLocation, (Exception)e2);
                }
                catch (Exception customizerException) {
                    LOG.debug("Got exception on calling customizer postReleaseOnObtainError, ignoring. Location is {}, machine Location is {}, node is {}", new Object[]{this, machineLocation, node, customizerException});
                }
            }
            throw Exceptions.propagate((Throwable)e2);
        }
    }

    private void executeCommandThrowingOnError(SshMachineLocation loc, String name, List<String> commands) {
        this.executeCommandThrowingOnError((Map<String, Object>)ImmutableMap.of(), loc, name, commands);
    }

    private void executeCommandThrowingOnError(Map<String, Object> flags, SshMachineLocation loc, String name, List<String> commands) {
        Task task = ((ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)loc, commands).summary(name).requiringExitCodeZero().configure(flags).newTask()).asTask();
        this.queueLocationTask("waiting for '" + name + "' on machine " + loc, task);
    }

    protected <T> T queueLocationTask(String msg, Task<T> task) {
        DynamicTasks.TaskQueueingResult queueResult = DynamicTasks.queueIfPossible(task);
        String origDetails = Tasks.setBlockingDetails((String)msg);
        try {
            if (queueResult.isQueuedOrSubmitted()) {
                Object object = task.getUnchecked();
                return (T)object;
            }
            Object v = ((TaskInternal)task).getJob().call();
            return (T)v;
        }
        finally {
            Tasks.setBlockingDetails((String)origDetails);
        }
    }

    private void executeCommandWarningOnError(SshMachineLocation loc, String name, List<String> commands) {
        Task task = ((ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)loc, commands).summary(name).allowingNonZeroExitCode().newTask()).asTask();
        int ret = (Integer)this.queueLocationTask("waiting for '" + name + "' on machine " + loc, task);
        if (ret != 0) {
            LOG.warn("Command '{}' failed with exit code {} for location {}", new Object[]{name, ret, this});
        }
    }

    private void putIfPresentButDifferent(ConfigBag setup, ConfigKey<String> key, String expectedValue) {
        if (expectedValue == null) {
            return;
        }
        String currentValue = (String)setup.get(key);
        if (Objects.equal((Object)currentValue, (Object)expectedValue)) {
            return;
        }
        setup.put(key, (Object)expectedValue);
    }

    public void suspendMachine(MachineLocation rawLocation) {
        String instanceId = this.vmInstanceIds.remove(rawLocation);
        if (instanceId == null) {
            LOG.info("Attempt to suspend unknown machine " + rawLocation + " in " + this);
            throw new IllegalArgumentException("Unknown machine " + rawLocation);
        }
        LOG.info("Suspending machine {} in {}, instance id {}", new Object[]{rawLocation, this, instanceId});
        Exception toThrow = null;
        try {
            this.getComputeService().suspendNode(instanceId);
        }
        catch (Exception e) {
            toThrow = e;
            LOG.error("Problem suspending machine " + rawLocation + " in " + this + ", instance id " + instanceId, (Throwable)e);
        }
        this.removeChild((org.apache.brooklyn.api.location.Location)rawLocation);
        if (toThrow != null) {
            throw Exceptions.propagate((Throwable)toThrow);
        }
    }

    public JcloudsMachineLocation resumeMachine(Map<?, ?> flags) {
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        LOG.info("{} using resuming node matching properties: {}", (Object)this, (Object)Sanitizer.sanitize((ConfigBag)setup));
        ComputeService computeService = this.getComputeService(setup);
        NodeMetadata node = this.findNodeOrThrow(setup);
        LOG.debug("{} resuming {}", (Object)this, (Object)node);
        computeService.resumeNode(node.getId());
        node = this.findNodeOrThrow(setup);
        LOG.debug("{} resumed {}", (Object)this, (Object)node);
        JcloudsMachineLocation registered = this.registerMachineLocation(setup, node);
        LOG.info("{} resumed and registered {}", (Object)this, (Object)registered);
        return registered;
    }

    protected void customizeTemplate(ComputeService computeService, Template template, JcloudsLocationCustomizer customizersDelegate) {
        customizersDelegate.customize(this, computeService, template);
        customizersDelegate.customize(this, computeService, template.getOptions());
        if (template.getOptions() instanceof SoftLayerTemplateOptions) {
            Map md;
            SoftLayerTemplateOptions slT = (SoftLayerTemplateOptions)template.getOptions();
            if (Strings.isBlank((CharSequence)slT.getDomainName()) || "jclouds.org".equals(slT.getDomainName())) {
                slT.domainName("local.brooklyncentral.org");
            }
            if ((md = slT.getUserMetadata()) != null && !md.isEmpty()) {
                MutableSet tags = MutableSet.copyOf((Iterable)slT.getTags());
                for (Map.Entry entry : md.entrySet()) {
                    tags.add(AbstractCloudMachineNamer.sanitize((String)((String)entry.getKey())) + ":" + AbstractCloudMachineNamer.sanitize((String)((String)entry.getValue())));
                }
                slT.tags((Iterable)tags);
                if (!md.containsKey("notes")) {
                    String notes = "User Metadata\n=============\n\n  * " + Joiner.on((String)"\n  * ").withKeyValueSeparator(": ").join(md);
                    if (notes.length() > 1000) {
                        String truncatedMsg = "...\n<truncated - notes total length is " + notes.length() + " characters>";
                        notes = notes.substring(0, 1000 - truncatedMsg.length()) + truncatedMsg;
                    }
                    md.put("notes", notes);
                }
            }
        }
    }

    protected Function<Iterable<? extends Image>, Image> getImageChooser(ComputeService computeService, ConfigBag config) {
        Function chooser;
        Object rawVal = config.getStringKey(JcloudsLocationConfig.IMAGE_CHOOSER.getName());
        if (rawVal instanceof String && Strings.isNonBlank((CharSequence)((String)rawVal))) {
            Class clazz;
            try {
                clazz = new ClassLoaderUtils(this.getClass(), this.getManagementContext()).loadClass((String)rawVal);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load configured ImageChooser " + rawVal, e);
            }
            Maybe instance = Reflections.invokeConstructorFromArgs((Class)clazz, (Object[])new Object[0]);
            if (!instance.isPresent()) {
                throw new IllegalStateException("Failed to create ImageChooser " + rawVal + " for location " + this);
            }
            if (!(instance.get() instanceof Function)) {
                throw new IllegalStateException("Failed to create ImageChooser " + rawVal + " for location " + this + "; expected type Function but got " + instance.get().getClass());
            }
            chooser = (Function)instance.get();
        } else {
            chooser = (Function)config.get(JcloudsLocationConfig.IMAGE_CHOOSER);
        }
        return BrooklynImageChooser.cloneFor(chooser, computeService, config);
    }

    @Deprecated
    public Template buildTemplate(ComputeService computeService, ConfigBag config, Collection<JcloudsLocationCustomizer> customizers) {
        JcloudsLocationCustomizer customizersDelegate = LocationCustomizerDelegate.newInstance(customizers);
        return this.buildTemplate(computeService, config, customizersDelegate);
    }

    public Template buildTemplate(ComputeService computeService, ConfigBag config, JcloudsLocationCustomizer customizersDelegate) {
        String string;
        Object oldHardwareId;
        PortableTemplateBuilder templateBuilder = (PortableTemplateBuilder)config.get(TEMPLATE_BUILDER);
        if (templateBuilder == null) {
            templateBuilder = new PortableTemplateBuilder();
        } else {
            LOG.debug("jclouds using templateBuilder {} as custom base for provisioning in {} for {}", new Object[]{templateBuilder, this, this.getCreationString(config)});
        }
        if (templateBuilder instanceof PortableTemplateBuilder) {
            if (templateBuilder.imageChooser() == null) {
                Function<Iterable<? extends Image>, Image> chooser = this.getImageChooser(computeService, config);
                templateBuilder.imageChooser(chooser);
            }
        } else {
            LOG.warn("Cannot check imageChooser status for {} due to manually supplied black-box TemplateBuilder; it is recommended to use a PortableTemplateBuilder if you supply a TemplateBuilder", (Object)this.getCreationString(config));
        }
        if (!Strings.isEmpty((CharSequence)((CharSequence)config.get(CLOUD_REGION_ID)))) {
            templateBuilder.locationId((String)config.get(CLOUD_REGION_ID));
        }
        if (Strings.isNonBlank((CharSequence)((CharSequence)config.get(HARDWARE_ID))) && !Objects.equal((Object)(oldHardwareId = (String)config.get(HARDWARE_ID)), (Object)(string = this.transformHardwareId((String)oldHardwareId, config)))) {
            LOG.info("Transforming hardwareId from " + (String)oldHardwareId + " to " + string + ", in " + this.toString());
            config.put(HARDWARE_ID, (Object)string);
        }
        for (Map.Entry entry : SUPPORTED_TEMPLATE_BUILDER_PROPERTIES.entrySet()) {
            ConfigKey key = (ConfigKey)entry.getKey();
            Object val = config.containsKey(key) ? config.get(key) : key.getDefaultValue();
            if (val == null) continue;
            TemplateBuilderCustomizer code = (TemplateBuilderCustomizer)entry.getValue();
            code.apply(templateBuilder, config, val);
        }
        if (templateBuilder instanceof PortableTemplateBuilder) {
            templateBuilder.attachComputeService(computeService);
            if (JavaGroovyEquivalents.groovyTruth((String)((String)config.get(DEFAULT_IMAGE_ID))) && templateBuilder.isBlank()) {
                templateBuilder.imageId(((String)config.get(DEFAULT_IMAGE_ID)).toString());
            }
        }
        customizersDelegate.customize(this, computeService, templateBuilder);
        LOG.debug("jclouds using templateBuilder {} for provisioning in {} for {}", new Object[]{templateBuilder, this, this.getCreationString(config)});
        Template template = null;
        try {
            template = templateBuilder.build();
            if (template == null) {
                throw new IllegalStateException("No matching template; check image and hardware constraints (e.g. OS, RAM); using " + templateBuilder);
            }
            Image image = template.getImage();
            LOG.debug("jclouds found template " + template + " (image " + image + ") for provisioning in " + this + " for " + this.getCreationString(config));
            if (image == null) {
                throw new IllegalStateException("No matching image in template at " + this.toStringNice() + "; check image constraints (OS, providers, ID); using " + templateBuilder);
            }
        }
        catch (AuthorizationException e) {
            LOG.warn("Error resolving template -- not authorized (rethrowing: " + (Object)((Object)e) + "); template is: " + template);
            throw new IllegalStateException("Not authorized to access cloud " + this.toStringNice() + "; check identity, credentials, and endpoint (identity='" + this.getIdentity() + "', credential length " + this.getCredential().length() + ")", e);
        }
        catch (Exception e) {
            try {
                IOException ioe = (IOException)Exceptions.getFirstThrowableOfType((Throwable)e, IOException.class);
                if (ioe != null) {
                    LOG.warn("IOException found...", (Throwable)ioe);
                    throw ioe;
                }
                if (this.listedAvailableTemplatesOnNoSuchTemplate.compareAndSet(false, true)) {
                    LOG.warn("Unable to match required VM template constraints " + templateBuilder + " when trying to provision VM in " + this + " (rethrowing): " + e);
                    this.logAvailableTemplates(config);
                }
            }
            catch (Exception e2) {
                LOG.warn("Error loading available images to report (following original error matching template which will be rethrown): " + e2, (Throwable)e2);
                throw new IllegalStateException("Unable to access cloud " + this + " to resolve " + templateBuilder + ": " + e, e);
            }
            throw new IllegalStateException("Unable to match required VM template constraints " + templateBuilder + " when trying to provision VM in " + this + "; see list of images in log. Root cause: " + e, e);
        }
        TemplateOptions options = template.getOptions();
        boolean windows = this.isWindows(template, config);
        if (windows) {
            String initScript = WinRmMachineLocation.getDefaultUserMetadataString((BrooklynObjectInternal.ConfigurationSupportInternal)this.config());
            String provider = this.getProvider();
            if ("google-compute-engine".equals(provider)) {
                String startupScriptKey = "sysprep-specialize-script-cmd";
                Object metadataMapRaw = config.get(USER_METADATA_MAP);
                if (metadataMapRaw instanceof Map) {
                    Map metadataMap = (Map)metadataMapRaw;
                    if (metadataMap.containsKey(startupScriptKey)) {
                        LOG.warn("Not adding startup-script for Windows VM on " + provider + ", because already has key " + startupScriptKey + " in config " + USER_METADATA_MAP.getName());
                    } else {
                        MutableMap metadataMapReplacement = MutableMap.copyOf((Map)metadataMap);
                        metadataMapReplacement.put(startupScriptKey, initScript);
                        config.put(USER_METADATA_MAP, (Object)metadataMapReplacement);
                        LOG.debug("Adding startup-script to enable WinRM for Windows VM on " + provider);
                    }
                } else if (metadataMapRaw == null) {
                    MutableMap metadataMapReplacement = MutableMap.of((Object)startupScriptKey, (Object)initScript);
                    config.put(USER_METADATA_MAP, (Object)metadataMapReplacement);
                    LOG.debug("Adding startup-script to enable WinRM for Windows VM on " + provider);
                }
            } else {
                boolean userMetadataString = config.containsKey(JcloudsLocationConfig.USER_METADATA_STRING);
                boolean userMetadataMap = config.containsKey(JcloudsLocationConfig.USER_METADATA_MAP);
                if (!userMetadataString && !userMetadataMap) {
                    config.put(JcloudsLocationConfig.USER_METADATA_STRING, (Object)WinRmMachineLocation.getDefaultUserMetadataString((BrooklynObjectInternal.ConfigurationSupportInternal)this.config()));
                    LOG.debug("Adding startup-script to enable WinRM for Windows VM on " + provider);
                } else {
                    LOG.warn("Not adding startup-script for Windows VM on " + provider + ", because already has config " + (userMetadataString ? USER_METADATA_STRING.getName() : USER_METADATA_MAP.getName()));
                }
            }
        }
        for (Map.Entry<ConfigKey<?>, TemplateOptionCustomizer> entry : SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES.entrySet()) {
            ConfigKey<?> key = entry.getKey();
            TemplateOptionCustomizer code = entry.getValue();
            if (!config.containsKey(key) || config.get(key) == null) continue;
            code.apply(options, config, config.get(key));
        }
        return template;
    }

    private String transformHardwareId(String hardwareId, ConfigBag config) {
        Preconditions.checkNotNull((Object)hardwareId, (Object)"hardwareId");
        Preconditions.checkNotNull((Object)config, (Object)"config");
        String provider = this.getProvider();
        String region = this.getRegion();
        if (Strings.isBlank((CharSequence)region)) {
            region = (String)config.get(CLOUD_REGION_ID);
        }
        if (!"google-compute-engine".equals(provider)) {
            return hardwareId;
        }
        if (hardwareId.toLowerCase().startsWith("http") || hardwareId.contains("/")) {
            return hardwareId;
        }
        if (Strings.isNonBlank((CharSequence)region)) {
            return String.format("https://www.googleapis.com/compute/v1/projects/jclouds-gce/zones/%s/machineTypes/%s", region, hardwareId);
        }
        LOG.warn("Cannot transform GCE hardwareId (" + hardwareId + ") to long form, because region unknown in " + this.toString());
        return hardwareId;
    }

    @Override
    public String toStringNice() {
        String s = (String)this.config().get(ORIGINAL_SPEC);
        if (Strings.isBlank((CharSequence)s)) {
            s = (String)this.config().get(NAMED_SPEC_NAME);
        }
        if (Strings.isBlank((CharSequence)s)) {
            s = (String)this.config().get(FINAL_SPEC);
        }
        if (Strings.isBlank((CharSequence)s)) {
            s = this.getDisplayName();
        }
        String s2 = "";
        String provider = this.getProvider();
        if (Strings.isBlank((CharSequence)s) || Strings.isNonBlank((CharSequence)provider) && !s.toLowerCase().contains(provider.toLowerCase())) {
            s2 = s2 + " " + provider;
        }
        String region = this.getRegion();
        if (Strings.isBlank((CharSequence)s) || Strings.isNonBlank((CharSequence)region) && !s.toLowerCase().contains(region.toLowerCase())) {
            s2 = s2 + " " + region;
        }
        String endpoint = this.getEndpoint();
        if (Strings.isBlank((CharSequence)s) || Strings.isNonBlank((CharSequence)endpoint) && !s.toLowerCase().contains(endpoint.toLowerCase())) {
            s2 = s2 + " " + endpoint;
        }
        s2 = s2.trim();
        if (Strings.isNonBlank((CharSequence)s)) {
            if (Strings.isNonBlank((CharSequence)s2)) {
                return s + " (" + s2 + ")";
            }
            return s;
        }
        if (Strings.isNonBlank((CharSequence)s2)) {
            return s2;
        }
        return this.toString();
    }

    protected void logAvailableTemplates(ConfigBag config) {
        LOG.info("Loading available images at " + this + " for reference...");
        ConfigBag m1 = ConfigBag.newInstanceCopying((ConfigBag)config);
        if (m1.containsKey(IMAGE_ID)) {
            m1.remove(IMAGE_ID);
            m1.putStringKey("anyOwner", (Object)true);
        }
        ComputeService computeServiceLessRestrictive = this.getComputeService(m1);
        Set imgs = computeServiceLessRestrictive.listImages();
        LOG.info("" + imgs.size() + " available images at " + this);
        for (Object img : imgs) {
            LOG.info(" Image: " + img);
        }
        Set profiles = computeServiceLessRestrictive.listHardwareProfiles();
        LOG.info("" + profiles.size() + " available profiles at " + this);
        for (Hardware profile : profiles) {
            LOG.info(" Profile: " + profile);
        }
        Set assignableLocations = computeServiceLessRestrictive.listAssignableLocations();
        LOG.info("" + assignableLocations.size() + " available locations at " + this);
        for (Location assignableLocation : assignableLocations) {
            LOG.info(" Location: " + assignableLocation);
        }
    }

    protected SshMachineLocation createTemporarySshMachineLocation(HostAndPort hostAndPort, LoginCredentials creds, ConfigBag config) {
        String initialUser = creds.getUser();
        Optional initialPassword = creds.getOptionalPassword();
        Optional initialPrivateKey = creds.getOptionalPrivateKey();
        LinkedHashMap sshProps = Maps.newLinkedHashMap((Map)config.getAllConfig());
        sshProps.put("user", initialUser);
        sshProps.put("address", hostAndPort.getHostText());
        sshProps.put("port", hostAndPort.getPort());
        sshProps.put(AbstractLocation.TEMPORARY_LOCATION.getName(), true);
        sshProps.put(LocalLocationManager.CREATE_UNMANAGED.getName(), true);
        sshProps.remove("id");
        sshProps.remove("password");
        sshProps.remove("privateKeyData");
        sshProps.remove("privateKeyFile");
        sshProps.remove("privateKeyPassphrase");
        if (initialPassword.isPresent()) {
            sshProps.put("password", initialPassword.get());
        }
        if (initialPrivateKey.isPresent()) {
            sshProps.put("privateKeyData", initialPrivateKey.get());
        }
        if (this.isManaged()) {
            return (SshMachineLocation)this.getManagementContext().getLocationManager().createLocation((Map)sshProps, SshMachineLocation.class);
        }
        return new SshMachineLocation((Map)sshProps);
    }

    protected WinRmMachineLocation createTemporaryWinRmMachineLocation(HostAndPort hostAndPort, LoginCredentials creds, ConfigBag config) {
        String initialUser = creds.getUser();
        Optional initialPassword = creds.getOptionalPassword();
        Optional initialPrivateKey = creds.getOptionalPrivateKey();
        LinkedHashMap winrmProps = Maps.newLinkedHashMap((Map)config.getAllConfig());
        winrmProps.put("user", initialUser);
        winrmProps.put("address", hostAndPort.getHostText());
        winrmProps.put("port", hostAndPort.getPort());
        winrmProps.put(AbstractLocation.TEMPORARY_LOCATION.getName(), true);
        winrmProps.put(LocalLocationManager.CREATE_UNMANAGED.getName(), true);
        winrmProps.remove("password");
        winrmProps.remove("privateKeyData");
        winrmProps.remove("privateKeyFile");
        winrmProps.remove("privateKeyPassphrase");
        String winrmClass = (String)this.config().get(WinRmMachineLocation.WINRM_TOOL_CLASS);
        if (Strings.isNonBlank((CharSequence)winrmClass)) {
            winrmProps.put(WinRmMachineLocation.WINRM_TOOL_CLASS.getName(), winrmClass);
        }
        if (initialPassword.isPresent()) {
            winrmProps.put("password", initialPassword.get());
        }
        if (initialPrivateKey.isPresent()) {
            winrmProps.put("privateKeyData", initialPrivateKey.get());
        }
        if (this.isManaged()) {
            return (WinRmMachineLocation)this.getManagementContext().getLocationManager().createLocation((Map)winrmProps, WinRmMachineLocation.class);
        }
        throw new UnsupportedOperationException("Cannot create temporary WinRmMachineLocation because " + this + " is not managed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoginCredentials createUser(ComputeService computeService, NodeMetadata node, HostAndPort managementHostAndPort, LoginCredentials initialCredentials, ConfigBag config) {
        Image image = node.getImageId() != null ? computeService.getImage(node.getImageId()) : null;
        UserCreation userCreation = this.createUserStatements(image, config);
        if (!userCreation.statements().isEmpty()) {
            OsFamily scriptOsFamily = this.isWindows(node, config) ? OsFamily.WINDOWS : OsFamily.UNIX;
            boolean windows = this.isWindows(node, config);
            if (windows) {
                LOG.warn("Unable to execute statements on WinRM in JcloudsLocation; skipping for " + node + ": " + userCreation.statements());
            } else {
                ArrayList commands = Lists.newArrayList();
                for (Statement statement : userCreation.statements()) {
                    InitAdminAccess initAdminAccess = new InitAdminAccess((AdminAccess.Configuration)new AdminAccessConfiguration.Default());
                    initAdminAccess.visit(statement);
                    commands.add(statement.render(scriptOsFamily));
                }
                String initialUser = initialCredentials.getUser();
                boolean authSudo = initialCredentials.shouldAuthenticateSudo();
                Optional password = initialCredentials.getOptionalPassword();
                MutableMap execProps = MutableMap.builder().put((Object)ShellTool.PROP_RUN_AS_ROOT.getName(), (Object)true).put((Object)SshTool.PROP_AUTH_SUDO.getName(), (Object)authSudo).put((Object)SshTool.PROP_ALLOCATE_PTY.getName(), (Object)true).putIfNotNull((Object)SshTool.PROP_PASSWORD.getName(), authSudo ? password.orNull() : null).put((Object)SshTool.PROP_SSH_TRIES.getName(), (Object)50).put((Object)SshTool.PROP_SSH_TRIES_TIMEOUT.getName(), (Object)600000).build();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("VM {}: executing user creation/setup via {}@{}; commands: {}", new Object[]{this.getCreationString(config), initialUser, managementHostAndPort, commands});
                }
                SshMachineLocation sshLoc = this.createTemporarySshMachineLocation(managementHostAndPort, initialCredentials, config);
                try {
                    ImmutableMap env = ImmutableMap.of((Object)"PATH", (Object)BashCommands.sbinPath());
                    int exitcode = sshLoc.execScript((Map)execProps, "create-user", (List)commands, (Map)env);
                    if (exitcode != 0) {
                        LOG.warn("exit code {} when creating user for {}; usage may subsequently fail", (Object)exitcode, (Object)node);
                    }
                }
                finally {
                    if (this.getManagementContext().getLocationManager().isManaged((org.apache.brooklyn.api.location.Location)sshLoc)) {
                        this.getManagementContext().getLocationManager().unmanage((org.apache.brooklyn.api.location.Location)sshLoc);
                    }
                    Streams.closeQuietly((Closeable)sshLoc);
                }
            }
        }
        return userCreation.credentials();
    }

    protected LoginCredentials initTemplateForCreateUser(Template template, ConfigBag config) {
        UserCreation userCreation = this.createUserStatements(template.getImage(), config);
        if (!userCreation.statements().isEmpty()) {
            TemplateOptions options = template.getOptions();
            options.runScript((Statement)new StatementList(userCreation.statements()));
        }
        return userCreation.credentials();
    }

    @Deprecated
    protected UserCreation createUserStatements(@Nullable Image image, ConfigBag config) {
        CreateUserStatements userStatements = CreateUserStatements.get(this, image, config);
        return new UserCreation(userStatements.credentials(), userStatements.statements());
    }

    protected JcloudsMachineLocation registerMachine(NodeMetadata metadata) throws NoMachinesAvailableException {
        return this.registerMachine((Map<?, ?>)MutableMap.of(), metadata);
    }

    protected JcloudsMachineLocation registerMachine(Map<?, ?> flags, NodeMetadata metadata) throws NoMachinesAvailableException {
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), flags);
        if (!setup.containsKey("id")) {
            setup.putStringKey("id", (Object)metadata.getId());
        }
        this.setHostnameUpdatingCredentials(setup, metadata);
        return this.registerMachine(setup);
    }

    public JcloudsMachineLocation registerMachine(ConfigBag flags) throws NoMachinesAvailableException {
        ConfigBag setup = ConfigBag.newInstanceExtending((ConfigBag)this.config().getBag(), (Map)flags.getAllConfig());
        NodeMetadata node = this.findNodeOrThrow(setup);
        return this.registerMachineLocation(setup, node);
    }

    protected JcloudsMachineLocation registerMachineLocation(ConfigBag setup, NodeMetadata node) {
        ComputeService computeService = this.getComputeService(setup);
        boolean windows = this.isWindows(node, setup);
        ConnectivityResolverOptions options = this.getConnectivityOptionsBuilder(setup, windows).initialCredentials(node.getCredentials()).userCredentials(node.getCredentials()).defaultLoginPort(node.getLoginPort()).isRebinding(true).build();
        HostAndPort managementHostAndPort = this.getLocationNetworkInfoCustomizer(setup).resolve(this, node, setup, options).hostAndPort();
        if (managementHostAndPort == null) {
            throw new IllegalStateException("Could not resolve management host and port for " + node + " given options: " + options);
        }
        if (windows) {
            return this.registerWinRmMachineLocation(computeService, node, (Optional<Template>)Optional.absent(), node.getCredentials(), managementHostAndPort, setup);
        }
        try {
            return this.registerJcloudsSshMachineLocation(computeService, node, (Optional<Template>)Optional.absent(), node.getCredentials(), managementHostAndPort, setup);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected NodeMetadata findNodeOrThrow(ConfigBag config) {
        String user = (String)Preconditions.checkNotNull((Object)this.getUser(config), (Object)"user");
        String rawId = (String)config.getStringKey("id");
        String rawHostname = (String)config.getStringKey("hostname");
        Predicate<ComputeMetadata> predicate = this.getRebindToMachinePredicate(config);
        LOG.debug("Finding VM {} ({}@{}), in jclouds location for provider {} matching {}", new Object[]{rawId != null ? rawId : "<lookup>", user, rawHostname != null ? rawHostname : "<unspecified>", this.getProvider(), predicate});
        ComputeService computeService = this.getComputeService(config);
        Set candidateNodes = computeService.listNodesDetailsMatching(predicate);
        if (candidateNodes.isEmpty()) {
            throw new IllegalArgumentException("Jclouds node not found for rebind with predicate " + predicate);
        }
        if (candidateNodes.size() > 1) {
            throw new IllegalArgumentException("Jclouds node for rebind matched multiple with " + predicate + ": " + candidateNodes);
        }
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)candidateNodes);
        LocationConfigUtils.OsCredential osCredentials = LocationConfigUtils.getOsCredential((ConfigBag)config).checkNoErrors().logAnyWarnings();
        String pkd = osCredentials.getPrivateKeyData();
        String password = osCredentials.getPassword();
        LoginCredentials expectedCredentials = node.getCredentials();
        if (Strings.isNonBlank((CharSequence)pkd)) {
            expectedCredentials = LoginCredentials.fromCredentials((Credentials)new Credentials(user, pkd));
        } else if (Strings.isNonBlank((CharSequence)password)) {
            expectedCredentials = LoginCredentials.fromCredentials((Credentials)new Credentials(user, password));
        } else if (expectedCredentials == null) {
            expectedCredentials = LoginCredentials.fromCredentials((Credentials)new Credentials(user, null));
        }
        node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).credentials(expectedCredentials).build();
        return node;
    }

    public JcloudsMachineLocation registerMachine(Map<?, ?> flags) throws NoMachinesAvailableException {
        return this.registerMachine(ConfigBag.newInstance(flags));
    }

    protected Predicate<ComputeMetadata> getRebindToMachinePredicate(ConfigBag config) {
        return new RebindToMachinePredicate(config);
    }

    protected JcloudsSshMachineLocation registerJcloudsSshMachineLocation(ComputeService computeService, NodeMetadata node, Optional<Template> template, LoginCredentials credentials, HostAndPort managementHostAndPort, ConfigBag setup) throws IOException {
        JcloudsSshMachineLocation machine = this.createJcloudsSshMachineLocation(computeService, node, template, credentials, managementHostAndPort, setup);
        this.registerJcloudsMachineLocation(node.getId(), machine);
        return machine;
    }

    @VisibleForTesting
    protected void registerJcloudsMachineLocation(String nodeId, JcloudsMachineLocation machine) {
        machine.setParent((org.apache.brooklyn.api.location.Location)this);
        this.vmInstanceIds.put(machine, nodeId);
    }

    protected JcloudsSshMachineLocation createJcloudsSshMachineLocation(ComputeService computeService, NodeMetadata node, Optional<Template> template, LoginCredentials userCredentials, HostAndPort managementHostAndPort, ConfigBag setup) throws IOException {
        Object privateKeyData;
        Collection<JcloudsLocationCustomizer> customizers = this.getCustomizers(setup);
        Collection<MachineLocationCustomizer> machineCustomizers = this.getMachineCustomizers(setup);
        Map<String, Object> sshConfig = this.extractSshConfig(setup, node);
        String nodeAvailabilityZone = this.extractAvailabilityZone(setup, node);
        String nodeRegion = this.extractRegion(setup, node);
        if (nodeRegion == null) {
            nodeRegion = this.extractProvider(setup, node);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating JcloudsSshMachineLocation representation for {}@{} ({}) for {}/{}", new Object[]{this.getUser(setup), managementHostAndPort, Sanitizer.sanitize(sshConfig), this.getCreationString(setup), node});
        }
        String address = managementHostAndPort.getHostText();
        int port = managementHostAndPort.hasPort() ? managementHostAndPort.getPort() : node.getLoginPort();
        String displayName = this.getPublicHostnameGeneric(node, setup, (Optional<String>)Optional.of((Object)address));
        Object password = sshConfig.get(SshMachineLocation.PASSWORD.getName()) != null ? sshConfig.get(SshMachineLocation.PASSWORD.getName()) : userCredentials.getOptionalPassword().orNull();
        Object object = privateKeyData = sshConfig.get(SshMachineLocation.PRIVATE_KEY_DATA.getName()) != null ? sshConfig.get(SshMachineLocation.PRIVATE_KEY_DATA.getName()) : userCredentials.getOptionalPrivateKey().orNull();
        if (this.isManaged()) {
            LocationSpec spec = (LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(JcloudsSshMachineLocation.class).configure(sshConfig)).configure((CharSequence)"displayName", (Object)displayName)).configure((CharSequence)"address", (Object)address)).configure(JcloudsSshMachineLocation.SSH_PORT, (Object)port)).configure((CharSequence)"user", (Object)userCredentials.getUser())).configure((CharSequence)SshMachineLocation.PASSWORD.getName(), password)).configure((CharSequence)SshMachineLocation.PRIVATE_KEY_DATA.getName(), privateKeyData)).configure((CharSequence)"jcloudsParent", (Object)this)).configure((CharSequence)"node", (Object)node)).configure((CharSequence)"template", template.orNull())).configureIfNotNull(CLOUD_AVAILABILITY_ZONE_ID, (Object)nodeAvailabilityZone)).configureIfNotNull(CLOUD_REGION_ID, (Object)nodeRegion)).configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT))).configure(SshMachineLocation.DETECT_MACHINE_DETAILS, setup.get(SshMachineLocation.DETECT_MACHINE_DETAILS))).configureIfNotNull(SshMachineLocation.SCRIPT_DIR, setup.get(SshMachineLocation.SCRIPT_DIR))).configureIfNotNull(USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING))).configureIfNotNull(PORT_FORWARDER, setup.get(PORT_FORWARDER))).configureIfNotNull(PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER))).configureIfNotNull(SshMachineLocation.PRIVATE_ADDRESSES, (Object)node.getPrivateAddresses())).configureIfNotNull(JCLOUDS_LOCATION_CUSTOMIZERS, customizers.size() > 0 ? customizers : null)).configureIfNotNull(MACHINE_LOCATION_CUSTOMIZERS, machineCustomizers.size() > 0 ? machineCustomizers : null);
            return (JcloudsSshMachineLocation)this.getManagementContext().getLocationManager().createLocation(spec);
        }
        LOG.warn("Using deprecated JcloudsSshMachineLocation constructor because " + this + " is not managed");
        MutableMap.Builder builder = MutableMap.builder().putAll(sshConfig).put((Object)"displayName", (Object)displayName).put((Object)"address", (Object)address).put((Object)"port", (Object)port).put((Object)"user", (Object)userCredentials.getUser()).putIfNotNull((Object)SshMachineLocation.PASSWORD.getName(), password).putIfNotNull((Object)SshMachineLocation.PRIVATE_KEY_DATA.getName(), privateKeyData).put((Object)"callerContext", setup.get(CALLER_CONTEXT)).putIfNotNull((Object)CLOUD_AVAILABILITY_ZONE_ID.getName(), (Object)nodeAvailabilityZone).putIfNotNull((Object)CLOUD_REGION_ID.getName(), (Object)nodeRegion).put((Object)USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING)).put((Object)PORT_FORWARDER, setup.get(PORT_FORWARDER)).put((Object)PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER)).put((Object)SshMachineLocation.PRIVATE_ADDRESSES, (Object)node.getPrivateAddresses());
        if (customizers.size() > 0) {
            builder.put((Object)JCLOUDS_LOCATION_CUSTOMIZERS, customizers);
        }
        if (machineCustomizers.size() > 0) {
            builder.put((Object)MACHINE_LOCATION_CUSTOMIZERS, machineCustomizers);
        }
        MutableMap properties = builder.build();
        return new JcloudsSshMachineLocation((Map<?, ?>)properties, this, node);
    }

    protected JcloudsWinRmMachineLocation registerWinRmMachineLocation(ComputeService computeService, NodeMetadata node, Optional<Template> template, LoginCredentials credentials, HostAndPort managementHostAndPort, ConfigBag setup) {
        JcloudsWinRmMachineLocation machine = this.createWinRmMachineLocation(computeService, node, template, credentials, managementHostAndPort, setup);
        this.registerJcloudsMachineLocation(node.getId(), machine);
        return machine;
    }

    protected JcloudsWinRmMachineLocation createWinRmMachineLocation(ComputeService computeService, NodeMetadata node, Optional<Template> template, LoginCredentials userCredentials, HostAndPort winrmHostAndPort, ConfigBag setup) {
        Object password;
        Collection<JcloudsLocationCustomizer> customizers = this.getCustomizers(setup);
        Collection<MachineLocationCustomizer> machineCustomizers = this.getMachineCustomizers(setup);
        Map<String, Object> winrmConfig = this.extractWinrmConfig(setup, node);
        String nodeAvailabilityZone = this.extractAvailabilityZone(setup, node);
        String nodeRegion = this.extractRegion(setup, node);
        if (nodeRegion == null) {
            nodeRegion = this.extractProvider(setup, node);
        }
        String address = winrmHostAndPort.getHostText();
        String displayName = this.getPublicHostnameGeneric(node, setup, (Optional<String>)Optional.of((Object)address));
        Object object = password = winrmConfig.get(WinRmMachineLocation.PASSWORD.getName()) != null ? winrmConfig.get(WinRmMachineLocation.PASSWORD.getName()) : userCredentials.getOptionalPassword().orNull();
        if (this.isManaged()) {
            LocationSpec spec = (LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(JcloudsWinRmMachineLocation.class).configure(winrmConfig)).configure((CharSequence)"jcloudsParent", (Object)this)).configure((CharSequence)"displayName", (Object)displayName)).configure((CharSequence)"address", (Object)address)).configure(WinRmMachineLocation.WINRM_CONFIG_PORT, (Object)winrmHostAndPort.getPort())).configure((CharSequence)WinRmMachineLocation.USER.getName(), (Object)userCredentials.getUser())).configure((CharSequence)WinRmMachineLocation.PASSWORD.getName(), password)).configure((CharSequence)"node", (Object)node)).configureIfNotNull(CLOUD_AVAILABILITY_ZONE_ID, (Object)nodeAvailabilityZone)).configureIfNotNull(CLOUD_REGION_ID, (Object)nodeRegion)).configure(CALLER_CONTEXT, setup.get(CALLER_CONTEXT))).configure(SshMachineLocation.DETECT_MACHINE_DETAILS, setup.get(SshMachineLocation.DETECT_MACHINE_DETAILS))).configureIfNotNull(SshMachineLocation.SCRIPT_DIR, setup.get(SshMachineLocation.SCRIPT_DIR))).configureIfNotNull(USE_PORT_FORWARDING, setup.get(USE_PORT_FORWARDING))).configureIfNotNull(PORT_FORWARDER, setup.get(PORT_FORWARDER))).configureIfNotNull(PORT_FORWARDING_MANAGER, setup.get(PORT_FORWARDING_MANAGER))).configureIfNotNull(JCLOUDS_LOCATION_CUSTOMIZERS, customizers.size() > 0 ? customizers : null)).configureIfNotNull(MACHINE_LOCATION_CUSTOMIZERS, machineCustomizers.size() > 0 ? machineCustomizers : null);
            return (JcloudsWinRmMachineLocation)this.getManagementContext().getLocationManager().createLocation(spec);
        }
        throw new UnsupportedOperationException("Cannot create WinRmMachineLocation because " + this + " is not managed");
    }

    protected Map<String, Object> extractSshConfig(ConfigBag setup, NodeMetadata node) {
        ConfigBag nodeConfig = new ConfigBag();
        if (node != null && node.getCredentials() != null) {
            nodeConfig.putIfNotNull(PASSWORD, node.getCredentials().getOptionalPassword().orNull());
            nodeConfig.putIfNotNull(PRIVATE_KEY_DATA, node.getCredentials().getOptionalPrivateKey().orNull());
        }
        return this.extractSshConfig(setup, nodeConfig).getAllConfig();
    }

    protected Map<String, Object> extractWinrmConfig(ConfigBag setup, NodeMetadata node) {
        ConfigBag nodeConfig = new ConfigBag();
        if (node != null && node.getCredentials() != null) {
            nodeConfig.putIfNotNull(PASSWORD, node.getCredentials().getOptionalPassword().orNull());
            nodeConfig.putIfNotNull(PRIVATE_KEY_DATA, node.getCredentials().getOptionalPrivateKey().orNull());
        }
        return this.extractWinrmConfig(setup, nodeConfig).getAllConfig();
    }

    protected ConfigBag extractWinrmConfig(ConfigBag setup, ConfigBag alt) {
        ConfigBag winrmConfig = new ConfigBag();
        for (ConfigKey.HasConfigKey key : WinRmMachineLocation.ALL_WINRM_CONFIG_KEYS) {
            String keyName = key.getConfigKey().getName();
            if (setup.containsKey(keyName)) {
                winrmConfig.putStringKey(keyName, setup.getStringKey(keyName));
                continue;
            }
            if (!alt.containsKey(keyName)) continue;
            winrmConfig.putStringKey(keyName, setup.getStringKey(keyName));
        }
        Map winrmToolClassProperties = Maps.filterKeys((Map)setup.getAllConfig(), (Predicate)StringPredicates.startsWith((String)WinRmMachineLocation.WINRM_TOOL_CLASS_PROPERTIES_PREFIX));
        winrmConfig.putAll(winrmToolClassProperties);
        return winrmConfig;
    }

    protected String extractAvailabilityZone(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.ZONE);
    }

    protected String extractRegion(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.REGION);
    }

    protected String extractProvider(ConfigBag setup, NodeMetadata node) {
        return this.extractNodeLocationId(setup, node, LocationScope.PROVIDER);
    }

    protected String extractNodeLocationId(ConfigBag setup, NodeMetadata node, LocationScope scope) {
        Location nodeLoc = node.getLocation();
        if (nodeLoc == null) {
            return null;
        }
        do {
            if (nodeLoc.getScope() != scope) continue;
            return nodeLoc.getId();
        } while ((nodeLoc = nodeLoc.getParent()) != null);
        return null;
    }

    public void release(MachineLocation rawMachine) {
        Exception tothrow;
        block14: {
            JcloudsLocationCustomizer customizersDelegate;
            JcloudsMachineLocation machine;
            String instanceId;
            block13: {
                block12: {
                    block11: {
                        instanceId = this.vmInstanceIds.remove(rawMachine);
                        if (instanceId == null) {
                            LOG.info("Attempted release of unknown machine " + rawMachine + " in " + this.toString());
                            throw new IllegalArgumentException("Unknown machine " + rawMachine);
                        }
                        machine = (JcloudsMachineLocation)rawMachine;
                        LOG.info("Releasing machine {} in {}, instance id {}", new Object[]{machine, this, instanceId});
                        tothrow = null;
                        ConfigBag setup = ((LocationInternal)machine).config().getBag();
                        customizersDelegate = LocationCustomizerDelegate.newInstance(this.getManagementContext(), setup);
                        try {
                            customizersDelegate.preRelease(machine);
                        }
                        catch (Exception e) {
                            LOG.error("Problem invoking pre-release for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                            if (tothrow != null) break block11;
                            tothrow = e;
                        }
                    }
                    try {
                        if (machine instanceof JcloudsMachineLocation) {
                            this.releasePortForwarding(machine);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Problem releasing port-forwarding for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                        if (tothrow != null) break block12;
                        tothrow = e;
                    }
                }
                try {
                    this.releaseNode(instanceId);
                }
                catch (Exception e) {
                    LOG.error("Problem releasing machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                    if (tothrow != null) break block13;
                    tothrow = e;
                }
            }
            this.removeChild((org.apache.brooklyn.api.location.Location)machine);
            try {
                customizersDelegate.postRelease(machine);
            }
            catch (Exception e) {
                LOG.error("Problem invoking post-release for machine " + machine + " in " + this + ", instance id " + instanceId + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) break block14;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    protected void releaseSafely(MachineLocation machine) {
        try {
            this.release(machine);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void releaseNodeSafely(NodeMetadata node) {
        String instanceId = node.getId();
        LOG.info("Releasing node {} in {}, instance id {}", new Object[]{node, this, instanceId});
        try {
            this.releaseNode(instanceId);
        }
        catch (Exception e) {
            LOG.warn("Problem releasing node " + node + " in " + this + ", instance id " + instanceId + "; discarding instance and continuing...", (Throwable)e);
        }
    }

    protected void releaseNode(String instanceId) {
        ComputeService computeService = this.getComputeService(this.config().getBag());
        Set destroyed = computeService.destroyNodesMatching(NodePredicates.withIds((String[])new String[]{instanceId}));
        LOG.debug("Destroyed nodes %s%n", (Object)destroyed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releasePortForwarding(final JcloudsMachineLocation machine) {
        boolean usePortForwarding = Boolean.TRUE.equals(machine.getConfig(USE_PORT_FORWARDING));
        final JcloudsPortForwarderExtension portForwarder = (JcloudsPortForwarderExtension)machine.getConfig(PORT_FORWARDER);
        String nodeId = machine.getJcloudsId();
        LinkedHashMap subtasks = Maps.newLinkedHashMap();
        PortForwardManager portForwardManager = (PortForwardManager)machine.getConfig(PORT_FORWARDING_MANAGER);
        if (portForwardManager == null) {
            LOG.debug("No PortForwardManager, using default");
            portForwardManager = (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
        }
        if (portForwarder == null) {
            LOG.debug("No port-forwarding to close (because portForwarder null) on release of " + machine);
        } else {
            final Optional<NodeMetadata> node = machine.getOptionalNode();
            if (usePortForwarding && node.isPresent()) {
                HostAndPort hostAndPortOverride;
                if (machine instanceof SshMachineLocation) {
                    hostAndPortOverride = ((SshMachineLocation)machine).getSshHostAndPort();
                } else if (machine instanceof WinRmMachineLocation) {
                    String host = ((WinRmMachineLocation)machine).getAddress().getHostAddress();
                    int port = ((WinRmMachineLocation)machine).getPort();
                    hostAndPortOverride = HostAndPort.fromParts((String)host, (int)port);
                } else {
                    LOG.warn("Unexpected machine {} of type {}; expected SSH or WinRM", (Object)machine, machine != null ? machine.getClass() : null);
                    hostAndPortOverride = null;
                }
                if (hostAndPortOverride != null) {
                    final int loginPort = ((NodeMetadata)node.get()).getLoginPort();
                    subtasks.put("Close port-forward " + hostAndPortOverride + "->" + loginPort, new Runnable(){

                        @Override
                        public void run() {
                            LOG.debug("Closing port-forwarding at {} for machine {}: {}->{}", new Object[]{this, machine, hostAndPortOverride, loginPort});
                            portForwarder.closePortForwarding((NodeMetadata)node.get(), loginPort, hostAndPortOverride, Protocol.TCP);
                        }
                    });
                }
            }
            LinkedHashSet mappings = Sets.newLinkedHashSet();
            mappings.addAll(portForwardManager.getLocationPublicIpIds((org.apache.brooklyn.api.location.Location)machine));
            if (nodeId != null) {
                mappings.addAll(portForwardManager.getPortMappingWithPublicIpId(nodeId));
            }
            for (PortMapping mapping : mappings) {
                final HostAndPort publicEndpoint = mapping.getPublicEndpoint();
                final int targetPort = mapping.getPrivatePort();
                final Protocol protocol = Protocol.TCP;
                if (publicEndpoint == null || !node.isPresent()) continue;
                subtasks.put("Close port-forward " + publicEndpoint + "->" + targetPort, new Runnable(){

                    @Override
                    public void run() {
                        LOG.debug("Closing port-forwarding at {} for machine {}: {}->{}", new Object[]{this, machine, publicEndpoint, targetPort});
                        portForwarder.closePortForwarding((NodeMetadata)node.get(), targetPort, publicEndpoint, protocol);
                    }
                });
            }
            if (subtasks.size() > 0) {
                TaskBuilder builder = TaskBuilder.builder().parallel(true).displayName("close port-forwarding at " + machine);
                for (Map.Entry entry : subtasks.entrySet()) {
                    builder.add((TaskAdaptable)TaskBuilder.builder().displayName((String)entry.getKey()).body((Runnable)entry.getValue()).build());
                }
                Task task = builder.build();
                DynamicTasks.TaskQueueingResult queueResult = DynamicTasks.queueIfPossible((TaskAdaptable)task);
                if (queueResult.isQueuedOrSubmitted()) {
                    String origDetails = Tasks.setBlockingDetails((String)("waiting for closing port-forwarding of " + machine));
                    try {
                        task.blockUntilEnded();
                    }
                    finally {
                        Tasks.setBlockingDetails((String)origDetails);
                    }
                } else {
                    LOG.warn("Releasing port-forwarding of " + machine + " not executing in execution-context (e.g. not invoked inside effector); falling back to executing sequentially");
                    for (Runnable subtask : subtasks.values()) {
                        subtask.run();
                    }
                }
            }
        }
        portForwardManager.forgetPortMappings((org.apache.brooklyn.api.location.Location)machine);
        if (nodeId != null) {
            portForwardManager.forgetPortMappings(nodeId);
        }
    }

    protected LoginCredentials extractVmCredentials(ConfigBag setup, NodeMetadata node, LoginCredentials nodeCredentials) {
        boolean windows = this.isWindows(node, setup);
        String user = this.getUser(setup);
        LocationConfigUtils.OsCredential localCredentials = LocationConfigUtils.getOsCredential((ConfigBag)setup).checkNoErrors();
        LOG.debug("Credentials extracted for {}: {}/{} with {}/{}", new Object[]{node, user, nodeCredentials.getUser(), localCredentials, nodeCredentials});
        if (Strings.isNonBlank((CharSequence)nodeCredentials.getUser())) {
            if (Strings.isBlank((CharSequence)user)) {
                user = nodeCredentials.getUser();
                setup.put(USER, (Object)user);
            } else if ("root".equals(user) && ROOT_ALIASES.contains(nodeCredentials.getUser())) {
                LOG.warn("overriding username 'root' in favour of '" + nodeCredentials.getUser() + "' at {}; this behaviour may be removed in future", (Object)node);
                user = nodeCredentials.getUser();
                setup.put(USER, (Object)user);
            }
            String pkd = (String)Strings.maybeNonBlank((CharSequence)localCredentials.getPrivateKeyData()).or(nodeCredentials.getOptionalPrivateKey().orNull());
            String pwd = (String)Strings.maybeNonBlank((CharSequence)localCredentials.getPassword()).or(nodeCredentials.getOptionalPassword().orNull());
            if (Strings.isBlank((CharSequence)user) || Strings.isBlank((CharSequence)pkd) && pwd == null) {
                String missing = user == null ? "user" : "credential";
                LOG.warn("Not able to determine " + missing + " for " + this + " at " + node + "; will likely fail subsequently");
                return null;
            }
            LoginCredentials.Builder resultBuilder = LoginCredentials.builder().user(user);
            if (pwd != null && (Strings.isBlank((CharSequence)pkd) || localCredentials.isUsingPassword() || windows)) {
                resultBuilder.password(pwd);
            } else {
                resultBuilder.privateKey(pkd);
            }
            return resultBuilder.build();
        }
        LOG.warn("No node-credentials or admin-access available for node " + node + " in " + this + "; will likely fail subsequently");
        return null;
    }

    protected String getFirstReachableAddress(NodeMetadata node, ConfigBag setup) {
        String result;
        boolean enabled;
        String pollForFirstReachable = (String)setup.get(POLL_FOR_FIRST_REACHABLE_ADDRESS);
        boolean bl = enabled = !"false".equalsIgnoreCase(pollForFirstReachable);
        if (enabled) {
            Duration timeout = "true".equals(pollForFirstReachable) ? Duration.FIVE_MINUTES : Duration.of((Object)pollForFirstReachable);
            Predicate<? super HostAndPort> predicate = this.getReachableAddressesPredicate(setup);
            LOG.debug("{} polling for first reachable address with {}", (Object)this, predicate);
            result = JcloudsUtil.getFirstReachableAddress(node, timeout, predicate);
            LOG.debug("Using first-reachable address " + result + " for node " + node + " in " + this);
        } else {
            result = (String)Iterables.getFirst((Iterable)Iterables.concat((Iterable)node.getPublicAddresses(), (Iterable)node.getPrivateAddresses()), null);
            if (result == null) {
                throw new IllegalStateException("No addresses available for node " + node + " in " + this);
            }
            LOG.debug("Using first address " + result + " for node " + node + " in " + this);
        }
        return result;
    }

    private Predicate<? super HostAndPort> getReachableAddressesPredicate(ConfigBag config) {
        if (config.get(POLL_FOR_FIRST_REACHABLE_ADDRESS_PREDICATE) != null) {
            return (Predicate)config.get(POLL_FOR_FIRST_REACHABLE_ADDRESS_PREDICATE);
        }
        Class predicateType = (Class)config.get(POLL_FOR_FIRST_REACHABLE_ADDRESS_PREDICATE_TYPE);
        MutableMap args = MutableMap.of();
        ConfigUtils.addUnprefixedConfigKeyInConfigBack((String)(POLL_FOR_FIRST_REACHABLE_ADDRESS_PREDICATE.getName() + "."), (ConfigBag)config, (Map)args);
        try {
            return (Predicate)predicateType.getConstructor(Map.class).newInstance(args);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                Predicate pollForFirstReachableHostAndPortPredicate = (Predicate)predicateType.newInstance();
                return pollForFirstReachableHostAndPortPredicate;
            }
            catch (IllegalAccessException | InstantiationException newInstanceException) {
                throw Exceptions.propagateAnnotated((String)("Failed to instantiate " + predicateType), (Throwable)newInstanceException);
            }
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw Exceptions.propagateAnnotated((String)("Failed to instantiate " + predicateType + " with Map constructor"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoginCredentials waitForWinRmAvailable(LoginCredentials credentialsToTry, HostAndPort managementHostAndPort, final ConfigBag setup) {
        String waitForWinrmAvailable = (String)setup.get(WAIT_FOR_WINRM_AVAILABLE);
        Preconditions.checkArgument((!"false".equalsIgnoreCase(waitForWinrmAvailable) ? 1 : 0) != 0, (String)"waitForWinRmAvailable called despite waitForWinRmAvailable=%s", (Object[])new Object[]{waitForWinrmAvailable});
        Duration timeout = null;
        try {
            timeout = Duration.parse((String)waitForWinrmAvailable);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        if (timeout == null) {
            timeout = Duration.parse((String)((String)WAIT_FOR_WINRM_AVAILABLE.getDefaultValue()));
        }
        String user = credentialsToTry.getUser();
        String connectionDetails = user + "@" + managementHostAndPort;
        final AtomicReference credsSuccessful = new AtomicReference();
        ConfigBag winrmProps = ConfigBag.newInstanceCopying((ConfigBag)setup);
        final Pair machinesToTry = Pair.of((Object)this.createTemporaryWinRmMachineLocation(managementHostAndPort, credentialsToTry, winrmProps), (Object)credentialsToTry);
        try {
            Callable<Boolean> checker = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean success;
                    WinRmMachineLocation machine = (WinRmMachineLocation)machinesToTry.getLeft();
                    WinRmToolResponse response = machine.executeCommand((Map)ImmutableMap.of((Object)WinRmTool.PROP_EXEC_TRIES.getName(), (Object)1), (List)ImmutableList.of((Object)"echo testing"));
                    boolean bl = success = response.getStatusCode() == 0;
                    if (success) {
                        credsSuccessful.set(machinesToTry.getRight());
                        String verifyWindowsUp = (String)setup.get(WinRmMachineLocation.WAIT_WINDOWS_TO_START);
                        if (Strings.isBlank((CharSequence)verifyWindowsUp) || verifyWindowsUp.equals("false")) {
                            return true;
                        }
                        Predicate<WinRmMachineLocation> machineReachable = new Predicate<WinRmMachineLocation>(){

                            public boolean apply(@Nullable WinRmMachineLocation machine) {
                                try {
                                    WinRmToolResponse response = machine.executeCommand("echo testing");
                                    int statusCode = response.getStatusCode();
                                    return statusCode == 0;
                                }
                                catch (RuntimeException e) {
                                    if (Throwables2.getFirstThrowableOfType((Throwable)e, IOException.class) != null || Throwables2.getFirstThrowableOfType((Throwable)e, WebServiceException.class) != null) {
                                        LOG.debug("WinRM Connectivity lost", (Throwable)e);
                                        return false;
                                    }
                                    throw e;
                                }
                            }
                        };
                        Duration verifyWindowsUpTime = Duration.of((Object)verifyWindowsUp);
                        boolean restartHappened = Predicates2.retry((Predicate)Predicates.not((Predicate)machineReachable), (long)verifyWindowsUpTime.toMilliseconds(), (long)Duration.FIVE_SECONDS.toMilliseconds(), (long)Duration.THIRTY_SECONDS.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)machine);
                        if (restartHappened) {
                            LOG.info("Connectivity to the machine was lost. Probably Windows have restarted {} as part of the provisioning process.\nRetrying to connect...", (Object)machine);
                            return Predicates2.retry((Predicate)machineReachable, (long)verifyWindowsUpTime.toMilliseconds(), (long)Duration.of((long)5L, (TimeUnit)TimeUnit.SECONDS).toMilliseconds(), (long)Duration.of((long)30L, (TimeUnit)TimeUnit.SECONDS).toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)machine);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.waitForReachable(checker, connectionDetails, (Iterable<LoginCredentials>)ImmutableList.of((Object)credentialsToTry), setup, timeout);
        }
        finally {
            if (this.getManagementContext().getLocationManager().isManaged((org.apache.brooklyn.api.location.Location)machinesToTry.getLeft())) {
                this.getManagementContext().getLocationManager().unmanage((org.apache.brooklyn.api.location.Location)machinesToTry.getLeft());
            }
        }
        return (LoginCredentials)credsSuccessful.get();
    }

    protected LoginCredentials waitForSshableGuessCredentials(ComputeService computeService, NodeMetadata node, HostAndPort managementHostAndPort, ConfigBag setup) {
        Iterable<LoginCredentials> credentialsToTry = this.generateCredentials(node.getCredentials(), (String)setup.get(LOGIN_USER));
        return this.waitForSshable(computeService, node, managementHostAndPort, credentialsToTry, setup);
    }

    @Deprecated
    protected LoginCredentials waitForSshable(ComputeService computeService, NodeMetadata node, HostAndPort managementHostAndPort, ConfigBag setup) {
        return this.waitForSshableGuessCredentials(computeService, node, managementHostAndPort, setup);
    }

    Iterable<LoginCredentials> generateCredentials(LoginCredentials nodeCreds, @Nullable String loginUserOverride) {
        String nodeUser = nodeCreds.getUser();
        MutableSet users = MutableSet.of();
        if (Strings.isNonBlank((CharSequence)nodeUser)) {
            users.add(nodeUser);
        }
        if (Strings.isNonBlank((CharSequence)loginUserOverride)) {
            users.add(loginUserOverride);
        }
        ArrayList<LoginCredentials> credentialsToTry = new ArrayList<LoginCredentials>();
        for (String user : users) {
            if (nodeCreds.getOptionalPassword().isPresent() && nodeCreds.getOptionalPrivateKey().isPresent()) {
                credentialsToTry.add(LoginCredentials.builder((Credentials)nodeCreds).noPassword().user(user).build());
                credentialsToTry.add(LoginCredentials.builder((Credentials)nodeCreds).noPrivateKey().user(user).build());
                continue;
            }
            credentialsToTry.add(LoginCredentials.builder((Credentials)nodeCreds).user(user).build());
        }
        return credentialsToTry;
    }

    @Deprecated
    protected LoginCredentials waitForSshable(ComputeService computeService, NodeMetadata node, HostAndPort hostAndPort, Iterable<LoginCredentials> credentialsToTry, ConfigBag setup) {
        return this.waitForSshable(hostAndPort, credentialsToTry, setup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoginCredentials waitForSshable(HostAndPort hostAndPort, Iterable<LoginCredentials> credentialsToTry, ConfigBag setup) {
        String waitForSshable = (String)setup.get(WAIT_FOR_SSHABLE);
        Preconditions.checkArgument((!"false".equalsIgnoreCase(waitForSshable) ? 1 : 0) != 0, (String)"waitForSshable called despite waitForSshable=%s for %s", (Object[])new Object[]{waitForSshable, hostAndPort});
        Preconditions.checkArgument((!Iterables.isEmpty(credentialsToTry) ? 1 : 0) != 0, (String)"waitForSshable called without credentials for %s", (Object[])new Object[]{hostAndPort});
        Duration timeout = null;
        try {
            timeout = Duration.parse((String)waitForSshable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (timeout == null) {
            timeout = Duration.parse((String)((String)WAIT_FOR_SSHABLE.getDefaultValue()));
        }
        LinkedHashSet users = Sets.newLinkedHashSet();
        for (LoginCredentials creds : credentialsToTry) {
            users.add(creds.getUser());
        }
        String user = users.size() == 1 ? (String)Iterables.getOnlyElement((Iterable)users) : "{" + Joiner.on((String)",").join((Iterable)users) + "}";
        String connectionDetails = user + "@" + hostAndPort;
        final AtomicReference credsSuccessful = new AtomicReference();
        ConfigBag sshProps = ConfigBag.newInstanceCopying((ConfigBag)setup);
        sshProps.remove("password");
        sshProps.remove("privateKeyData");
        sshProps.remove("privateKeyFile");
        sshProps.remove("privateKeyPassphrase");
        final LinkedHashMap machinesToTry = Maps.newLinkedHashMap();
        for (LoginCredentials creds : credentialsToTry) {
            machinesToTry.put(this.createTemporarySshMachineLocation(hostAndPort, creds, sshProps), creds);
        }
        final Duration repeaterTimeout = timeout;
        try {
            Callable<Boolean> checker = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    for (Map.Entry entry : machinesToTry.entrySet()) {
                        SshMachineLocation machine = (SshMachineLocation)entry.getKey();
                        Duration statusTimeout = Duration.THIRTY_SECONDS.isShorterThan(repeaterTimeout) ? Duration.THIRTY_SECONDS : repeaterTimeout;
                        int exitstatus = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_CONNECT_TIMEOUT.getName(), (Object)statusTimeout.toMilliseconds(), (Object)SshTool.PROP_SESSION_TIMEOUT.getName(), (Object)statusTimeout.toMilliseconds(), (Object)SshTool.PROP_SSH_TRIES_TIMEOUT.getName(), (Object)statusTimeout.toMilliseconds(), (Object)SshTool.PROP_SSH_TRIES.getName(), (Object)1), "check-connectivity", (List)ImmutableList.of((Object)"true"));
                        boolean success = exitstatus == 0;
                        if (!success) continue;
                        credsSuccessful.set(entry.getValue());
                        return true;
                    }
                    return false;
                }
            };
            this.waitForReachable(checker, connectionDetails, credentialsToTry, setup, timeout);
        }
        finally {
            for (SshMachineLocation machine : machinesToTry.keySet()) {
                if (this.getManagementContext().getLocationManager().isManaged((org.apache.brooklyn.api.location.Location)machine)) {
                    this.getManagementContext().getLocationManager().unmanage((org.apache.brooklyn.api.location.Location)machine);
                }
                Streams.closeQuietly((Closeable)machine);
            }
        }
        return (LoginCredentials)credsSuccessful.get();
    }

    @VisibleForTesting
    static int getLoginPortOrDefault(NodeMetadata node, int defaultPort) {
        int loginPort = node.getLoginPort();
        if (loginPort > 0) {
            return loginPort;
        }
        return defaultPort;
    }

    protected void waitForReachable(Callable<Boolean> checker, String hostAndPort, Iterable<LoginCredentials> credentialsToLog, ConfigBag setup, Duration timeout) {
        if (LOG.isDebugEnabled()) {
            ArrayList credsToString = Lists.newArrayList();
            for (LoginCredentials creds : credentialsToLog) {
                String key;
                String password;
                String user = creds.getUser();
                if (Boolean.TRUE.equals(setup.get(LOG_CREDENTIALS))) {
                    password = (String)creds.getOptionalPassword().or((Object)"<absent>");
                    key = (String)creds.getOptionalPrivateKey().or((Object)"<absent>");
                } else {
                    password = creds.getOptionalPassword().isPresent() ? "******" : "<absent>";
                    key = creds.getOptionalPrivateKey().isPresent() ? "******" : "<absent>";
                }
                credsToString.add("user=" + user + ", password=" + password + ", key=" + key);
            }
            LOG.debug("VM {}: reported online, now waiting {} for it to be contactable on {}; trying {} credential{}: {}", new Object[]{this.getCreationString(setup), timeout, hostAndPort, Iterables.size(credentialsToLog), Strings.s((int)Iterables.size(credentialsToLog)), credsToString.size() == 1 ? credsToString.get(0) : "(multiple!):" + Joiner.on((String)"\n\t").join((Iterable)credsToString)});
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ReferenceWithError reachable = new Repeater("reachable repeater ").backoff(Duration.ONE_SECOND, 2.0, Duration.TEN_SECONDS).until(checker).limitTimeTo(timeout).runKeepingError();
        if (!((Boolean)reachable.getWithoutError()).booleanValue()) {
            throw new IllegalStateException("Connection failed for " + hostAndPort + " (" + this.getCreationString(setup) + ") after waiting " + Time.makeTimeStringRounded((Duration)timeout), reachable.getError());
        }
        LOG.debug("VM {}: connection succeeded after {} on {}", new Object[]{this.getCreationString(setup), Time.makeTimeStringRounded((Stopwatch)stopwatch), hostAndPort});
    }

    protected void setHostnameUpdatingCredentials(ConfigBag setup, NodeMetadata metadata) {
        LoginCredentials credentials;
        ArrayList<String> usersTried = new ArrayList<String>();
        String originalUser = this.getUser(setup);
        if (JavaGroovyEquivalents.groovyTruth((String)originalUser)) {
            if (this.setHostname(setup, metadata, false)) {
                return;
            }
            usersTried.add(originalUser);
        }
        if ((credentials = metadata.getCredentials()) != null) {
            if (Strings.isNonBlank((CharSequence)credentials.getUser())) {
                setup.put(USER, (Object)credentials.getUser());
            }
            if (Strings.isNonBlank((CharSequence)((CharSequence)credentials.getOptionalPrivateKey().orNull()))) {
                setup.put(PRIVATE_KEY_DATA, credentials.getOptionalPrivateKey().orNull());
            }
            if (this.setHostname(setup, metadata, false)) {
                if (originalUser != null && !originalUser.equals(this.getUser(setup))) {
                    LOG.warn("Switching to cloud-specified user at " + metadata + " as " + this.getUser(setup) + " (failed to connect using: " + usersTried + ")");
                }
                return;
            }
            usersTried.add(this.getUser(setup));
        }
        for (String u : COMMON_USER_NAMES_TO_TRY) {
            setup.put(USER, (Object)u);
            if (this.setHostname(setup, metadata, false)) {
                LOG.warn("Auto-detected user at " + metadata + " as " + this.getUser(setup) + " (failed to connect using: " + usersTried + ")");
                return;
            }
            usersTried.add(this.getUser(setup));
        }
        LOG.warn("Failed to log in to " + metadata + ", tried as users " + usersTried + " (throwing original exception)");
        setup.put(USER, (Object)originalUser);
        this.setHostname(setup, metadata, true);
    }

    protected boolean setHostname(ConfigBag setup, NodeMetadata metadata, boolean rethrow) {
        try {
            setup.put(SshTool.PROP_HOST, (Object)this.getPublicHostname(metadata, (Optional<HostAndPort>)Optional.absent(), setup));
            return true;
        }
        catch (Exception e) {
            if (rethrow) {
                LOG.warn("couldn't connect to " + metadata + " when trying to discover hostname (rethrowing): " + e);
                throw Exceptions.propagate((Throwable)e);
            }
            return false;
        }
    }

    protected String getPublicHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) {
        return this.getPublicHostname(node, sshHostAndPort, node.getCredentials(), setup);
    }

    protected String getPublicHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, LoginCredentials userCredentials, ConfigBag setup) {
        return this.getPublicHostname(node, sshHostAndPort, (Supplier<? extends LoginCredentials>)Suppliers.ofInstance((Object)userCredentials), setup);
    }

    protected String getPublicHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, Supplier<? extends LoginCredentials> userCredentials, ConfigBag setup) {
        Maybe<String> result;
        Boolean lookupAwsHostname;
        String provider = setup != null ? (String)setup.get(CLOUD_PROVIDER) : null;
        Boolean bl = lookupAwsHostname = setup != null ? (Boolean)setup.get(LOOKUP_AWS_HOSTNAME) : null;
        if (provider == null) {
            provider = this.getProvider();
        }
        if ("aws-ec2".equals(provider) && Boolean.TRUE.equals(lookupAwsHostname) && (result = this.getHostnameAws(node, sshHostAndPort, userCredentials, setup)).isPresent()) {
            return (String)result.get();
        }
        Optional preferredAddress = sshHostAndPort.isPresent() ? Optional.of((Object)((HostAndPort)sshHostAndPort.get()).getHostText()) : Optional.absent();
        return this.getPublicHostnameGeneric(node, setup, (Optional<String>)preferredAddress);
    }

    protected String getPrivateHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, ConfigBag setup) {
        return this.getPrivateHostname(node, sshHostAndPort, node.getCredentials(), setup);
    }

    protected String getPrivateHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, LoginCredentials userCredentials, ConfigBag setup) {
        return this.getPrivateHostname(node, sshHostAndPort, (Supplier<? extends LoginCredentials>)Suppliers.ofInstance((Object)userCredentials), setup);
    }

    protected String getPrivateHostname(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, Supplier<? extends LoginCredentials> userCredentials, ConfigBag setup) {
        Maybe<String> result;
        Boolean lookupAwsHostname;
        Boolean useMachinePublicAddressAsPrivateAddress;
        Boolean bl = useMachinePublicAddressAsPrivateAddress = setup != null ? (Boolean)setup.get(USE_MACHINE_PUBLIC_ADDRESS_AS_PRIVATE_ADDRESS) : Boolean.valueOf(false);
        if (useMachinePublicAddressAsPrivateAddress.booleanValue()) {
            LOG.debug("Overriding private hostname as public hostname because config " + USE_MACHINE_PUBLIC_ADDRESS_AS_PRIVATE_ADDRESS.getName() + " is set to true");
            return this.getPublicHostname(node, sshHostAndPort, userCredentials, setup);
        }
        String provider = setup != null ? (String)setup.get(CLOUD_PROVIDER) : null;
        Boolean bl2 = lookupAwsHostname = setup != null ? (Boolean)setup.get(LOOKUP_AWS_HOSTNAME) : null;
        if (provider == null) {
            provider = this.getProvider();
        }
        if ("aws-ec2".equals(provider) && Boolean.TRUE.equals(lookupAwsHostname) && (result = this.getHostnameAws(node, sshHostAndPort, userCredentials, setup)).isPresent()) {
            return (String)result.get();
        }
        Optional preferredAddress = sshHostAndPort.isPresent() ? Optional.of((Object)((HostAndPort)sshHostAndPort.get()).getHostText()) : Optional.absent();
        return this.getPrivateHostnameGeneric(node, setup, (Optional<String>)preferredAddress);
    }

    private String getPublicHostnameGeneric(NodeMetadata node, @Nullable ConfigBag setup) {
        return this.getPublicHostnameGeneric(node, setup, (Optional<String>)Optional.absent());
    }

    private String getPublicHostnameGeneric(NodeMetadata node, @Nullable ConfigBag setup, Optional<String> preferredAddress) {
        if (JavaGroovyEquivalents.groovyTruth((Collection)node.getPublicAddresses())) {
            if (preferredAddress.isPresent() && node.getPublicAddresses().contains(preferredAddress.get())) {
                return (String)preferredAddress.get();
            }
            return (String)node.getPublicAddresses().iterator().next();
        }
        if (JavaGroovyEquivalents.groovyTruth((Collection)node.getPrivateAddresses())) {
            if (preferredAddress.isPresent() && node.getPrivateAddresses().contains(preferredAddress.get())) {
                return (String)preferredAddress.get();
            }
            return (String)node.getPrivateAddresses().iterator().next();
        }
        return null;
    }

    private String getPrivateHostnameGeneric(NodeMetadata node, @Nullable ConfigBag setup, Optional<String> preferredAddress) {
        Iterable privateAddresses = Iterables.filter((Iterable)node.getPrivateAddresses(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && !Networking.isLocalOnly((String)input);
            }
        });
        if (!Iterables.isEmpty((Iterable)privateAddresses)) {
            if (preferredAddress.isPresent() && Iterables.contains((Iterable)privateAddresses, (Object)preferredAddress.get())) {
                return (String)preferredAddress.get();
            }
            return (String)Iterables.get((Iterable)privateAddresses, (int)0);
        }
        if (JavaGroovyEquivalents.groovyTruth((Collection)node.getPublicAddresses())) {
            if (preferredAddress.isPresent() && node.getPublicAddresses().contains(preferredAddress.get())) {
                return (String)preferredAddress.get();
            }
            return (String)node.getPublicAddresses().iterator().next();
        }
        if (JavaGroovyEquivalents.groovyTruth((String)node.getHostname())) {
            return node.getHostname();
        }
        return null;
    }

    Maybe<String> getHostnameAws(NodeMetadata node, Optional<HostAndPort> sshHostAndPort, Supplier<? extends LoginCredentials> userCredentials, ConfigBag setup) {
        boolean waitForSshable;
        HostAndPort inferredHostAndPort = null;
        boolean bl = waitForSshable = !"false".equalsIgnoreCase((String)setup.get(WAIT_FOR_SSHABLE));
        if (!waitForSshable) {
            return Maybe.absent();
        }
        if (!sshHostAndPort.isPresent()) {
            try {
                String vmIp = this.getFirstReachableAddress(node, setup);
                int port = node.getLoginPort();
                inferredHostAndPort = HostAndPort.fromParts((String)vmIp, (int)port);
            }
            catch (Exception e) {
                LOG.warn("Error reaching aws-ec2 instance " + node.getId() + "@" + node.getLocation() + " on port " + node.getLoginPort() + "; falling back to jclouds metadata for address", (Throwable)e);
            }
        }
        if (sshHostAndPort.isPresent() || inferredHostAndPort != null) {
            if (this.isWindows(node, setup)) {
                LOG.warn("Cannot query aws-ec2 Windows instance " + node.getId() + "@" + node.getLocation() + " over ssh for its hostname; falling back to jclouds metadata for address");
            } else {
                HostAndPort hostAndPortToUse = sshHostAndPort.isPresent() ? (HostAndPort)sshHostAndPort.get() : inferredHostAndPort;
                try {
                    return Maybe.of((Object)this.getHostnameAws(hostAndPortToUse, (LoginCredentials)userCredentials.get(), setup));
                }
                catch (Exception e) {
                    LOG.warn("Error querying aws-ec2 instance " + node.getId() + "@" + node.getLocation() + " over ssh for its hostname; falling back to jclouds metadata for address", (Throwable)e);
                }
            }
        }
        return Maybe.absent();
    }

    String getHostnameAws(HostAndPort hostAndPort, LoginCredentials userCredentials, ConfigBag setup) {
        SshMachineLocation sshLocByIp = this.createTemporarySshMachineLocation(hostAndPort, userCredentials, setup);
        try {
            String[] outLines;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errStream = new ByteArrayOutputStream();
            int exitcode = sshLocByIp.execCommands((Map)MutableMap.of((Object)"out", (Object)outStream, (Object)"err", (Object)errStream), "get public AWS hostname", (List)ImmutableList.of((Object)BashCommands.INSTALL_CURL, (Object)"echo `curl --silent --retry 20 http://169.254.169.254/latest/meta-data/public-hostname`; exit"));
            String outString = new String(outStream.toByteArray());
            for (String line : outLines = outString.split("\n")) {
                if (!line.startsWith("ec2-")) continue;
                String string = line.trim();
                return string;
            }
            throw new IllegalStateException("Could not obtain aws-ec2 hostname for vm " + hostAndPort + "; exitcode=" + exitcode + "; stdout=" + outString + "; stderr=" + new String(errStream.toByteArray()));
        }
        finally {
            if (this.getManagementContext().getLocationManager().isManaged((org.apache.brooklyn.api.location.Location)sshLocByIp)) {
                this.getManagementContext().getLocationManager().unmanage((org.apache.brooklyn.api.location.Location)sshLocByIp);
            }
            Streams.closeQuietly((Closeable)sshLocByIp);
        }
    }

    public PersistenceObjectStore newPersistenceObjectStore(String container) {
        return new JcloudsBlobStoreBasedObjectStore(this, container);
    }

    @Deprecated
    public static File asFile(Object o) {
        if (o instanceof File) {
            return (File)o;
        }
        if (o == null) {
            return null;
        }
        return new File(o.toString());
    }

    @Deprecated
    public static String fileAsString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof File) {
            return ((File)o).getAbsolutePath();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Deprecated
    protected static double toDouble(Object v) {
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        throw new IllegalArgumentException("Invalid type for double: " + v + " of type " + v.getClass());
    }

    @Deprecated
    protected static String[] toStringArray(Object v) {
        return Strings.toStringList((Object)v).toArray(new String[0]);
    }

    @Deprecated
    protected static List<String> toListOfStrings(Object v) {
        return Strings.toStringList((Object)v);
    }

    @Deprecated
    protected static byte[] toByteArray(Object v) {
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        if (v instanceof CharSequence) {
            return v.toString().getBytes();
        }
        throw new IllegalArgumentException("Invalid type for byte[]: " + v + " of type " + v.getClass());
    }

    @Deprecated
    @VisibleForTesting
    static int[] toIntPortArray(Object v) {
        PortRange portRange = PortRanges.fromIterable(Collections.singletonList(v));
        return ArrayUtils.toPrimitive((Integer[])((Integer[])Iterables.toArray((Iterable)portRange, Integer.class)));
    }

    @Deprecated
    protected static Map<String, String> toMapStringString(Object v) {
        if (v instanceof Map) {
            LinkedHashMap result = Maps.newLinkedHashMap();
            for (Map.Entry entry : ((Map)v).entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                result.put(key, value);
            }
            return result;
        }
        if (v instanceof CharSequence) {
            return KeyValueParser.parseMap((String)v.toString());
        }
        throw new IllegalArgumentException("Invalid type for Map<String,String>: " + v + (v != null ? " of type " + v.getClass() : ""));
    }

    private <T> Maybe<?> shallowMerge(Maybe<? extends T> val1, Maybe<? extends T> val2, ConfigKey<?> keyForLogging) {
        if (val2.isAbsent() || val2.isNull()) {
            return val1;
        }
        if (val1.isAbsent()) {
            return val2;
        }
        if (val1.isNull()) {
            return val1;
        }
        if (val1.get() instanceof Map && val2.get() instanceof Map) {
            return Maybe.of((Object)CollectionMerger.builder().deep(false).build().merge((Map)val1.get(), (Map)val2.get()));
        }
        LOG.debug("Cannot merge values for " + keyForLogging.getName() + ", because values are not maps: " + val1.get().getClass() + ", and " + val2.get().getClass());
        return val1;
    }

    static {
        Networking.init();
        SUPPORTED_TEMPLATE_BUILDER_PROPERTIES = ImmutableMap.builder().put((Object)HARDWARE_ID, (Object)TemplateBuilderCustomizers.hardwareId()).put((Object)IMAGE_DESCRIPTION_REGEX, (Object)TemplateBuilderCustomizers.imageDescription()).put((Object)IMAGE_ID, (Object)TemplateBuilderCustomizers.imageId()).put((Object)IMAGE_NAME_REGEX, (Object)TemplateBuilderCustomizers.imageNameRegex()).put((Object)MIN_CORES, (Object)TemplateBuilderCustomizers.minCores()).put((Object)MIN_DISK, (Object)TemplateBuilderCustomizers.minDisk()).put((Object)MIN_RAM, (Object)TemplateBuilderCustomizers.minRam()).put((Object)OS_64_BIT, (Object)TemplateBuilderCustomizers.os64Bit()).put((Object)OS_FAMILY, (Object)TemplateBuilderCustomizers.osFamily()).put((Object)OS_VERSION_REGEX, (Object)TemplateBuilderCustomizers.osVersionRegex()).put((Object)TEMPLATE_SPEC, (Object)TemplateBuilderCustomizers.templateSpec()).put((Object)DEFAULT_IMAGE_ID, (Object)TemplateBuilderCustomizers.noOp()).put((Object)TEMPLATE_BUILDER, (Object)TemplateBuilderCustomizers.noOp()).build();
        SUPPORTED_TEMPLATE_OPTIONS_PROPERTIES = ImmutableMap.builder().put((Object)AUTO_ASSIGN_FLOATING_IP, (Object)TemplateOptionCustomizers.autoAssignFloatingIp()).put((Object)AUTO_CREATE_FLOATING_IPS, (Object)TemplateOptionCustomizers.autoCreateFloatingIps()).put((Object)AUTO_GENERATE_KEYPAIRS, (Object)TemplateOptionCustomizers.autoGenerateKeypairs()).put((Object)DOMAIN_NAME, (Object)TemplateOptionCustomizers.domainName()).put((Object)EXTRA_PUBLIC_KEY_DATA_TO_AUTH, (Object)TemplateOptionCustomizers.extraPublicKeyDataToAuth()).put((Object)INBOUND_PORTS, (Object)TemplateOptionCustomizers.inboundPorts()).put((Object)KEY_PAIR, (Object)TemplateOptionCustomizers.keyPair()).put((Object)LOGIN_USER, (Object)TemplateOptionCustomizers.loginUser()).put((Object)LOGIN_USER_PASSWORD, (Object)TemplateOptionCustomizers.loginUserPassword()).put((Object)LOGIN_USER_PRIVATE_KEY_DATA, (Object)TemplateOptionCustomizers.loginUserPrivateKeyData()).put((Object)LOGIN_USER_PRIVATE_KEY_FILE, (Object)TemplateOptionCustomizers.loginUserPrivateKeyFile()).put((Object)NETWORK_NAME, (Object)TemplateOptionCustomizers.networkName()).put((Object)RUN_AS_ROOT, (Object)TemplateOptionCustomizers.runAsRoot()).put((Object)SECURITY_GROUPS, (Object)TemplateOptionCustomizers.securityGroups()).put((Object)STRING_TAGS, (Object)TemplateOptionCustomizers.stringTags()).put((Object)TEMPLATE_OPTIONS, (Object)TemplateOptionCustomizers.templateOptions()).put((Object)USER_DATA_UUENCODED, (Object)TemplateOptionCustomizers.userDataUuencoded()).put((Object)USER_METADATA_MAP, (Object)TemplateOptionCustomizers.userMetadataMap()).put((Object)USER_METADATA_STRING, (Object)TemplateOptionCustomizers.userMetadataString()).build();
    }

    @Deprecated
    protected static class UserCreation
    extends CreateUserStatements {
        public final LoginCredentials createdUserCredentials = super.credentials();
        public final List<Statement> statements = super.statements();

        public UserCreation(LoginCredentials creds, List<Statement> statements) {
            super(creds, statements);
        }
    }

    @Deprecated
    public static interface CustomizeTemplateOptions
    extends TemplateOptionCustomizer {
    }
}

