/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.config.DigitalOcean2ComputeServiceContextModule;
import org.jclouds.digitalocean2.config.DigitalOcean2HttpApiModule;
import org.jclouds.digitalocean2.config.DigitalOceanParserModule;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.oauth.v2.config.OAuthModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class DigitalOcean2ApiMetadata
extends BaseHttpApiMetadata<DigitalOcean2Api> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public DigitalOcean2ApiMetadata() {
        this(new Builder());
    }

    protected DigitalOcean2ApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.put("oauth.endpoint", "https://cloud.digitalocean.com/v1/oauth/token");
        properties.put("jclouds.oauth.jws-alg", "RS256");
        properties.put("jclouds.oauth.audience", "https://cloud.digitalocean.com/v1/oauth/token");
        properties.put("jclouds.oauth.credential-type", CredentialType.BEARER_TOKEN_CREDENTIALS.toString());
        properties.put("jclouds.session-interval", (Object)3600);
        properties.put("jclouds.template", "osFamily=UBUNTU,os64Bit=true,osVersionMatches=14.*");
        properties.put("jclouds.compute.poll-status.initial-period", (Object)5000);
        properties.put("jclouds.compute.poll-status.max-period", (Object)20000);
        properties.put("jclouds.compute.timeout.node-running", (Object)300000);
        properties.put("jclouds.compute.timeout.node-suspended", (Object)300000);
        properties.put("jclouds.compute.timeout.node-terminated", (Object)300000);
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<DigitalOcean2Api, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("digitalocean2")).name("Digital Ocean v2 API")).identityName("Not used for OAuth")).credentialName("Must be oauth2 Bearer Token")).documentation(URI.create("https://developers.digitalocean.com/v2/"))).defaultEndpoint("https://api.digitalocean.com/v2")).defaultProperties(DigitalOcean2ApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.builder().add(DigitalOcean2HttpApiModule.class).add(OAuthModule.class).add(DigitalOceanParserModule.class).add(DigitalOcean2ComputeServiceContextModule.class).build());
        }

        public DigitalOcean2ApiMetadata build() {
            return new DigitalOcean2ApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

