/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.ApplicationApi;
import org.apache.brooklyn.rest.api.CatalogApi;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.api.EntityConfigApi;
import org.apache.brooklyn.rest.domain.EnricherConfigSummary;
import org.apache.brooklyn.rest.domain.EntityConfigSummary;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.PolicyConfigSummary;
import org.apache.brooklyn.rest.transform.SensorTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;

public class EntityTransformer {
    public static final Function<? super Entity, EntitySummary> fromEntity(final UriBuilder ub) {
        return new Function<Entity, EntitySummary>(){

            public EntitySummary apply(Entity entity) {
                return EntityTransformer.entitySummary(entity, ub);
            }
        };
    }

    public static EntitySummary entitySummary(Entity entity, UriBuilder ub) {
        URI applicationUri = WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{entity.getApplicationId()});
        URI entityUri = WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId()});
        ImmutableMap.Builder lb = ImmutableMap.builder().put((Object)"self", (Object)entityUri);
        if (entity.getParent() != null) {
            URI parentUri = WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getParent().getId()});
            lb.put((Object)"parent", (Object)parentUri);
        }
        lb.put((Object)"application", (Object)applicationUri).put((Object)"children", (Object)URI.create(entityUri + "/children")).put((Object)"config", (Object)URI.create(entityUri + "/config")).put((Object)"sensors", (Object)URI.create(entityUri + "/sensors")).put((Object)"effectors", (Object)URI.create(entityUri + "/effectors")).put((Object)"policies", (Object)URI.create(entityUri + "/policies")).put((Object)"activities", (Object)URI.create(entityUri + "/activities")).put((Object)"locations", (Object)URI.create(entityUri + "/locations")).put((Object)"tags", (Object)URI.create(entityUri + "/tags")).put((Object)"expunge", (Object)URI.create(entityUri + "/expunge")).put((Object)"rename", (Object)URI.create(entityUri + "/name")).put((Object)"spec", (Object)URI.create(entityUri + "/spec"));
        if (RegisteredTypes.getIconUrl((BrooklynObject)entity) != null) {
            lb.put((Object)"iconUrl", (Object)URI.create(entityUri + "/icon"));
        }
        if (entity.getCatalogItemId() != null) {
            String versionedId = entity.getCatalogItemId();
            String symbolicName = CatalogUtils.getSymbolicNameFromVersionedId((String)versionedId);
            String version = CatalogUtils.getVersionFromVersionedId((String)versionedId);
            URI catalogUri = WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getEntity").build(new Object[]{symbolicName, version});
            lb.put((Object)"catalog", (Object)catalogUri);
        }
        String type = entity.getEntityType().getName();
        return new EntitySummary(entity.getId(), entity.getDisplayName(), type, entity.getCatalogItemId(), (Map)lb.build());
    }

    public static List<EntitySummary> entitySummaries(Iterable<? extends Entity> entities, final UriBuilder ub) {
        return Lists.newArrayList((Iterable)Iterables.transform(entities, (Function)new Function<Entity, EntitySummary>(){

            public EntitySummary apply(Entity entity) {
                return EntityTransformer.entitySummary(entity, ub);
            }
        }));
    }

    public static EntityConfigSummary entityConfigSummary(ConfigKey<?> config, String label, Double priority, Boolean pinned, Map<String, URI> links) {
        ImmutableMap mapOfLinks = links == null ? null : ImmutableMap.copyOf(links);
        return new EntityConfigSummary(config, label, priority, pinned, (Map)mapOfLinks);
    }

    public static PolicyConfigSummary policyConfigSummary(ConfigKey<?> config, String label, Double priority, Map<String, URI> links) {
        return new PolicyConfigSummary(config, label, priority, links);
    }

    public static EnricherConfigSummary enricherConfigSummary(ConfigKey<?> config, String label, Double priority, Map<String, URI> links) {
        return new EnricherConfigSummary(config, label, priority, links);
    }

    public static EntityConfigSummary entityConfigSummary(Entity entity, ConfigKey<?> config, UriBuilder ub) {
        String label = null;
        Double priority = null;
        URI applicationUri = WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{entity.getApplicationId()});
        URI entityUri = WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId()});
        URI selfUri = WebResourceUtils.serviceUriBuilder(ub, EntityConfigApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId(), config.getName()});
        MutableMap.Builder lb = MutableMap.builder().put((Object)"self", (Object)selfUri).put((Object)"application", (Object)applicationUri).put((Object)"entity", (Object)entityUri).put((Object)"action:json", (Object)selfUri);
        Iterable hints = Iterables.filter((Iterable)RendererHints.getHintsFor(config), RendererHints.NamedAction.class);
        for (RendererHints.NamedAction na : hints) {
            SensorTransformer.addNamedAction((MutableMap.Builder<String, URI>)lb, na, entity.getConfig(config), config, entity);
        }
        return EntityTransformer.entityConfigSummary(config, label, priority, null, (Map<String, URI>)lb.build());
    }

    public static URI applicationUri(Application entity, UriBuilder ub) {
        return WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{entity.getApplicationId()});
    }

    public static URI entityUri(Entity entity, UriBuilder ub) {
        return WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId()});
    }

    public static EntityConfigSummary entityConfigSummary(ConfigKey<?> config, Field configKeyField) {
        CatalogConfig catalogConfig = configKeyField != null ? configKeyField.getAnnotation(CatalogConfig.class) : null;
        String label = catalogConfig == null ? null : catalogConfig.label();
        Double priority = catalogConfig == null ? null : Double.valueOf(catalogConfig.priority());
        boolean pinned = catalogConfig != null && catalogConfig.pinned();
        return EntityTransformer.entityConfigSummary(config, label, priority, pinned, null);
    }

    public static EntityConfigSummary entityConfigSummary(SpecParameter<?> input, AtomicInteger paramPriorityCnt) {
        Double priority = input.isPinned() ? Double.valueOf(paramPriorityCnt.incrementAndGet()) : null;
        return EntityTransformer.entityConfigSummary(input.getConfigKey(), input.getLabel(), priority, input.isPinned(), null);
    }

    public static PolicyConfigSummary policyConfigSummary(SpecParameter<?> input) {
        Double priority = input.isPinned() ? Double.valueOf(1.0) : null;
        return EntityTransformer.policyConfigSummary(input.getConfigKey(), input.getLabel(), priority, null);
    }

    public static EnricherConfigSummary enricherConfigSummary(SpecParameter<?> input) {
        Double priority = input.isPinned() ? Double.valueOf(1.0) : null;
        return EntityTransformer.enricherConfigSummary(input.getConfigKey(), input.getLabel(), priority, null);
    }
}

