/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.DefaultExceptionMapper;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;

public abstract class AbstractBrooklynRestResource {
    @Context
    protected UriInfo ui;
    @Context
    private ContextResolver<ManagementContext> mgmt;
    private BrooklynRestResourceUtils brooklynRestResourceUtils;
    private ObjectMapper mapper;

    public ManagementContext mgmt() {
        return (ManagementContext)Preconditions.checkNotNull((Object)this.mgmt.getContext(ManagementContext.class), (Object)"mgmt");
    }

    public ManagementContextInternal mgmtInternal() {
        return (ManagementContextInternal)this.mgmt();
    }

    protected synchronized Maybe<ManagementContext> mgmtMaybe() {
        return Maybe.of((Object)this.mgmt());
    }

    @VisibleForTesting
    public void setManagementContext(ManagementContext managementContext) {
        this.mgmt = new ManagementContextProvider(managementContext);
    }

    public synchronized BrooklynRestResourceUtils brooklyn() {
        if (this.brooklynRestResourceUtils != null) {
            return this.brooklynRestResourceUtils;
        }
        this.brooklynRestResourceUtils = new BrooklynRestResourceUtils(this.mgmt());
        return this.brooklynRestResourceUtils;
    }

    protected Response badRequest(Exception e) {
        DefaultExceptionMapper.logExceptionDetailsForDebugging(e);
        return ApiError.of((Throwable)e).asBadRequestResponseJson();
    }

    protected ObjectMapper mapper() {
        return this.mapper(this.mgmt());
    }

    protected ObjectMapper mapper(ManagementContext mgmt) {
        if (this.mapper == null) {
            this.mapper = BrooklynJacksonJsonProvider.findAnyObjectMapper(mgmt);
        }
        return this.mapper;
    }

    @Deprecated
    protected Object getValueForDisplay(Object value, boolean preferJson, boolean isJerseyReturnValue) {
        return this.resolving(value).preferJson(preferJson).asJerseyOutermostReturnValue(isJerseyReturnValue).resolve();
    }

    protected RestValueResolver resolving(Object v) {
        return this.resolving(v, this.mgmt());
    }

    protected RestValueResolver resolving(Object v, ManagementContext mgmt) {
        return new RestValueResolver(v).mapper(this.mapper(mgmt));
    }

    public static class RestValueResolver {
        private final Object valueToResolve;
        @Nullable
        private ObjectMapper mapper;
        private boolean preferJson;
        private boolean isJerseyReturnValue;
        @Nullable
        private Boolean raw;
        @Nullable
        private Entity entity;
        @Nullable
        private Duration timeout;
        @Nullable
        private Object rendererHintSource;
        @Nullable
        private Boolean immediately;
        private static Object UNRESOLVED = "UNRESOLVED".toCharArray();

        public static RestValueResolver resolving(Object v) {
            return new RestValueResolver(v);
        }

        private RestValueResolver(Object v) {
            this.valueToResolve = v;
        }

        public RestValueResolver mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public RestValueResolver preferJson(boolean preferJson) {
            this.preferJson = preferJson;
            return this;
        }

        public RestValueResolver asJerseyOutermostReturnValue(boolean asJerseyReturnJson) {
            this.isJerseyReturnValue = asJerseyReturnJson;
            return this;
        }

        public RestValueResolver raw(Boolean raw) {
            this.raw = raw;
            return this;
        }

        public RestValueResolver context(Entity entity) {
            this.entity = entity;
            return this;
        }

        public RestValueResolver timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public RestValueResolver immediately(boolean immediately) {
            this.immediately = immediately;
            return this;
        }

        public RestValueResolver renderAs(Object rendererHintSource) {
            this.rendererHintSource = rendererHintSource;
            return this;
        }

        public Object resolve() {
            Object valueResult = RestValueResolver.getImmediateValue(this.valueToResolve, this.entity, this.immediately, this.timeout);
            if (valueResult == UNRESOLVED) {
                valueResult = this.valueToResolve;
            }
            if (this.rendererHintSource != null && Boolean.FALSE.equals(this.raw)) {
                valueResult = RendererHints.applyDisplayValueHintUnchecked((Object)this.rendererHintSource, (Object)valueResult);
            }
            return WebResourceUtils.getValueForDisplay(this.mapper, valueResult, this.preferJson, this.isJerseyReturnValue);
        }

        private static Object getImmediateValue(Object value, @Nullable Entity context, @Nullable Boolean immediately, @Nullable Duration timeout) {
            return Tasks.resolving((Object)value).as(Object.class).defaultValue(UNRESOLVED).timeout(timeout).immediately(immediately == null ? false : immediately).context(context).swallowExceptions().get();
        }
    }
}

