/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.WebEntitlementContext;
import org.apache.brooklyn.rest.filter.RequestTaggingRsFilter;

@Provider
@Priority(value=400)
public class EntitlementContextFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private HttpServletRequest request;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal user = securityContext.getUserPrincipal();
        if (user != null) {
            String uri = this.request.getRequestURI();
            String remoteAddr = this.request.getRemoteAddr();
            String uid = RequestTaggingRsFilter.getTag();
            WebEntitlementContext entitlementContext = new WebEntitlementContext(user.getName(), remoteAddr, uri, uid);
            Entitlements.setEntitlementContext((EntitlementContext)entitlementContext);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Entitlements.clearEntitlementContext();
    }
}

