/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.collections.EnumerationUtils;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=400)
public class CsrfTokenFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(CsrfTokenFilter.class);
    private static final String CSRF_TOKEN_VALUE_BASE = "Csrf-Token";
    public static final String CSRF_TOKEN_VALUE_COOKIE = "Csrf-Token".toUpperCase();
    public static final String CSRF_TOKEN_VALUE_HEADER = CsrfTokenFilter.HEADER_OF_COOKIE("Csrf-Token");
    public static final String CSRF_TOKEN_VALUE_BASE_ANGULAR_NAME = "Xsrf-Token";
    public static final String CSRF_TOKEN_VALUE_COOKIE_ANGULAR_NAME = "Xsrf-Token".toUpperCase();
    public static final String CSRF_TOKEN_VALUE_HEADER_ANGULAR_NAME = CsrfTokenFilter.HEADER_OF_COOKIE("Xsrf-Token");
    public static final String CSRF_TOKEN_VALUE_ATTR = CsrfTokenFilter.class.getName() + "." + CSRF_TOKEN_VALUE_COOKIE;
    public static final String CSRF_TOKEN_REQUIRED_HEADER = "X-Csrf-Token-Required-For-Requests";
    public static final String CSRF_TOKEN_REQUIRED_ATTR = CsrfTokenFilter.class.getName() + "." + "X-Csrf-Token-Required-For-Requests";
    public static CsrfTokenRequiredForRequests DEFAULT_REQUIRED_FOR_REQUESTS = CsrfTokenRequiredForRequests.WRITE;
    @Context
    private HttpServletRequest request;

    public static String HEADER_OF_COOKIE(String cookieName) {
        return "X-" + cookieName;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean isRequired;
        String requiredWhenS = this.request.getHeader(CSRF_TOKEN_REQUIRED_HEADER);
        if (Strings.isNonBlank((CharSequence)requiredWhenS) && this.getRequiredForRequests(requiredWhenS, null) == null) {
            this.fail(requestContext, ApiError.builder().errorCode(Response.Status.BAD_REQUEST).message(CsrfTokenFilter.HEADER_OF_COOKIE(CSRF_TOKEN_REQUIRED_HEADER) + " header if supplied must be one of " + Arrays.asList(CsrfTokenRequiredForRequests.values())).build());
            return;
        }
        if (!this.request.isRequestedSessionIdValid()) {
            return;
        }
        List suppliedTokensDefault = EnumerationUtils.toList((Enumeration)this.request.getHeaders(CSRF_TOKEN_VALUE_HEADER));
        List suppliedTokensAngular = EnumerationUtils.toList((Enumeration)this.request.getHeaders(CSRF_TOKEN_VALUE_HEADER_ANGULAR_NAME));
        ArrayList suppliedTokens = Lists.newArrayList((Iterable)suppliedTokensDefault);
        suppliedTokens.addAll(suppliedTokensAngular);
        Object requiredToken = this.request.getSession().getAttribute(CSRF_TOKEN_VALUE_ATTR);
        CsrfTokenRequiredForRequests whenRequired = (CsrfTokenRequiredForRequests)((Object)this.request.getSession().getAttribute(CSRF_TOKEN_REQUIRED_ATTR));
        if (whenRequired == null) {
            if (suppliedTokens.isEmpty()) {
                log.warn("No CSRF token expected or supplied but a cookie-session is active: client should be updated (in future CSRF tokens or instructions may be required for session-based clients) - " + Entitlements.getEntitlementContext());
                whenRequired = CsrfTokenRequiredForRequests.NONE;
            } else {
                whenRequired = DEFAULT_REQUIRED_FOR_REQUESTS;
            }
            this.request.getSession().setAttribute(CSRF_TOKEN_REQUIRED_ATTR, (Object)whenRequired);
        }
        switch (whenRequired) {
            case NONE: {
                isRequired = false;
                break;
            }
            case WRITE: {
                isRequired = !HttpMethod.GET.toString().equals(requestContext.getMethod());
                break;
            }
            case ALL: {
                isRequired = true;
                break;
            }
            default: {
                log.warn("Unexpected " + CSRF_TOKEN_REQUIRED_ATTR + " value " + (Object)((Object)whenRequired));
                isRequired = true;
            }
        }
        if (Iterables.any((Iterable)suppliedTokens, (Predicate)Predicates.equalTo((Object)requiredToken))) {
            return;
        }
        if (!isRequired) {
            if (requiredToken != null) {
                log.trace("CSRF optional token mismatch: client did not send valid token, but it isn't required so proceeding");
            }
            return;
        }
        if (suppliedTokens.isEmpty()) {
            this.fail(requestContext, ApiError.builder().errorCode(Response.Status.UNAUTHORIZED).message(CsrfTokenFilter.HEADER_OF_COOKIE(CSRF_TOKEN_VALUE_COOKIE) + " header is required, containing token previously returned from server in cookie").build());
        } else {
            this.fail(requestContext, ApiError.builder().errorCode(Response.Status.UNAUTHORIZED).message(CsrfTokenFilter.HEADER_OF_COOKIE(CSRF_TOKEN_VALUE_COOKIE) + " header did not match expected CSRF token").build());
        }
    }

    private void fail(ContainerRequestContext requestContext, ApiError apiError) {
        requestContext.abortWith(apiError.asJsonResponse());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        CsrfTokenRequiredForRequests requiredWhen;
        HttpSession session = this.request.getSession(false);
        String token = (String)(session == null ? null : session.getAttribute(CSRF_TOKEN_VALUE_ATTR));
        String requiredWhenS = this.request.getHeader(CSRF_TOKEN_REQUIRED_HEADER);
        if (session == null) {
            if (Strings.isBlank((CharSequence)requiredWhenS)) {
                return;
            }
            session = this.request.getSession();
        }
        if (Strings.isNonBlank((CharSequence)requiredWhenS)) {
            requiredWhen = this.getRequiredForRequests(requiredWhenS, DEFAULT_REQUIRED_FOR_REQUESTS);
            this.request.getSession().setAttribute(CSRF_TOKEN_REQUIRED_ATTR, (Object)requiredWhen);
            if (Strings.isNonBlank((CharSequence)token)) {
                return;
            }
        } else {
            if (Strings.isNonBlank((CharSequence)token)) {
                return;
            }
            requiredWhen = (CsrfTokenRequiredForRequests)((Object)this.request.getSession().getAttribute(CSRF_TOKEN_REQUIRED_ATTR));
            if (requiredWhen == null) {
                requiredWhen = DEFAULT_REQUIRED_FOR_REQUESTS;
                this.request.getSession().setAttribute(CSRF_TOKEN_REQUIRED_ATTR, (Object)requiredWhen);
            }
        }
        if (requiredWhen == CsrfTokenRequiredForRequests.NONE) {
            return;
        }
        token = Identifiers.makeRandomId((int)16);
        this.request.getSession().setAttribute(CSRF_TOKEN_VALUE_ATTR, (Object)token);
        this.addCookie(responseContext, CSRF_TOKEN_VALUE_COOKIE, token, "Clients should send this value in header " + CSRF_TOKEN_VALUE_HEADER + " for validation");
        this.addCookie(responseContext, CSRF_TOKEN_VALUE_COOKIE_ANGULAR_NAME, token, "Compatibility cookie for " + CSRF_TOKEN_VALUE_COOKIE + " following AngularJS conventions");
    }

    protected NewCookie addCookie(ContainerResponseContext responseContext, String cookieName, String token, String comment) {
        NewCookie cookie = new NewCookie(cookieName, token, "/", null, comment, -1, false);
        responseContext.getHeaders().add((Object)"Set-Cookie", (Object)cookie);
        return cookie;
    }

    protected CsrfTokenRequiredForRequests getRequiredForRequests(String requiredWhenS, CsrfTokenRequiredForRequests defaultMode) {
        CsrfTokenRequiredForRequests result = null;
        if (requiredWhenS != null) {
            result = CsrfTokenRequiredForRequests.valueOf(requiredWhenS.toUpperCase());
        }
        if (result != null) {
            return result;
        }
        return defaultMode;
    }

    public static enum CsrfTokenRequiredForRequests {
        ALL,
        WRITE,
        NONE;

    }
}

