/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistry;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistryImpl;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.util.time.Duration;

public interface KubernetesLocationConfig
extends CloudLocationConfig {
    public static final ConfigKey<String> MASTER_URL = LocationConfigKeys.CLOUD_ENDPOINT;
    public static final ConfigKey<String> KUBECONFIG = ConfigKeys.builder(String.class).name("kubeconfig").description("Kubernetes .kubeconfig file to use for Location configuration keys").constraint(file -> Files.isReadable(Paths.get(file, new String[0]))).build();
    public static final ConfigKey<String> KUBECONFIG_CONTEXT = ConfigKeys.builder(String.class).name("kubeconfig.context").description("Kubernetes .kubeconfig context to use for Location configuration").build();
    public static final ConfigKey<String> CA_CERT_DATA = ConfigKeys.builder(String.class).name("caCertData").description("Data for CA certificate").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CA_CERT_FILE = ConfigKeys.builder(String.class).name("caCertFile").description("URL of resource containing CA certificate data").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_CERT_DATA = ConfigKeys.builder(String.class).name("clientCertData").description("Data for client certificate").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_CERT_FILE = ConfigKeys.builder(String.class).name("clientCertFile").description("URL of resource containing client certificate data").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_KEY_DATA = ConfigKeys.builder(String.class).name("clientKeyData").description("Data for client key").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_KEY_FILE = ConfigKeys.builder(String.class).name("clientKeyFile").description("URL of resource containing client key data").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_KEY_ALGO = ConfigKeys.builder(String.class).name("clientKeyAlgo").description("Algorithm used for the client key").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> CLIENT_KEY_PASSPHRASE = ConfigKeys.builder(String.class).name("clientKeyPassphrase").description("Passphrase used for the client key").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> OAUTH_TOKEN = ConfigKeys.builder(String.class).name("oauthToken").description("The OAuth token data for the current user").constraint(Predicates.notNull()).build();
    public static final ConfigKey<Duration> CLIENT_TIMEOUT = ConfigKeys.builder(Duration.class).name("timeout").description("The timeout for the client").defaultValue((Object)Duration.seconds((Number)10)).constraint(Predicates.notNull()).build();
    public static final ConfigKey<Duration> ACTION_TIMEOUT = ConfigKeys.builder(Duration.class).name("actionTimeout").description("The timeout for Kubernetes actions").defaultValue((Object)Duration.ONE_MINUTE).constraint(Predicates.notNull()).build();
    public static final ConfigKey<Boolean> CREATE_NAMESPACE = ConfigKeys.builder(Boolean.class).name("namespace.create").description("Whether to create the namespace if it does not exist").defaultValue((Object)true).constraint(Predicates.notNull()).build();
    public static final ConfigKey<Boolean> DELETE_EMPTY_NAMESPACE = ConfigKeys.builder(Boolean.class).name("namespace.deleteEmpty").description("Whether to delete an empty namespace when releasing resources").defaultValue((Object)false).constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> NAMESPACE = ConfigKeys.builder(String.class).name("namespace").description("Namespace where resources will live; the default is 'brooklyn'").defaultValue((Object)"brooklyn").constraint(Predicates.notNull()).build();
    public static final ConfigKey<Boolean> PRIVILEGED = ConfigKeys.builder(Boolean.class).name("privileged").description("Whether the pods use privileged containers").defaultValue((Object)false).build();
    public static final ConfigKey<Map<String, ?>> ENV = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, ?>>(){}).name("env").description("Environment variables to inject when starting the container").defaultValue((Object)ImmutableMap.of()).constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> IMAGE = ConfigKeys.builder(String.class).name("image").description("Docker image to be deployed into the pod").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> OS_FAMILY = ConfigKeys.builder(String.class).name("osFamily").description("OS family, e.g. CentOS, Ubuntu").build();
    public static final ConfigKey<String> OS_VERSION_REGEX = ConfigKeys.builder(String.class).name("osVersionRegex").description("Regular expression for the OS version to load").build();
    public static final ConfigKey<KubernetesClientRegistry> KUBERNETES_CLIENT_REGISTRY = ConfigKeys.builder(KubernetesClientRegistry.class).name("kubernetesClientRegistry").description("Registry/Factory for creating Kubernetes client; default is almost always fine, except where tests want to customize behaviour").defaultValue((Object)KubernetesClientRegistryImpl.INSTANCE).build();
    public static final ConfigKey<String> LOGIN_USER = ConfigKeys.builder(String.class).name("loginUser").description("Override the user who logs in initially to perform setup").defaultValue((Object)"root").constraint(Predicates.notNull()).build();
    public static final ConfigKey<String> LOGIN_USER_PASSWORD = ConfigKeys.builder(String.class).name("loginUser.password").description("Custom password for the user who logs in initially").constraint(Predicates.notNull()).build();
    public static final ConfigKey<Boolean> INJECT_LOGIN_CREDENTIAL = ConfigKeys.builder(Boolean.class).name("injectLoginCredential").description("Whether to inject login credentials (if null, will infer from image choice); ignored if explicit 'loginUser.password' supplied").build();
}

