/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;

public class PrintableHistogram {
    private double[] bucketBoundaries;
    private int[] bucketCounts;
    private int totalCount = 0;

    public PrintableHistogram(double ... dArray) {
        Preconditions.checkState((dArray[0] != 0.0 ? 1 : 0) != 0);
        this.bucketBoundaries = new double[dArray.length + 2];
        this.bucketBoundaries[0] = 0.0;
        this.bucketCounts = new int[dArray.length + 2];
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                Preconditions.checkState((dArray[i] > dArray[i - 1] ? 1 : 0) != 0, (String)"Bucket %f must be greater than %f.", (Object[])new Object[]{dArray[i], dArray[i - 1]});
            }
            this.bucketCounts[i] = 0;
            this.bucketBoundaries[i + 1] = dArray[i];
        }
        this.bucketBoundaries[this.bucketBoundaries.length - 1] = 2.147483647E9;
    }

    public void addValue(double d) {
        this.addValue(d, 1);
    }

    public void addValue(double d, int n) {
        Preconditions.checkState((d >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.bucketBoundaries.length > 1 ? 1 : 0) != 0);
        int n2 = -1;
        for (double d2 : this.bucketBoundaries) {
            if (d <= d2) break;
            ++n2;
        }
        n2 = Math.max(0, n2);
        int n3 = n2 = Math.min(this.bucketCounts.length - 1, n2);
        this.bucketCounts[n3] = this.bucketCounts[n3] + n;
        this.totalCount += n;
    }

    public double getBucketRatio(int n) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n < this.bucketCounts.length ? 1 : 0) != 0);
        return (double)this.bucketCounts[n] / (double)this.totalCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Histogram: ");
        for (int i = 0; i < this.bucketCounts.length - 1; ++i) {
            stringBuilder.append(String.format("\n(%g - %g]\n\t", this.bucketBoundaries[i], this.bucketBoundaries[i + 1]));
            int n = 0;
            while ((double)n < this.getBucketRatio(i) * 100.0) {
                stringBuilder.append('#');
                ++n;
            }
            stringBuilder.append(String.format(" %.2g%% (%d)", this.getBucketRatio(i) * 100.0, this.bucketCounts[i]));
        }
        return stringBuilder.toString();
    }
}

