/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.util.Trees;
import org.openjdk.tools.javac.api.JavacTaskImpl;
import org.openjdk.tools.javac.api.JavacTool;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JavacMessages;
import org.openjdk.tools.jshell.ClassTracker;
import org.openjdk.tools.jshell.Diag;
import org.openjdk.tools.jshell.DiagList;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.MemoryFileManager;
import org.openjdk.tools.jshell.OuterWrap;
import org.openjdk.tools.jshell.ReplParserFactory;
import org.openjdk.tools.jshell.Unit;
import org.openjdk.tools.jshell.Util;

class TaskFactory {
    private final JavaCompiler compiler;
    private final MemoryFileManager fileManager;
    private final JShell state;
    private String classpath = System.getProperty("java.class.path");

    TaskFactory(JShell state) {
        this.state = state;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new UnsupportedOperationException("Compiler not available, must be run with full JDK 9.");
        }
        this.fileManager = new MemoryFileManager(this.compiler.getStandardFileManager(null, null, null), state);
    }

    void addToClasspath(String path) {
        this.classpath = this.classpath + File.pathSeparator + path;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.classpath);
        this.fileManager().handleOption("-classpath", args.iterator());
    }

    MemoryFileManager fileManager() {
        return this.fileManager;
    }

    abstract class BaseTask {
        final DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector();
        final JavacTaskImpl task;
        private DiagList diags = null;
        private final SourceHandler<?> sourceHandler;
        private final Context context = new Context();
        private Types types;
        private JavacMessages messages;
        private Trees trees;

        private <T> BaseTask(Stream<T> inputs, SourceHandler<T> sh, String ... extraOptions) {
            this.sourceHandler = sh;
            List<String> options = Arrays.asList(extraOptions);
            Iterable compilationUnits = inputs.map(in -> sh.sourceToFileObject(TaskFactory.this.fileManager, in)).collect(Collectors.toList());
            this.task = (JavacTaskImpl)((JavacTool)TaskFactory.this.compiler).getTask(null, TaskFactory.this.fileManager, this.diagnostics, options, null, compilationUnits, this.context);
        }

        abstract Iterable<? extends CompilationUnitTree> cuTrees();

        CompilationUnitTree firstCuTree() {
            return this.cuTrees().iterator().next();
        }

        Diag diag(Diagnostic<? extends JavaFileObject> diag) {
            return this.sourceHandler.diag(diag);
        }

        Context getContext() {
            return this.context;
        }

        Types types() {
            if (this.types == null) {
                this.types = Types.instance(this.context);
            }
            return this.types;
        }

        JavacMessages messages() {
            if (this.messages == null) {
                this.messages = JavacMessages.instance(this.context);
            }
            return this.messages;
        }

        Trees trees() {
            if (this.trees == null) {
                this.trees = Trees.instance(this.task);
            }
            return this.trees;
        }

        DiagList getDiagnostics() {
            if (this.diags == null) {
                LinkedHashMap<String, Diag> diagMap = new LinkedHashMap<String, Diag>();
                for (Diagnostic<JavaFileObject> in : this.diagnostics.getDiagnostics()) {
                    Diag d = this.diag(in);
                    String uniqueKey = d.getCode() + ":" + d.getPosition() + ":" + d.getMessage(Util.PARSED_LOCALE);
                    diagMap.put(uniqueKey, d);
                }
                this.diags = new DiagList(diagMap.values());
            }
            return this.diags;
        }

        boolean hasErrors() {
            return this.getDiagnostics().hasErrors();
        }

        String shortErrorMessage() {
            StringBuilder sb = new StringBuilder();
            for (Diag diag : this.getDiagnostics()) {
                for (String line : diag.getMessage(Util.PARSED_LOCALE).split("\\r?\\n")) {
                    if (line.trim().startsWith("location:")) continue;
                    sb.append(line);
                }
            }
            return sb.toString();
        }

        void debugPrintDiagnostics(String src) {
            for (Diag diag : this.getDiagnostics()) {
                TaskFactory.this.state.debug(1, "ERROR --\n", new Object[0]);
                for (String string : diag.getMessage(Util.PARSED_LOCALE).split("\\r?\\n")) {
                    if (string.trim().startsWith("location:")) continue;
                    TaskFactory.this.state.debug(1, "%s\n", string);
                }
                int start = (int)diag.getStartPosition();
                int end = (int)diag.getEndPosition();
                if (src != null) {
                    int i;
                    String[] srcLines;
                    for (String line2 : srcLines = src.split("\\r?\\n")) {
                        TaskFactory.this.state.debug(1, "%s\n", line2);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (i = 0; i < start; ++i) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('^');
                    if (end > start) {
                        for (i = start + 1; i < end; ++i) {
                            stringBuilder.append('-');
                        }
                        stringBuilder.append('^');
                    }
                    TaskFactory.this.state.debug(1, "%s\n", stringBuilder.toString());
                }
                TaskFactory.this.state.debug(1, "printDiagnostics start-pos = %d ==> %d -- wrap = %s\n", diag.getStartPosition(), start, this);
                TaskFactory.this.state.debug(1, "Code: %s\n", diag.getCode());
                TaskFactory.this.state.debug(1, "Pos: %d (%d - %d) -- %s\n", diag.getPosition(), diag.getStartPosition(), diag.getEndPosition(), diag.getMessage(null));
            }
        }
    }

    class CompileTask
    extends BaseTask {
        private final Map<Unit, List<MemoryFileManager.OutputMemoryJavaFileObject>> classObjs;

        CompileTask(Collection<Unit> units) {
            super((Stream)units.stream(), (SourceHandler)new UnitSourceHandler(), new String[]{"-Xlint:unchecked", "-proc:none"});
            this.classObjs = new HashMap<Unit, List<MemoryFileManager.OutputMemoryJavaFileObject>>();
        }

        boolean compile() {
            TaskFactory.this.fileManager.registerClassFileCreationListener(this::listenForNewClassFile);
            boolean result = this.task.call();
            TaskFactory.this.fileManager.registerClassFileCreationListener(null);
            return result;
        }

        List<ClassTracker.ClassInfo> classInfoList(Unit u) {
            List<MemoryFileManager.OutputMemoryJavaFileObject> l = this.classObjs.get(u);
            if (l == null) {
                return Collections.emptyList();
            }
            return l.stream().map(fo -> ((TaskFactory)TaskFactory.this).state.classTracker.classInfo(fo.getName(), fo.getBytes())).collect(Collectors.toList());
        }

        private void listenForNewClassFile(MemoryFileManager.OutputMemoryJavaFileObject jfo, JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            if (location == StandardLocation.CLASS_OUTPUT) {
                TaskFactory.this.state.debug(1, "Compiler generating class %s\n", className);
                Unit u = sibling instanceof MemoryFileManager.SourceMemoryJavaFileObject && ((MemoryFileManager.SourceMemoryJavaFileObject)sibling).getOrigin() instanceof Unit ? (Unit)((MemoryFileManager.SourceMemoryJavaFileObject)sibling).getOrigin() : null;
                this.classObjs.compute(u, (k, v) -> v == null ? new ArrayList() : v).add(jfo);
            }
        }

        @Override
        Iterable<? extends CompilationUnitTree> cuTrees() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    class AnalyzeTask
    extends BaseTask {
        private final Iterable<? extends CompilationUnitTree> cuts;

        AnalyzeTask(OuterWrap wrap) {
            this(Stream.of(wrap), this$0.new WrapSourceHandler(wrap), "-XDshouldStopPolicy=FLOW", "-proc:none");
        }

        AnalyzeTask(Collection<Unit> units) {
            this(units.stream(), this$0.new UnitSourceHandler(), "-XDshouldStopPolicy=FLOW", "-Xlint:unchecked", "-proc:none");
        }

        <T> AnalyzeTask(Stream<T> stream, SourceHandler<T> sourceHandler, String ... extraOptions) {
            super((Stream)stream, (SourceHandler)sourceHandler, extraOptions);
            this.cuts = this.analyze();
        }

        private Iterable<? extends CompilationUnitTree> analyze() {
            try {
                Iterable<? extends CompilationUnitTree> cuts = this.task.parse();
                this.task.analyze();
                return cuts;
            }
            catch (Exception ex) {
                throw new InternalError("Exception during analyze - " + ex.getMessage(), ex);
            }
        }

        @Override
        Iterable<? extends CompilationUnitTree> cuTrees() {
            return this.cuts;
        }

        Elements getElements() {
            return this.task.getElements();
        }

        javax.lang.model.util.Types getTypes() {
            return this.task.getTypes();
        }
    }

    class ParseTask
    extends BaseTask {
        private final Iterable<? extends CompilationUnitTree> cuts;
        private final List<? extends Tree> units;

        ParseTask(String source) {
            super((Stream)Stream.of(source), (SourceHandler)new StringSourceHandler(), new String[]{"-XDallowStringFolding=false", "-proc:none"});
            ReplParserFactory.instance(this.getContext());
            this.cuts = this.parse();
            this.units = Util.stream(this.cuts).flatMap(cut -> {
                List<? extends ImportTree> imps = cut.getImports();
                return (!imps.isEmpty() ? imps : cut.getTypeDecls()).stream();
            }).collect(Collectors.toList());
        }

        private Iterable<? extends CompilationUnitTree> parse() {
            try {
                return this.task.parse();
            }
            catch (Exception ex) {
                throw new InternalError("Exception during parse - " + ex.getMessage(), ex);
            }
        }

        List<? extends Tree> units() {
            return this.units;
        }

        @Override
        Iterable<? extends CompilationUnitTree> cuTrees() {
            return this.cuts;
        }
    }

    private class UnitSourceHandler
    implements SourceHandler<Unit> {
        private UnitSourceHandler() {
        }

        @Override
        public JavaFileObject sourceToFileObject(MemoryFileManager fm, Unit u) {
            return fm.createSourceFileObject(u, ((TaskFactory)TaskFactory.this).state.maps.classFullName(u.snippet()), u.snippet().outerWrap().wrapped());
        }

        @Override
        public Diag diag(Diagnostic<? extends JavaFileObject> d) {
            MemoryFileManager.SourceMemoryJavaFileObject smjfo = (MemoryFileManager.SourceMemoryJavaFileObject)d.getSource();
            Unit u = (Unit)smjfo.getOrigin();
            return u.snippet().outerWrap().wrapDiag(d);
        }
    }

    private class WrapSourceHandler
    implements SourceHandler<OuterWrap> {
        final OuterWrap wrap;

        WrapSourceHandler(OuterWrap wrap) {
            this.wrap = wrap;
        }

        @Override
        public JavaFileObject sourceToFileObject(MemoryFileManager fm, OuterWrap w) {
            return fm.createSourceFileObject(w, w.classFullName(), w.wrapped());
        }

        @Override
        public Diag diag(Diagnostic<? extends JavaFileObject> d) {
            return this.wrap.wrapDiag(d);
        }
    }

    private class StringSourceHandler
    implements SourceHandler<String> {
        private StringSourceHandler() {
        }

        @Override
        public JavaFileObject sourceToFileObject(MemoryFileManager fm, String src) {
            return fm.createSourceFileObject(src, "$NeverUsedName$", src);
        }

        @Override
        public Diag diag(final Diagnostic<? extends JavaFileObject> d) {
            return new Diag(){

                @Override
                public boolean isError() {
                    return d.getKind() == Diagnostic.Kind.ERROR;
                }

                @Override
                public long getPosition() {
                    return d.getPosition();
                }

                @Override
                public long getStartPosition() {
                    return d.getStartPosition();
                }

                @Override
                public long getEndPosition() {
                    return d.getEndPosition();
                }

                @Override
                public String getCode() {
                    return d.getCode();
                }

                @Override
                public String getMessage(Locale locale) {
                    return Util.expunge(d.getMessage(locale));
                }

                @Override
                Unit unitOrNull() {
                    return null;
                }
            };
        }
    }

    private static interface SourceHandler<T> {
        public JavaFileObject sourceToFileObject(MemoryFileManager var1, T var2);

        public Diag diag(Diagnostic<? extends JavaFileObject> var1);
    }
}

