/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.lease.exp;

import com.twitter.conversions.storage$;
import com.twitter.finagle.mux.lease.exp.GenerationalRandom;
import com.twitter.finagle.mux.lease.exp.JvmInfo;
import com.twitter.finagle.mux.lease.exp.LogsReceiver;
import com.twitter.finagle.mux.lease.exp.NullLogsReceiver$;
import com.twitter.finagle.mux.lease.exp.RequestSnooper;
import com.twitter.util.StorageUnit;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014Q!\u0001\u0002\u0001\t9\u00111\"T3n_JL8\u000b]1dK*\u00111\u0001B\u0001\u0004Kb\u0004(BA\u0003\u0007\u0003\u0015aW-Y:f\u0015\t9\u0001\"A\u0002nkbT!!\u0003\u0006\u0002\u000f\u0019Lg.Y4mK*\u00111\u0002D\u0001\bi^LG\u000f^3s\u0015\u0005i\u0011aA2p[N\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u0011!Q\u0001\na\tA!\u001b8g_\u000e\u0001\u0001CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005\u001dQe/\\%oM>D\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\f[&tG)[:d_VtG/F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011#\"\u0001\u0003vi&d\u0017B\u0001\u0013\"\u0005-\u0019Fo\u001c:bO\u0016,f.\u001b;\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\tA\"\\5o\t&\u001c8m\\;oi\u0002B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006IaH\u0001\f[\u0006DH)[:d_VtG\u000f\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003!\u00118K\\8pa\u0016\u0014\bCA\r-\u0013\ti#A\u0001\bSKF,Xm\u001d;T]>|\u0007/\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\n!\u0001\u001c:\u0011\u0005e\t\u0014B\u0001\u001a\u0003\u00051aunZ:SK\u000e,\u0017N^3s\u0011!!\u0004A!A!\u0002\u0013)\u0014a\u0001:oIB\u0011\u0011DN\u0005\u0003o\t\u0011!cR3oKJ\fG/[8oC2\u0014\u0016M\u001c3p[\")\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"ra\u000f\u001f>}}\u0002\u0015\t\u0005\u0002\u001a\u0001!)a\u0003\u000fa\u00011!)Q\u0004\u000fa\u0001?!)\u0001\u0006\u000fa\u0001?!)!\u0006\u000fa\u0001W!)q\u0006\u000fa\u0001a!)A\u0007\u000fa\u0001k!)\u0011\b\u0001C\u0001\u0007R11\bR#G\u000f\"CQA\u0006\"A\u0002aAQ!\b\"A\u0002}AQ\u0001\u000b\"A\u0002}AQA\u000b\"A\u0002-BQa\f\"A\u0002ABQ!\u000f\u0001\u0005\u0002)#RaO&M\u001b:CQAF%A\u0002aAQ!H%A\u0002}AQ\u0001K%A\u0002}AQAK%A\u0002-Ba\u0001\u0015\u0001!\u0002\u0013\t\u0016A\u00059sS:$\u0018M\u00197f5\u0016\u0014xNQ=uKN\u0004\"AU+\u000f\u0005A\u0019\u0016B\u0001+\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u000b\u0002\"B-\u0001\t\u0003Q\u0016\u0001\u00033jg\u000e|WO\u001c;\u0015\u0003}AQ\u0001\u0018\u0001\u0005\u0002y\tA\u0001\\3gi\")a\f\u0001C!?\u0006AAo\\*ue&tw\rF\u0001R\u0001")
public class MemorySpace {
    private final JvmInfo info;
    private final StorageUnit minDiscount;
    private final StorageUnit maxDiscount;
    private final RequestSnooper rSnooper;
    private final LogsReceiver lr;
    private final GenerationalRandom rnd;
    private final String printableZeroBytes;

    public StorageUnit minDiscount() {
        return this.minDiscount;
    }

    public StorageUnit discount() {
        StorageUnit storageUnit;
        StorageUnit handleBytes = this.rSnooper.handleBytes();
        this.lr.record("discountHandleBytes", handleBytes.toString());
        if (handleBytes.$less((Object)this.maxDiscount)) {
            StorageUnit low = handleBytes.max(this.minDiscount());
            StorageUnit discountWin = storage$.MODULE$.longToStorageUnitableWholeNumber((long)this.rnd.apply() % this.maxDiscount.$minus(low).inBytes()).bytes();
            this.lr.record("discountWin", discountWin.toString());
            StorageUnit discountTotal = low.$plus(discountWin);
            this.lr.record("discountTotal", discountTotal.toString());
            storageUnit = discountTotal;
        } else {
            this.lr.record("discountWin", this.printableZeroBytes);
            this.lr.record("discountTotal", this.printableZeroBytes);
            storageUnit = this.maxDiscount;
        }
        return storageUnit;
    }

    public StorageUnit left() {
        return this.info.remaining().$minus(this.minDiscount());
    }

    public String toString() {
        return new StringBuilder().append((Object)"MemorySpace(left=").append((Object)this.left()).append((Object)", discount=").append((Object)this.discount()).append((Object)", info=").append((Object)this.info).append((Object)")").toString();
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper, LogsReceiver lr, GenerationalRandom rnd) {
        this.info = info;
        this.minDiscount = minDiscount;
        this.maxDiscount = maxDiscount;
        this.rSnooper = rSnooper;
        this.lr = lr;
        this.rnd = rnd;
        this.printableZeroBytes = storage$.MODULE$.longToStorageUnitableWholeNumber(0L).bytes().toString();
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper, LogsReceiver lr) {
        this(info, minDiscount, maxDiscount, rSnooper, lr, new GenerationalRandom(info));
    }

    public MemorySpace(JvmInfo info, StorageUnit minDiscount, StorageUnit maxDiscount, RequestSnooper rSnooper) {
        this(info, minDiscount, maxDiscount, rSnooper, NullLogsReceiver$.MODULE$);
    }
}

