/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.controller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.server.controller.ControllerServerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ControllerConfigTest {
    File configFile;
    private static final int AnyTickTime = 1234;
    private static final int AnyPort = 1234;
    private static final String AnyDataDir = "temp";

    public static File createTempFile() throws IOException {
        return File.createTempFile(AnyDataDir, "cfg", new File(System.getProperty("user.dir")));
    }

    public static List<Integer> findNAvailablePorts(int n) throws IOException {
        ArrayList<ServerSocket> openedSockets = new ArrayList<ServerSocket>();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            ServerSocket randomSocket = new ServerSocket(0);
            openedSockets.add(randomSocket);
            ports.add(randomSocket.getLocalPort());
        }
        for (ServerSocket s : openedSockets) {
            s.close();
        }
        return ports;
    }

    public static void writeRequiredControllerConfig(File file, int controllerPort, int zkServerPort, int adminServerPort) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        writer.write("dataDir=anywhere\n");
        writer.write("controllerPort=" + controllerPort + "\n");
        writer.write("clientPort=" + zkServerPort + "\n");
        writer.write("adminPort=" + adminServerPort + "\n");
        writer.close();
    }

    @Before
    public void init() throws IOException {
        this.configFile = ControllerConfigTest.createTempFile();
    }

    private void writeFile(int portNumber) throws IOException {
        FileWriter writer = new FileWriter(this.configFile);
        writer.write("dataDir=somewhere\n");
        writer.write("ignore=me\n");
        writer.write("tickTime=1234\n");
        writer.write("controllerPort=" + portNumber + "\n");
        writer.write("clientPort=" + portNumber + "\n");
        writer.flush();
        writer.close();
    }

    @After
    public void cleanup() {
        if (this.configFile != null) {
            this.configFile.delete();
        }
    }

    @Test
    public void parseFileSucceeds() throws Exception {
        this.writeFile(1234);
        ControllerServerConfig config = new ControllerServerConfig(this.configFile.getAbsolutePath());
        Assert.assertEquals((long)1234L, (long)config.getControllerAddress().getPort());
        Assert.assertEquals((long)1234L, (long)config.getClientPortAddress().getPort());
        Assert.assertEquals((long)1234L, (long)config.getTickTime());
    }

    @Test
    public void parseFileFailsWithMissingPort() throws Exception {
        FileWriter writer = new FileWriter(this.configFile);
        writer.write("dataDir=somewhere\n");
        writer.flush();
        writer.close();
        try {
            ControllerServerConfig config = new ControllerServerConfig(this.configFile.getAbsolutePath());
            Assert.fail((String)"Should have thrown with missing server config");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void parseMissingFileThrows() {
        try {
            ControllerServerConfig config = new ControllerServerConfig("DontLookHere.missing");
            Assert.fail((String)"should have thrown");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void parseInvalidPortThrows() throws QuorumPeerConfig.ConfigException {
        try {
            ControllerServerConfig config = new ControllerServerConfig(this.configFile.getAbsolutePath());
            Assert.fail((String)"should have thrown");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void validCtor() {
        ControllerServerConfig config = new ControllerServerConfig(1234, 1234, AnyDataDir);
        Assert.assertEquals((long)1234L, (long)config.getControllerAddress().getPort());
        Assert.assertEquals((long)1234L, (long)config.getClientPortAddress().getPort());
        Assert.assertEquals((Object)AnyDataDir, (Object)config.getDataDir().getName());
    }

    @Test
    public void invalidCtor() {
        try {
            ControllerServerConfig config = new ControllerServerConfig(-10, -10, "no where");
            Assert.fail((String)"should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

