/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.OSMXBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMXBeanTest
extends ZKTestCase {
    private OSMXBean osMbean;
    private Long ofdc = 0L;
    private Long mfdc = 0L;
    protected static final Logger LOG = LoggerFactory.getLogger(OSMXBeanTest.class);

    @BeforeEach
    public void initialize() {
        this.osMbean = new OSMXBean();
        Assertions.assertNotNull((Object)this.osMbean, (String)"Could not initialize OSMXBean object!");
    }

    @Test
    public final void testGetUnix() {
        boolean isUnix = this.osMbean.getUnix();
        if (!isUnix) {
            LOG.info("Running in a Windows system! Output won't be printed!");
        } else {
            LOG.info("Running in a Unix or Linux system!");
        }
    }

    @Test
    public final void testGetOpenFileDescriptorCount() {
        if (this.osMbean != null && this.osMbean.getUnix()) {
            this.ofdc = this.osMbean.getOpenFileDescriptorCount();
            LOG.info("open fdcount is: {}", (Object)this.ofdc);
        }
        Assertions.assertFalse((this.ofdc < 0L ? 1 : 0) != 0, (String)"The number of open file descriptor is negative");
    }

    @Test
    public final void testGetMaxFileDescriptorCount() {
        if (this.osMbean != null && this.osMbean.getUnix()) {
            this.mfdc = this.osMbean.getMaxFileDescriptorCount();
            LOG.info("max fdcount is: {}", (Object)this.mfdc);
        }
        Assertions.assertFalse((this.mfdc < 0L ? 1 : 0) != 0, (String)"The max file descriptor number is negative");
    }
}

